/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.recipe;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.utils.VersionHelper;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class WandRecipeManager {
    private final Plugin plugin;
    private final WandItemManager wandItemManager;
    private FileConfiguration craftConfig;
    private final Set<NamespacedKey> registeredRecipes = new HashSet<NamespacedKey>();

    public WandRecipeManager(Plugin plugin, WandItemManager wandItemManager) {
        this.plugin = plugin;
        this.wandItemManager = wandItemManager;
        this.loadCraftConfig();
    }

    private void loadCraftConfig() {
        File craftFile = new File(this.plugin.getDataFolder(), "craft.yml");
        if (!craftFile.exists()) {
            this.plugin.saveResource("craft.yml", false);
        }
        this.craftConfig = YamlConfiguration.loadConfiguration((File)craftFile);
        this.checkAndUpdateCraftConfig(craftFile);
    }

    private void checkAndUpdateCraftConfig(File craftFile) {
        InputStream defaultStream = this.plugin.getResource("craft.yml");
        if (defaultStream == null) {
            return;
        }
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
        boolean updated = false;
        for (String key : defaultConfig.getKeys(true)) {
            if (this.craftConfig.contains(key)) continue;
            this.craftConfig.set(key, defaultConfig.get(key));
            updated = true;
        }
        if (updated) {
            try {
                this.craftConfig.save(craftFile);
                this.plugin.getLogger().info("craft.yml \u914d\u7f6e\u5df2\u66f4\u65b0");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u65e0\u6cd5\u4fdd\u5b58 craft.yml: " + e.getMessage());
            }
        }
    }

    public void registerAllRecipes() {
        ConfigurationSection recipesSection = this.craftConfig.getConfigurationSection("recipes");
        if (recipesSection == null) {
            this.registerDefaultRecipes();
            return;
        }
        int registered = 0;
        for (String recipeId : recipesSection.getKeys(false)) {
            ConfigurationSection recipeSection = recipesSection.getConfigurationSection(recipeId);
            if (recipeSection == null || !this.registerRecipeFromConfig(recipeId, recipeSection)) continue;
            ++registered;
        }
        this.plugin.getLogger().info("\u5df2\u4ece craft.yml \u6ce8\u518c " + registered + " \u4e2a\u5408\u6210\u914d\u65b9");
    }

    private void registerDefaultRecipes() {
        for (WandType type : WandType.values()) {
            this.registerDefaultRecipe(type);
        }
        this.plugin.getLogger().info("\u5df2\u6ce8\u518c " + WandType.values().length + " \u4e2a\u9ed8\u8ba4\u5efa\u7b51\u4e4b\u6756\u5408\u6210\u914d\u65b9");
    }

    private boolean registerRecipeFromConfig(String recipeId, ConfigurationSection config) {
        try {
            if (!config.getBoolean("enabled", true)) {
                this.plugin.getLogger().info("\u914d\u65b9 " + recipeId + " \u5df2\u7981\u7528\uff0c\u8df3\u8fc7\u6ce8\u518c");
                return false;
            }
            ConfigurationSection outputSection = config.getConfigurationSection("output");
            if (outputSection == null) {
                this.plugin.getLogger().warning("\u914d\u65b9 " + recipeId + " \u7f3a\u5c11 output \u914d\u7f6e");
                return false;
            }
            ItemStack outputItem = this.createOutputItem(recipeId, outputSection);
            if (outputItem == null) {
                return false;
            }
            NamespacedKey key = new NamespacedKey(this.plugin, "wand_" + recipeId);
            ShapedRecipe recipe = new ShapedRecipe(key, outputItem);
            List shape = config.getStringList("shape");
            if (shape.isEmpty() || shape.size() != 3) {
                this.plugin.getLogger().warning("\u914d\u65b9 " + recipeId + " \u7684 shape \u914d\u7f6e\u65e0\u6548");
                return false;
            }
            recipe.shape(new String[]{(String)shape.get(0), (String)shape.get(1), (String)shape.get(2)});
            ConfigurationSection ingredientsSection = config.getConfigurationSection("ingredients");
            if (ingredientsSection == null) {
                this.plugin.getLogger().warning("\u914d\u65b9 " + recipeId + " \u7f3a\u5c11 ingredients \u914d\u7f6e");
                return false;
            }
            for (String ingredientKey : ingredientsSection.getKeys(false)) {
                String materialName = null;
                Object ingredientValue = ingredientsSection.get(ingredientKey);
                if (ingredientValue instanceof String) {
                    materialName = (String)ingredientValue;
                } else {
                    ConfigurationSection ingredientConfig = ingredientsSection.getConfigurationSection(ingredientKey);
                    if (ingredientConfig != null) {
                        materialName = ingredientConfig.getString("material");
                    }
                }
                if (materialName == null) continue;
                Material material = Material.getMaterial((String)materialName.toUpperCase());
                if (material == null) {
                    this.plugin.getLogger().warning("\u914d\u65b9 " + recipeId + " \u4e2d\u7684\u6750\u6599 " + materialName + " \u65e0\u6548");
                    continue;
                }
                char ingredientChar = ingredientKey.charAt(0);
                recipe.setIngredient(ingredientChar, material);
            }
            Bukkit.addRecipe((Recipe)recipe);
            this.registeredRecipes.add(key);
            this.plugin.getLogger().info("\u5df2\u6ce8\u518c\u5408\u6210\u914d\u65b9: " + recipeId);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "\u6ce8\u518c\u914d\u65b9 " + recipeId + " \u5931\u8d25", e);
            return false;
        }
    }

    private ItemStack createOutputItem(String recipeId, ConfigurationSection outputConfig) {
        int customModelData;
        List loreList;
        WandType wandType;
        String materialName = outputConfig.getString("material");
        if (materialName == null) {
            this.plugin.getLogger().warning("\u914d\u65b9 " + recipeId + " \u7f3a\u5c11 material \u914d\u7f6e");
            return null;
        }
        Material material = Material.getMaterial((String)materialName.toUpperCase());
        if (material == null) {
            this.plugin.getLogger().warning("\u914d\u65b9 " + recipeId + " \u7684\u6750\u8d28 " + materialName + " \u65e0\u6548");
            return null;
        }
        String wandTypeId = null;
        ConfigurationSection pdcSection = outputConfig.getConfigurationSection("pdc");
        if (pdcSection != null) {
            wandTypeId = pdcSection.getString("wand_type");
        }
        if (wandTypeId != null && (wandType = WandType.fromId(wandTypeId)) != null) {
            int customModelData2 = outputConfig.getInt("custom-model-data", wandType.getCustomModelData());
            return this.wandItemManager.createWandWithMaterial(wandType, material, customModelData2);
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String name = outputConfig.getString("name", "");
        if (!name.isEmpty()) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        if (!(loreList = outputConfig.getStringList("lore")).isEmpty()) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : loreList) {
                coloredLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            meta.setLore(coloredLore);
        }
        if ((customModelData = outputConfig.getInt("custom-model-data", 0)) > 0) {
            VersionHelper.setCustomModelData(meta, customModelData);
        }
        if (pdcSection != null) {
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            for (String pdcKey : pdcSection.getKeys(false)) {
                Object value = pdcSection.get(pdcKey);
                NamespacedKey namespacedKey = new NamespacedKey(this.plugin, pdcKey);
                if (value instanceof String) {
                    pdc.set(namespacedKey, PersistentDataType.STRING, (Object)((String)value));
                    continue;
                }
                if (value instanceof Integer) {
                    pdc.set(namespacedKey, PersistentDataType.INTEGER, (Object)((Integer)value));
                    continue;
                }
                if (value instanceof Double) {
                    pdc.set(namespacedKey, PersistentDataType.DOUBLE, (Object)((Double)value));
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                pdc.set(namespacedKey, PersistentDataType.BYTE, (Object)((byte)((Boolean)value != false ? 1 : 0)));
            }
        }
        item.setItemMeta(meta);
        if (customModelData > 0) {
            VersionHelper.setCustomModelDataComponent(item, customModelData);
        }
        return item;
    }

    private void registerDefaultRecipe(WandType type) {
        ItemStack wandItem = this.wandItemManager.createWand(type);
        NamespacedKey key = new NamespacedKey(this.plugin, "wand_" + type.getId());
        ShapedRecipe recipe = new ShapedRecipe(key, wandItem);
        recipe.shape(new String[]{"  M", " S ", "S  "});
        recipe.setIngredient('S', Material.STICK);
        recipe.setIngredient('M', type.getCraftMaterial());
        try {
            Bukkit.addRecipe((Recipe)recipe);
            this.registeredRecipes.add(key);
            this.plugin.getLogger().info("\u5df2\u6ce8\u518c\u5408\u6210\u914d\u65b9: " + type.getDisplayName());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u6ce8\u518c\u5408\u6210\u914d\u65b9\u5931\u8d25: " + type.getDisplayName() + " - " + e.getMessage());
        }
    }

    public void unregisterAllRecipes() {
        for (NamespacedKey key : this.registeredRecipes) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        this.registeredRecipes.clear();
    }

    public void reloadRecipes() {
        this.unregisterAllRecipes();
        this.loadCraftConfig();
        this.registerAllRecipes();
    }

    public FileConfiguration getCraftConfig() {
        return this.craftConfig;
    }

    public ItemStack createWandFromConfig(WandType type) {
        ConfigurationSection recipesSection = this.craftConfig.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return this.wandItemManager.createWand(type);
        }
        ConfigurationSection recipeSection = recipesSection.getConfigurationSection(type.getId());
        if (recipeSection == null) {
            return this.wandItemManager.createWand(type);
        }
        ConfigurationSection outputSection = recipeSection.getConfigurationSection("output");
        if (outputSection == null) {
            return this.wandItemManager.createWand(type);
        }
        String materialName = outputSection.getString("material");
        if (materialName == null) {
            return this.wandItemManager.createWand(type);
        }
        Material material = Material.getMaterial((String)materialName.toUpperCase());
        if (material == null) {
            return this.wandItemManager.createWand(type);
        }
        int customModelData = outputSection.getInt("custom-model-data", type.getCustomModelData());
        return this.wandItemManager.createWandWithMaterial(type, material, customModelData);
    }

    public Material getConfiguredMaterial(WandType type) {
        ConfigurationSection recipesSection = this.craftConfig.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return type.getBaseMaterial();
        }
        ConfigurationSection recipeSection = recipesSection.getConfigurationSection(type.getId());
        if (recipeSection == null) {
            return type.getBaseMaterial();
        }
        ConfigurationSection outputSection = recipeSection.getConfigurationSection("output");
        if (outputSection == null) {
            return type.getBaseMaterial();
        }
        String materialName = outputSection.getString("material");
        if (materialName == null) {
            return type.getBaseMaterial();
        }
        Material material = Material.getMaterial((String)materialName.toUpperCase());
        return material != null ? material : type.getBaseMaterial();
    }

    public int getConfiguredCustomModelData(WandType type) {
        ConfigurationSection recipesSection = this.craftConfig.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return type.getCustomModelData();
        }
        ConfigurationSection recipeSection = recipesSection.getConfigurationSection(type.getId());
        if (recipeSection == null) {
            return type.getCustomModelData();
        }
        ConfigurationSection outputSection = recipeSection.getConfigurationSection("output");
        if (outputSection == null) {
            return type.getCustomModelData();
        }
        return outputSection.getInt("custom-model-data", type.getCustomModelData());
    }
}

