/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.protection;

import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.protection.WorldGuardHook;

public class ProtectionChecker {
    private final Plugin plugin;
    private WorldGuardHook worldGuardHook;
    private boolean useEventCheck = true;
    private boolean useWorldGuard = false;

    public ProtectionChecker(Plugin plugin) {
        this.plugin = plugin;
        this.initHooks();
    }

    private void initHooks() {
        String[] protectionPlugins;
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            try {
                this.worldGuardHook = new WorldGuardHook();
                this.useWorldGuard = true;
                this.plugin.getLogger().info("\u5df2\u68c0\u6d4b\u5230 WorldGuard\uff0c\u542f\u7528\u539f\u751f\u652f\u6301");
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "WorldGuard \u94a9\u5b50\u521d\u59cb\u5316\u5931\u8d25", e);
            }
        }
        for (String pluginName : protectionPlugins = new String[]{"Residence", "GriefPrevention", "Towny", "Lands", "PlotSquared", "RedProtect", "Factions", "FactionsUUID"}) {
            if (Bukkit.getPluginManager().getPlugin(pluginName) == null) continue;
            this.plugin.getLogger().info("\u5df2\u68c0\u6d4b\u5230 " + pluginName + "\uff0c\u5c06\u901a\u8fc7\u4e8b\u4ef6\u7cfb\u7edf\u517c\u5bb9");
        }
    }

    public boolean canPlace(Player player, Location location, Material material) {
        if (player.hasPermission("constructionwand.bypass")) {
            return true;
        }
        if (this.useEventCheck && !this.checkByEvent(player, location, material)) {
            return false;
        }
        return !this.useWorldGuard || this.worldGuardHook == null || this.worldGuardHook.canBuild(player, location);
    }

    private boolean checkByEvent(Player player, Location location, Material material) {
        try {
            Block block = location.getBlock();
            BlockState replacedState = block.getState();
            Block placedAgainst = block.getRelative(BlockFace.DOWN);
            if (placedAgainst.getType() == Material.AIR) {
                placedAgainst = block.getRelative(BlockFace.NORTH);
            }
            ItemStack itemInHand = new ItemStack(material);
            BlockPlaceEvent event = new BlockPlaceEvent(block, replacedState, placedAgainst, itemInHand, player, true, EquipmentSlot.HAND);
            Bukkit.getPluginManager().callEvent((Event)event);
            return !event.isCancelled();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "\u4e8b\u4ef6\u68c0\u67e5\u5931\u8d25", e);
            return true;
        }
    }

    public Location[] filterAllowedLocations(Player player, Location[] locations, Material material) {
        return (Location[])Arrays.stream(locations).filter(loc -> this.canPlace(player, (Location)loc, material)).toArray(Location[]::new);
    }

    public void setUseEventCheck(boolean useEventCheck) {
        this.useEventCheck = useEventCheck;
    }

    public void setUseWorldGuard(boolean useWorldGuard) {
        this.useWorldGuard = useWorldGuard && this.worldGuardHook != null;
    }

    public boolean isWorldGuardAvailable() {
        return this.worldGuardHook != null;
    }
}

