/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.preview;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.utils.VersionHelper;

public class PreviewManager {
    private final Plugin plugin;
    private final Map<UUID, List<Location>> playerPreviews = new HashMap<UUID, List<Location>>();
    private final Map<UUID, Integer> playerTaskIds = new HashMap<UUID, Integer>();
    private final Map<UUID, Material> playerMaterials = new HashMap<UUID, Material>();
    private final Map<UUID, PreviewMode> playerPreviewModes = new HashMap<UUID, PreviewMode>();
    private final Map<UUID, Particle.DustOptions> playerDustOptions = new HashMap<UUID, Particle.DustOptions>();
    private Particle.DustOptions dustOptions = new Particle.DustOptions(Color.RED, 0.8f);
    private PreviewMode defaultPreviewMode = PreviewMode.FULL;
    private static final int PARTICLE_DURATION_TICKS = 10;

    public PreviewManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void showPreview(Player player, List<Location> locations, Material material) {
        this.clearPreview(player);
        if (locations == null || locations.isEmpty()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.playerPreviews.put(playerId, new ArrayList<Location>(locations));
        this.playerMaterials.put(playerId, material);
        this.spawnPreviewParticles(player, locations);
    }

    public void updatePreview(Player player, List<Location> locations, Material material) {
        boolean sameLocations;
        if (locations == null || locations.isEmpty()) {
            this.clearPreview(player);
            return;
        }
        UUID playerId = player.getUniqueId();
        List<Location> currentLocations = this.playerPreviews.get(playerId);
        boolean bl = sameLocations = currentLocations != null && currentLocations.size() == locations.size() && this.locationsMatch(currentLocations, locations);
        if (!sameLocations) {
            this.playerPreviews.put(playerId, new ArrayList<Location>(locations));
            this.playerMaterials.put(playerId, material);
        }
        this.spawnPreviewParticles(player, locations);
    }

    private boolean locationsMatch(List<Location> list1, List<Location> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Location loc1 = list1.get(i);
            Location loc2 = list2.get(i);
            if (loc1.getBlockX() == loc2.getBlockX() && loc1.getBlockY() == loc2.getBlockY() && loc1.getBlockZ() == loc2.getBlockZ()) continue;
            return false;
        }
        return true;
    }

    public void refreshParticlePreview(Player player) {
        UUID playerId = player.getUniqueId();
        List<Location> locations = this.playerPreviews.get(playerId);
        if (locations == null || locations.isEmpty()) {
            return;
        }
        this.spawnPreviewParticles(player, locations);
    }

    private void spawnPreviewParticles(Player player, List<Location> locations) {
        PreviewMode mode = this.getPlayerPreviewMode(player);
        switch (mode.ordinal()) {
            case 2: {
                this.spawnAllCornerParticles(player, locations);
                break;
            }
            case 1: {
                this.spawnBoundingBoxParticles(player, locations);
                break;
            }
            default: {
                this.spawnAllFullOutlineParticles(player, locations);
            }
        }
    }

    private void spawnAllFullOutlineParticles(Player player, List<Location> locations) {
        if (locations == null || locations.isEmpty()) {
            return;
        }
        World world = locations.get(0).getWorld();
        if (world == null) {
            return;
        }
        ArrayList<Location> allParticles = new ArrayList<Location>();
        double step = 0.5;
        for (Location loc : locations) {
            double i;
            double x = loc.getBlockX();
            double y = loc.getBlockY();
            double z = loc.getBlockZ();
            for (i = 0.0; i <= 1.0; i += step) {
                allParticles.add(new Location(world, x + i, y, z));
                allParticles.add(new Location(world, x + i, y, z + 1.0));
                allParticles.add(new Location(world, x, y, z + i));
                allParticles.add(new Location(world, x + 1.0, y, z + i));
            }
            for (i = 0.0; i <= 1.0; i += step) {
                allParticles.add(new Location(world, x + i, y + 1.0, z));
                allParticles.add(new Location(world, x + i, y + 1.0, z + 1.0));
                allParticles.add(new Location(world, x, y + 1.0, z + i));
                allParticles.add(new Location(world, x + 1.0, y + 1.0, z + i));
            }
            for (i = 0.0; i <= 1.0; i += step) {
                allParticles.add(new Location(world, x, y + i, z));
                allParticles.add(new Location(world, x + 1.0, y + i, z));
                allParticles.add(new Location(world, x, y + i, z + 1.0));
                allParticles.add(new Location(world, x + 1.0, y + i, z + 1.0));
            }
        }
        this.spawnParticlesBatch(player, allParticles);
    }

    private void spawnAllCornerParticles(Player player, List<Location> locations) {
        if (locations == null || locations.isEmpty()) {
            return;
        }
        World world = locations.get(0).getWorld();
        if (world == null) {
            return;
        }
        ArrayList<Location> allParticles = new ArrayList<Location>();
        for (Location loc : locations) {
            double x = loc.getBlockX();
            double y = loc.getBlockY();
            double z = loc.getBlockZ();
            allParticles.add(new Location(world, x, y, z));
            allParticles.add(new Location(world, x + 1.0, y, z));
            allParticles.add(new Location(world, x, y, z + 1.0));
            allParticles.add(new Location(world, x + 1.0, y, z + 1.0));
            allParticles.add(new Location(world, x, y + 1.0, z));
            allParticles.add(new Location(world, x + 1.0, y + 1.0, z));
            allParticles.add(new Location(world, x, y + 1.0, z + 1.0));
            allParticles.add(new Location(world, x + 1.0, y + 1.0, z + 1.0));
        }
        this.spawnParticlesBatch(player, allParticles);
    }

    private void spawnBoundingBoxParticles(Player player, List<Location> locations) {
        if (locations == null || locations.isEmpty()) {
            return;
        }
        World world = locations.get(0).getWorld();
        if (world == null) {
            return;
        }
        HashSet<CallSite> blockSet = new HashSet<CallSite>();
        for (Location loc : locations) {
            blockSet.add((CallSite)((Object)(loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ())));
        }
        HashSet<String> edgeSet = new HashSet<String>();
        ArrayList<Location> particleLocations = new ArrayList<Location>();
        double step = 0.5;
        for (Location loc : locations) {
            int edge_x1z1y;
            int edge_x0z1y;
            int edge_x1z0y;
            int edge_x0z0y;
            int edge_y1z1x;
            int edge_y1z0x;
            int edge_x1y1z;
            int edge_x0y1z;
            int edge_y0z1x;
            int edge_y0z0x;
            int edge_x1y0z;
            int x = loc.getBlockX();
            int y = loc.getBlockY();
            int z = loc.getBlockZ();
            boolean hasNegX = blockSet.contains(x - 1 + "," + y + "," + z);
            boolean hasPosX = blockSet.contains(x + 1 + "," + y + "," + z);
            boolean hasNegY = blockSet.contains(x + "," + (y - 1) + "," + z);
            boolean hasPosY = blockSet.contains(x + "," + (y + 1) + "," + z);
            boolean hasNegZ = blockSet.contains(x + "," + y + "," + (z - 1));
            boolean hasPosZ = blockSet.contains(x + "," + y + "," + (z + 1));
            int edge_x0y0z = (!hasNegX ? 1 : 0) + (!hasNegY ? 1 : 0);
            if (edge_x0y0z >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y, z, x, y, z + 1, step);
            }
            if ((edge_x1y0z = (!hasPosX ? 1 : 0) + (!hasNegY ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x + 1, y, z, x + 1, y, z + 1, step);
            }
            if ((edge_y0z0x = (!hasNegY ? 1 : 0) + (!hasNegZ ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y, z, x + 1, y, z, step);
            }
            if ((edge_y0z1x = (!hasNegY ? 1 : 0) + (!hasPosZ ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y, z + 1, x + 1, y, z + 1, step);
            }
            if ((edge_x0y1z = (!hasNegX ? 1 : 0) + (!hasPosY ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y + 1, z, x, y + 1, z + 1, step);
            }
            if ((edge_x1y1z = (!hasPosX ? 1 : 0) + (!hasPosY ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x + 1, y + 1, z, x + 1, y + 1, z + 1, step);
            }
            if ((edge_y1z0x = (!hasPosY ? 1 : 0) + (!hasNegZ ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y + 1, z, x + 1, y + 1, z, step);
            }
            if ((edge_y1z1x = (!hasPosY ? 1 : 0) + (!hasPosZ ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y + 1, z + 1, x + 1, y + 1, z + 1, step);
            }
            if ((edge_x0z0y = (!hasNegX ? 1 : 0) + (!hasNegZ ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y, z, x, y + 1, z, step);
            }
            if ((edge_x1z0y = (!hasPosX ? 1 : 0) + (!hasNegZ ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x + 1, y, z, x + 1, y + 1, z, step);
            }
            if ((edge_x0z1y = (!hasNegX ? 1 : 0) + (!hasPosZ ? 1 : 0)) >= 2) {
                this.addEdgeParticles(edgeSet, particleLocations, world, x, y, z + 1, x, y + 1, z + 1, step);
            }
            if ((edge_x1z1y = (!hasPosX ? 1 : 0) + (!hasPosZ ? 1 : 0)) < 2) continue;
            this.addEdgeParticles(edgeSet, particleLocations, world, x + 1, y, z + 1, x + 1, y + 1, z + 1, step);
        }
        this.spawnParticlesBatch(player, particleLocations);
    }

    private void addEdgeParticles(Set<String> edgeSet, List<Location> particles, World world, double x1, double y1, double z1, double x2, double y2, double z2, double step) {
        String edgeKey = x1 < x2 || x1 == x2 && y1 < y2 || x1 == x2 && y1 == y2 && z1 < z2 ? x1 + "," + y1 + "," + z1 + "-" + x2 + "," + y2 + "," + z2 : x2 + "," + y2 + "," + z2 + "-" + x1 + "," + y1 + "," + z1;
        if (edgeSet.contains(edgeKey)) {
            return;
        }
        edgeSet.add(edgeKey);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (length == 0.0) {
            return;
        }
        int numParticles = (int)Math.ceil(length / step) + 1;
        for (int i = 0; i <= numParticles; ++i) {
            double t = (double)i / (double)numParticles;
            double px = x1 + dx * t;
            double py = y1 + dy * t;
            double pz = z1 + dz * t;
            particles.add(new Location(world, px, py, pz));
        }
    }

    private void spawnFullOutlineParticles(Player player, Location loc) {
        double i;
        World world = loc.getWorld();
        if (world == null) {
            return;
        }
        double x = loc.getBlockX();
        double y = loc.getBlockY();
        double z = loc.getBlockZ();
        ArrayList<Location> particleLocations = new ArrayList<Location>();
        double step = 0.5;
        for (i = 0.0; i <= 1.0; i += step) {
            particleLocations.add(new Location(world, x + i, y, z));
            particleLocations.add(new Location(world, x + i, y, z + 1.0));
            particleLocations.add(new Location(world, x, y, z + i));
            particleLocations.add(new Location(world, x + 1.0, y, z + i));
        }
        for (i = 0.0; i <= 1.0; i += step) {
            particleLocations.add(new Location(world, x + i, y + 1.0, z));
            particleLocations.add(new Location(world, x + i, y + 1.0, z + 1.0));
            particleLocations.add(new Location(world, x, y + 1.0, z + i));
            particleLocations.add(new Location(world, x + 1.0, y + 1.0, z + i));
        }
        for (i = 0.0; i <= 1.0; i += step) {
            particleLocations.add(new Location(world, x, y + i, z));
            particleLocations.add(new Location(world, x + 1.0, y + i, z));
            particleLocations.add(new Location(world, x, y + i, z + 1.0));
            particleLocations.add(new Location(world, x + 1.0, y + i, z + 1.0));
        }
        this.spawnParticlesBatch(player, particleLocations);
    }

    private void spawnCornerParticles(Player player, Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return;
        }
        double x = loc.getBlockX();
        double y = loc.getBlockY();
        double z = loc.getBlockZ();
        ArrayList<Location> particleLocations = new ArrayList<Location>();
        particleLocations.add(new Location(world, x, y, z));
        particleLocations.add(new Location(world, x + 1.0, y, z));
        particleLocations.add(new Location(world, x, y, z + 1.0));
        particleLocations.add(new Location(world, x + 1.0, y, z + 1.0));
        particleLocations.add(new Location(world, x, y + 1.0, z));
        particleLocations.add(new Location(world, x + 1.0, y + 1.0, z));
        particleLocations.add(new Location(world, x, y + 1.0, z + 1.0));
        particleLocations.add(new Location(world, x + 1.0, y + 1.0, z + 1.0));
        this.spawnParticlesBatch(player, particleLocations);
    }

    private void spawnParticlesBatch(Player player, List<Location> locations) {
        if (locations == null || locations.isEmpty()) {
            return;
        }
        Particle.DustOptions playerOptions = this.getPlayerDustOptions(player);
        try {
            for (Location loc : locations) {
                player.spawnParticle(Particle.DUST, loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)playerOptions);
            }
        }
        catch (Exception e) {
            try {
                for (Location loc : locations) {
                    player.spawnParticle(Particle.valueOf((String)"REDSTONE"), loc, 1, 0.0, 0.0, 0.0, 0.0, (Object)this.dustOptions);
                }
            }
            catch (Exception e2) {
                try {
                    for (Location loc : locations) {
                        player.spawnParticle(Particle.FLAME, loc, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void spawnParticle(Player player, World world, double x, double y, double z) {
        Location particleLoc = new Location(world, x, y, z);
        try {
            player.spawnParticle(Particle.DUST, particleLoc, 1, 0.0, 0.0, 0.0, 0.0, (Object)this.dustOptions);
        }
        catch (Exception e) {
            try {
                player.spawnParticle(Particle.valueOf((String)"REDSTONE"), particleLoc, 1, 0.0, 0.0, 0.0, 0.0, (Object)this.dustOptions);
            }
            catch (Exception e2) {
                try {
                    player.spawnParticle(Particle.FLAME, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void clearPreview(Player player) {
        UUID playerId = player.getUniqueId();
        this.playerPreviews.remove(playerId);
        this.playerMaterials.remove(playerId);
        Integer taskId = this.playerTaskIds.remove(playerId);
        if (taskId != null && !VersionHelper.isFolia()) {
            Bukkit.getScheduler().cancelTask(taskId.intValue());
        }
    }

    public void clearAllPreviews() {
        for (UUID playerId : new HashSet<UUID>(this.playerPreviews.keySet())) {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            this.clearPreview(player);
        }
        this.playerPreviews.clear();
        this.playerTaskIds.clear();
    }

    public List<Location> getPreviewLocations(Player player) {
        return this.playerPreviews.getOrDefault(player.getUniqueId(), Collections.emptyList());
    }

    public void setPreviewColor(Color color) {
        this.dustOptions = new Particle.DustOptions(color, 0.8f);
    }

    public void setPreviewMode(PreviewMode mode) {
        this.defaultPreviewMode = mode;
    }

    public PreviewMode getPreviewMode() {
        return this.defaultPreviewMode;
    }

    public void setPlayerPreviewMode(Player player, PreviewMode mode) {
        this.playerPreviewModes.put(player.getUniqueId(), mode);
    }

    public PreviewMode getPlayerPreviewMode(Player player) {
        return this.playerPreviewModes.getOrDefault(player.getUniqueId(), this.defaultPreviewMode);
    }

    public PreviewMode togglePlayerPreviewMode(Player player) {
        PreviewMode current = this.getPlayerPreviewMode(player);
        PreviewMode next = switch (current.ordinal()) {
            case 0 -> PreviewMode.CORNERS;
            case 2 -> PreviewMode.OUTLINE;
            default -> PreviewMode.FULL;
        };
        this.setPlayerPreviewMode(player, next);
        return next;
    }

    public void setPlayerPreviewColor(Player player, Color color) {
        this.playerDustOptions.put(player.getUniqueId(), new Particle.DustOptions(color, 0.8f));
    }

    public Particle.DustOptions getPlayerDustOptions(Player player) {
        return this.playerDustOptions.getOrDefault(player.getUniqueId(), this.dustOptions);
    }

    public Color getPlayerPreviewColor(Player player) {
        Particle.DustOptions options = this.playerDustOptions.get(player.getUniqueId());
        return options != null ? options.getColor() : this.dustOptions.getColor();
    }

    public static enum PreviewMode {
        FULL,
        OUTLINE,
        CORNERS;

    }
}

