/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.listener;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.little100.constructionWand.enchant.EnchantmentManager;
import org.little100.constructionWand.enchant.WandEnchantment;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.utils.VersionHelper;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class ItemProtectionListener
implements Listener {
    private final WandItemManager wandItemManager;
    private final I18nManager i18n;
    private EnchantmentManager enchantmentManager;
    private final Random random = new Random();

    public ItemProtectionListener(WandItemManager wandItemManager, I18nManager i18n) {
        this.wandItemManager = wandItemManager;
        this.i18n = i18n;
    }

    public void setEnchantmentManager(EnchantmentManager enchantmentManager) {
        this.enchantmentManager = enchantmentManager;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEnchantItem(EnchantItemEvent event) {
        int enchantLevel;
        ItemStack item = event.getItem();
        if (!this.wandItemManager.isWand(item)) {
            return;
        }
        if (this.enchantmentManager == null) {
            return;
        }
        int expLevelCost = event.getExpLevelCost();
        int finalLevel = enchantLevel = this.calculateEnchantLevel(expLevelCost);
        Bukkit.getScheduler().runTaskLater(Bukkit.getPluginManager().getPlugin("ConstructionWand"), () -> this.enchantmentManager.addEnchantment(item, WandEnchantment.BUILDING_EXTENSION, finalLevel), 1L);
    }

    private int calculateEnchantLevel(int expLevelCost) {
        if (expLevelCost <= 10) {
            return this.random.nextInt(100) < 80 ? 1 : 2;
        }
        if (expLevelCost <= 20) {
            int roll = this.random.nextInt(100);
            if (roll < 40) {
                return 1;
            }
            if (roll < 80) {
                return 2;
            }
            return 3;
        }
        if (expLevelCost <= 25) {
            int roll = this.random.nextInt(100);
            if (roll < 20) {
                return 1;
            }
            if (roll < 50) {
                return 2;
            }
            if (roll < 80) {
                return 3;
            }
            return 4;
        }
        int roll = this.random.nextInt(100);
        if (roll < 10) {
            return 1;
        }
        if (roll < 30) {
            return 2;
        }
        if (roll < 60) {
            return 3;
        }
        if (roll < 85) {
            return 4;
        }
        return 5;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        WandType firstType;
        AnvilInventory anvil = event.getInventory();
        ItemStack firstItem = anvil.getItem(0);
        ItemStack secondItem = anvil.getItem(1);
        ItemStack result = event.getResult();
        if (firstItem != null && this.wandItemManager.isWand(firstItem) && (firstType = this.wandItemManager.getWandType(firstItem)) != null) {
            if (secondItem != null && secondItem.getType() != Material.AIR) {
                if (this.wandItemManager.isWand(secondItem)) {
                    WandType secondType = this.wandItemManager.getWandType(secondItem);
                    if (secondType != firstType) {
                        event.setResult(null);
                        return;
                    }
                    if (firstType.isUnbreakable()) {
                        event.setResult(null);
                        return;
                    }
                    ItemStack mergedWand = this.createMergedWand(firstItem, secondItem, firstType);
                    event.setResult(mergedWand);
                    return;
                }
                if (secondItem.getType() == Material.ENCHANTED_BOOK) {
                    if (result != null && result.getType() != Material.AIR) {
                        this.preserveWandData(result, firstType);
                        event.setResult(result);
                    }
                    return;
                }
                event.setResult(null);
                return;
            }
            if (result != null && result.getType() != Material.AIR) {
                this.preserveWandData(result, firstType);
                event.setResult(result);
            }
        }
        if (secondItem != null && this.wandItemManager.isWand(secondItem) && (firstItem == null || !this.wandItemManager.isWand(firstItem))) {
            event.setResult(null);
        }
    }

    private ItemStack createMergedWand(ItemStack first, ItemStack second, WandType type) {
        ItemStack result = first.clone();
        ItemMeta resultMeta = result.getItemMeta();
        if (resultMeta instanceof Damageable && !type.isUnbreakable()) {
            Damageable resultDamageable = (Damageable)resultMeta;
            int firstDamage = resultDamageable.getDamage();
            int firstRemaining = type.getMaxDurability() - firstDamage;
            ItemMeta secondMeta = second.getItemMeta();
            int secondRemaining = type.getMaxDurability();
            if (secondMeta instanceof Damageable) {
                int secondDamage = ((Damageable)secondMeta).getDamage();
                secondRemaining = type.getMaxDurability() - secondDamage;
            }
            int totalRemaining = firstRemaining + secondRemaining;
            int bonus = (int)((double)type.getMaxDurability() * 0.05);
            totalRemaining = Math.min(totalRemaining + bonus, type.getMaxDurability());
            int newDamage = type.getMaxDurability() - totalRemaining;
            resultDamageable.setDamage(Math.max(0, newDamage));
            if (secondMeta != null) {
                Map secondEnchants = secondMeta.getEnchants();
                for (Map.Entry entry : secondEnchants.entrySet()) {
                    Enchantment enchant = (Enchantment)entry.getKey();
                    int level = (Integer)entry.getValue();
                    if (resultMeta.hasEnchant(enchant)) {
                        int currentLevel = resultMeta.getEnchantLevel(enchant);
                        if (level == currentLevel && level < enchant.getMaxLevel()) {
                            resultMeta.addEnchant(enchant, level + 1, true);
                            continue;
                        }
                        if (level <= currentLevel) continue;
                        resultMeta.addEnchant(enchant, level, true);
                        continue;
                    }
                    resultMeta.addEnchant(enchant, level, true);
                }
            }
        }
        this.preserveWandData(resultMeta, type);
        result.setItemMeta(resultMeta);
        return result;
    }

    private void preserveWandData(ItemStack item, WandType type) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            this.preserveWandData(meta, type);
            item.setItemMeta(meta);
        }
    }

    private void preserveWandData(ItemMeta meta, WandType type) {
        VersionHelper.setCustomModelData(meta, type.getCustomModelData());
        meta.getPersistentDataContainer().set(this.wandItemManager.getWandTypeKey(), PersistentDataType.STRING, (Object)type.getId());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        ItemStack[] matrix = inventory.getMatrix();
        ArrayList<ItemStack> wands = new ArrayList<ItemStack>();
        WandType wandType = null;
        boolean hasOtherItems = false;
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            if (this.wandItemManager.isWand(item)) {
                WandType type = this.wandItemManager.getWandType(item);
                if (wandType == null) {
                    wandType = type;
                } else if (type != wandType) {
                    inventory.setResult(null);
                    return;
                }
                wands.add(item);
                continue;
            }
            hasOtherItems = true;
        }
        if (!wands.isEmpty() && hasOtherItems) {
            inventory.setResult(null);
            return;
        }
        if (wands.size() == 2 && wandType != null && !wandType.isUnbreakable()) {
            ItemStack mergedWand = this.createMergedWand((ItemStack)wands.get(0), (ItemStack)wands.get(1), wandType);
            inventory.setResult(mergedWand);
            return;
        }
        if (wands.size() == 1 || wands.size() > 2) {
            inventory.setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack cursor;
        if (event.getInventory().getType() == InventoryType.GRINDSTONE) {
            ItemStack cursor2;
            ItemStack item = event.getCurrentItem();
            if (item != null && this.wandItemManager.isWand(item) && event.getClickedInventory() != null && event.getClickedInventory().getType() == InventoryType.GRINDSTONE && event.getSlot() < 2 && (cursor2 = event.getCursor()) != null && this.wandItemManager.isWand(cursor2)) {
                event.setCancelled(true);
                if (event.getWhoClicked() instanceof Player) {
                    ((Player)event.getWhoClicked()).sendMessage(this.i18n.get("message.cannot-grindstone"));
                }
            }
            if ((cursor2 = event.getCursor()) != null && this.wandItemManager.isWand(cursor2) && event.getClickedInventory() != null && event.getClickedInventory().getType() == InventoryType.GRINDSTONE && event.getSlot() < 2) {
                event.setCancelled(true);
                if (event.getWhoClicked() instanceof Player) {
                    ((Player)event.getWhoClicked()).sendMessage(this.i18n.get("message.cannot-grindstone"));
                }
            }
        }
        if (event.getInventory().getType() == InventoryType.SMITHING && (cursor = event.getCursor()) != null && this.wandItemManager.isWand(cursor) && event.getClickedInventory() != null && event.getClickedInventory().getType() == InventoryType.SMITHING) {
            event.setCancelled(true);
        }
    }
}

