/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.wand;

import org.bukkit.Material;

public enum WandType {
    STONE("stone", "\u77f3\u5236\u5efa\u7b51\u4e4b\u6756", Material.STONE_PICKAXE, Material.COBBLESTONE, 131, 9, 101, "constructionwand.use.stone"),
    IRON("iron", "\u94c1\u5236\u5efa\u7b51\u4e4b\u6756", Material.IRON_PICKAXE, Material.IRON_INGOT, 250, 27, 101, "constructionwand.use.iron"),
    DIAMOND("diamond", "\u94bb\u77f3\u5efa\u7b51\u4e4b\u6756", Material.DIAMOND_PICKAXE, Material.DIAMOND, 1561, 128, 101, "constructionwand.use.diamond"),
    NETHERITE("netherite", "\u4e0b\u754c\u5408\u91d1\u5efa\u7b51\u4e4b\u6756", Material.NETHERITE_PICKAXE, Material.NETHERITE_INGOT, 2031, 256, 101, "constructionwand.use.netherite"),
    INFINITY("infinity", "\u65e0\u9650\u5efa\u7b51\u4e4b\u6756", Material.NETHERITE_PICKAXE, Material.NETHER_STAR, -1, 1024, 102, "constructionwand.use.infinity");

    private final String id;
    private final String displayName;
    private final Material baseMaterial;
    private final Material craftMaterial;
    private final int maxDurability;
    private final int maxBlocks;
    private final int customModelData;
    private final String permission;

    private WandType(String id, String displayName, Material baseMaterial, Material craftMaterial, int maxDurability, int maxBlocks, int customModelData, String permission) {
        this.id = id;
        this.displayName = displayName;
        this.baseMaterial = baseMaterial;
        this.craftMaterial = craftMaterial;
        this.maxDurability = maxDurability;
        this.maxBlocks = maxBlocks;
        this.customModelData = customModelData;
        this.permission = permission;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Material getBaseMaterial() {
        return this.baseMaterial;
    }

    public Material getCraftMaterial() {
        return this.craftMaterial;
    }

    public int getMaxDurability() {
        return this.maxDurability;
    }

    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean isUnbreakable() {
        return this.maxDurability == -1;
    }

    public static WandType fromId(String id) {
        for (WandType type : WandType.values()) {
            if (!type.getId().equalsIgnoreCase(id)) continue;
            return type;
        }
        return null;
    }

    public static WandType fromMaterialAndModelData(Material material, int modelData) {
        for (WandType type : WandType.values()) {
            if (type.getBaseMaterial() != material || type.getCustomModelData() != modelData) continue;
            return type;
        }
        return null;
    }
}

