/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.protection;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardHook {
    private Object worldGuard;
    private boolean available = false;

    public WorldGuardHook() {
        try {
            Class<?> worldGuardClass = Class.forName("com.sk89q.worldguard.WorldGuard");
            this.worldGuard = worldGuardClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            this.available = true;
        }
        catch (Exception e) {
            this.available = false;
        }
    }

    public boolean canBuild(Player player, Location location) {
        if (!this.available || this.worldGuard == null) {
            return true;
        }
        try {
            Class<?> worldGuardClass = Class.forName("com.sk89q.worldguard.WorldGuard");
            Object platform = worldGuardClass.getMethod("getPlatform", new Class[0]).invoke(this.worldGuard, new Object[0]);
            Object regionContainer = platform.getClass().getMethod("getRegionContainer", new Class[0]).invoke(platform, new Object[0]);
            Object query = regionContainer.getClass().getMethod("createQuery", new Class[0]).invoke(regionContainer, new Object[0]);
            Class<?> bukkitAdapterClass = Class.forName("com.sk89q.worldedit.bukkit.BukkitAdapter");
            Object weLocation = bukkitAdapterClass.getMethod("adapt", Location.class).invoke(null, location);
            Object localPlayer = bukkitAdapterClass.getMethod("adapt", Player.class).invoke(null, player);
            Class<?> flagsClass = Class.forName("com.sk89q.worldguard.protection.flags.Flags");
            Object buildFlag = flagsClass.getField("BUILD").get(null);
            Class<?> stateFlagClass = Class.forName("com.sk89q.worldguard.protection.flags.StateFlag");
            Method testStateMethod = query.getClass().getMethod("testState", Class.forName("com.sk89q.worldedit.util.Location"), Class.forName("com.sk89q.worldguard.protection.association.RegionAssociable"), Array.newInstance(stateFlagClass, 0).getClass());
            Object flagArray = Array.newInstance(stateFlagClass, 1);
            Array.set(flagArray, 0, buildFlag);
            Object result = testStateMethod.invoke(query, weLocation, localPlayer, flagArray);
            return (Boolean)result;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }
}

