/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.hook;

import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class MagicBlockHook {
    private static boolean enabled = false;
    private static Plugin magicBlockPlugin = null;
    private static Object blockManager = null;
    private static Method isMagicBlockMethod = null;
    private static Method getUseTimesMethod = null;
    private static Method decrementUseTimesMethod = null;
    private static Method getMaxUseTimesMethod = null;

    public static boolean init(Plugin plugin) {
        try {
            magicBlockPlugin = Bukkit.getPluginManager().getPlugin("MagicBlock");
            if (magicBlockPlugin == null || !magicBlockPlugin.isEnabled()) {
                plugin.getLogger().info("MagicBlock \u63d2\u4ef6\u672a\u627e\u5230\u6216\u672a\u542f\u7528\uff0c\u8df3\u8fc7\u9002\u914d");
                return false;
            }
            Method getBlockManagerMethod = magicBlockPlugin.getClass().getMethod("getBlockManager", new Class[0]);
            blockManager = getBlockManagerMethod.invoke((Object)magicBlockPlugin, new Object[0]);
            if (blockManager == null) {
                plugin.getLogger().warning("\u65e0\u6cd5\u83b7\u53d6 MagicBlock \u7684 BlockManager");
                return false;
            }
            Class<?> blockManagerClass = blockManager.getClass();
            isMagicBlockMethod = blockManagerClass.getMethod("isMagicBlock", ItemStack.class);
            getUseTimesMethod = blockManagerClass.getMethod("getUseTimes", ItemStack.class);
            decrementUseTimesMethod = blockManagerClass.getMethod("decrementUseTimes", ItemStack.class);
            getMaxUseTimesMethod = blockManagerClass.getMethod("getMaxUseTimes", ItemStack.class);
            enabled = true;
            plugin.getLogger().info("MagicBlock \u9002\u914d\u5668\u5df2\u6210\u529f\u521d\u59cb\u5316\uff01");
            return true;
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.WARNING, "\u521d\u59cb\u5316 MagicBlock \u9002\u914d\u5668\u5931\u8d25: " + e.getMessage());
            enabled = false;
            return false;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isMagicBlock(ItemStack item) {
        if (!enabled || item == null || blockManager == null) {
            return false;
        }
        try {
            return (Boolean)isMagicBlockMethod.invoke(blockManager, item);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getUseTimes(ItemStack item) {
        if (!enabled || item == null || blockManager == null) {
            return 0;
        }
        try {
            int times = (Integer)getUseTimesMethod.invoke(blockManager, item);
            if (times >= 2147483547) {
                return -1;
            }
            return times;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getMaxUseTimes(ItemStack item) {
        if (!enabled || item == null || blockManager == null) {
            return 0;
        }
        try {
            int times = (Integer)getMaxUseTimesMethod.invoke(blockManager, item);
            if (times >= 2147483547) {
                return -1;
            }
            return times;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int decrementUseTimes(ItemStack item) {
        if (!enabled || item == null || blockManager == null) {
            return 0;
        }
        try {
            return (Integer)decrementUseTimesMethod.invoke(blockManager, item);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static ItemStack findMagicBlockInInventory(Player player, Material material) {
        if (!enabled || player == null || material == null) {
            return null;
        }
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : inventory.getContents()) {
            int useTimes;
            if (item == null || item.getType() != material || !MagicBlockHook.isMagicBlock(item) || (useTimes = MagicBlockHook.getUseTimes(item)) != -1 && useTimes <= 0) continue;
            return item;
        }
        return null;
    }

    public static int countMagicBlockUsesInInventory(Player player, Material material) {
        if (!enabled || player == null || material == null) {
            return 0;
        }
        int totalUses = 0;
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() != material || !MagicBlockHook.isMagicBlock(item)) continue;
            int useTimes = MagicBlockHook.getUseTimes(item);
            if (useTimes == -1) {
                return Integer.MAX_VALUE;
            }
            totalUses += useTimes;
        }
        return totalUses;
    }

    public static int consumeMagicBlockUses(Player player, Material material, int amount) {
        if (!enabled || player == null || material == null || amount <= 0) {
            return 0;
        }
        int consumed = 0;
        PlayerInventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getSize() && consumed < amount; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() != material || !MagicBlockHook.isMagicBlock(item)) continue;
            int useTimes = MagicBlockHook.getUseTimes(item);
            if (useTimes == -1) {
                consumed = amount;
                break;
            }
            while (useTimes > 0 && consumed < amount) {
                MagicBlockHook.decrementUseTimes(item);
                --useTimes;
                ++consumed;
            }
            if (useTimes > 0 || MagicBlockHook.getUseTimes(item) > 0) continue;
            inventory.setItem(i, null);
        }
        return consumed;
    }

    public static boolean hasUsePermission(Player player) {
        if (player == null) {
            return false;
        }
        return player.hasPermission("magicblock.use");
    }
}

