/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.preview.PreviewManager;

public class SettingsGUI
implements InventoryHolder,
Listener {
    private final PreviewManager previewManager;
    private final I18nManager i18n;
    private final Inventory inventory;
    private final Player player;
    private static final String GUI_TITLE_KEY = "gui.settings.title";
    private String guiTitle;
    private static final Map<Material, Color> DYE_COLORS = new LinkedHashMap<Material, Color>();
    private static final Map<Material, String> DYE_NAMES = new LinkedHashMap<Material, String>();
    private static final Map<UUID, Color> playerColors;

    public SettingsGUI(PreviewManager previewManager, I18nManager i18n, Player player) {
        this.previewManager = previewManager;
        this.i18n = i18n;
        this.player = player;
        this.guiTitle = i18n.get(GUI_TITLE_KEY);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)this.guiTitle);
        this.initializeItems();
    }

    private void initializeItems() {
        this.inventory.clear();
        this.inventory.setItem(1, this.createPreviewModeItem(PreviewManager.PreviewMode.FULL, Material.GLASS));
        this.inventory.setItem(4, this.createPreviewModeItem(PreviewManager.PreviewMode.CORNERS, Material.END_ROD));
        this.inventory.setItem(7, this.createPreviewModeItem(PreviewManager.PreviewMode.OUTLINE, Material.ITEM_FRAME));
        int slot = 9;
        for (Map.Entry<Material, Color> entry : DYE_COLORS.entrySet()) {
            if (slot >= 27) break;
            this.inventory.setItem(slot, this.createColorItem(entry.getKey()));
            ++slot;
        }
        ItemStack filler = this.createFillerItem();
        for (int i = 0; i < 27; ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, filler);
        }
    }

    private ItemStack createPreviewModeItem(PreviewManager.PreviewMode mode, Material material) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            Object modeName;
            PreviewManager.PreviewMode currentMode = this.previewManager.getPlayerPreviewMode(this.player);
            boolean isSelected = currentMode == mode;
            String modeDesc = switch (mode) {
                case PreviewManager.PreviewMode.FULL -> {
                    modeName = this.i18n.get("gui.settings.mode.full.name");
                    yield this.i18n.get("gui.settings.mode.full.desc");
                }
                case PreviewManager.PreviewMode.CORNERS -> {
                    modeName = this.i18n.get("gui.settings.mode.corners.name");
                    yield this.i18n.get("gui.settings.mode.corners.desc");
                }
                case PreviewManager.PreviewMode.OUTLINE -> {
                    modeName = this.i18n.get("gui.settings.mode.outline.name");
                    yield this.i18n.get("gui.settings.mode.outline.desc");
                }
                default -> {
                    modeName = mode.name();
                    yield "";
                }
            };
            if (isSelected) {
                modeName = "\u00a7a\u2714 " + (String)modeName;
            }
            meta.setDisplayName((String)modeName);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(modeDesc);
            if (isSelected) {
                lore.add("");
                lore.add(this.i18n.get("gui.settings.current-selection"));
            } else {
                lore.add("");
                lore.add(this.i18n.get("gui.settings.click-to-select"));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createColorItem(Material dyeMaterial) {
        ItemStack item = new ItemStack(dyeMaterial);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String colorName = DYE_NAMES.getOrDefault(dyeMaterial, dyeMaterial.name());
            Color currentColor = SettingsGUI.getPlayerColor(this.player);
            Color dyeColor = DYE_COLORS.get(dyeMaterial);
            boolean isSelected = currentColor != null && currentColor.equals((Object)dyeColor);
            Object displayName = this.i18n.get("gui.settings.color.name", colorName);
            if (isSelected) {
                displayName = "\u00a7a\u2714 " + (String)displayName;
            }
            meta.setDisplayName((String)displayName);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.i18n.get("gui.settings.color.desc"));
            if (isSelected) {
                lore.add("");
                lore.add(this.i18n.get("gui.settings.current-selection"));
            } else {
                lore.add("");
                lore.add(this.i18n.get("gui.settings.click-to-select"));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createFillerItem() {
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            filler.setItemMeta(meta);
        }
        return filler;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof SettingsGUI)) {
            return;
        }
        event.setCancelled(true);
        if (event.getClickedInventory() == null || !(event.getClickedInventory().getHolder() instanceof SettingsGUI)) {
            return;
        }
        Player clickPlayer = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        int slot = event.getSlot();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (clickedItem.getType() == Material.GRAY_STAINED_GLASS_PANE) {
            return;
        }
        if (slot < 9) {
            this.handlePreviewModeClick(clickPlayer, slot, clickedItem);
        } else {
            this.handleColorClick(clickPlayer, clickedItem);
        }
    }

    private void handlePreviewModeClick(Player player, int slot, ItemStack item) {
        PreviewManager.PreviewMode newMode = null;
        switch (slot) {
            case 1: {
                newMode = PreviewManager.PreviewMode.FULL;
                break;
            }
            case 4: {
                newMode = PreviewManager.PreviewMode.CORNERS;
                break;
            }
            case 7: {
                newMode = PreviewManager.PreviewMode.OUTLINE;
            }
        }
        if (newMode != null) {
            PreviewManager.PreviewMode currentMode = this.previewManager.getPlayerPreviewMode(player);
            if (currentMode == newMode) {
                return;
            }
            this.previewManager.setPlayerPreviewMode(player, newMode);
            player.sendMessage(this.i18n.get("message.preview-mode-changed", switch (newMode) {
                case PreviewManager.PreviewMode.FULL -> this.i18n.get("preview.mode.full");
                case PreviewManager.PreviewMode.CORNERS -> this.i18n.get("preview.mode.corners");
                case PreviewManager.PreviewMode.OUTLINE -> this.i18n.get("preview.mode.outline");
                default -> newMode.name();
            }));
            this.initializeItems();
        }
    }

    private void handleColorClick(Player player, ItemStack item) {
        Material dyeMaterial = item.getType();
        Color color = DYE_COLORS.get(dyeMaterial);
        if (color != null) {
            Color currentColor = SettingsGUI.getPlayerColor(player);
            if (currentColor != null && currentColor.equals((Object)color)) {
                return;
            }
            SettingsGUI.setPlayerColor(player, color);
            this.previewManager.setPlayerPreviewColor(player, color);
            String colorName = DYE_NAMES.getOrDefault(dyeMaterial, dyeMaterial.name());
            player.sendMessage(this.i18n.get("message.color-changed", colorName));
            this.initializeItems();
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getHolder() instanceof SettingsGUI) {
            event.setCancelled(true);
        }
    }

    public String getGuiTitle() {
        return this.guiTitle;
    }

    public static Color getPlayerColor(Player player) {
        return playerColors.getOrDefault(player.getUniqueId(), Color.RED);
    }

    public static void setPlayerColor(Player player, Color color) {
        playerColors.put(player.getUniqueId(), color);
    }

    static {
        DYE_COLORS.put(Material.WHITE_DYE, Color.WHITE);
        DYE_COLORS.put(Material.ORANGE_DYE, Color.ORANGE);
        DYE_COLORS.put(Material.MAGENTA_DYE, Color.FUCHSIA);
        DYE_COLORS.put(Material.LIGHT_BLUE_DYE, Color.fromRGB((int)85, (int)255, (int)255));
        DYE_COLORS.put(Material.YELLOW_DYE, Color.YELLOW);
        DYE_COLORS.put(Material.LIME_DYE, Color.LIME);
        DYE_COLORS.put(Material.PINK_DYE, Color.fromRGB((int)255, (int)105, (int)180));
        DYE_COLORS.put(Material.GRAY_DYE, Color.GRAY);
        DYE_COLORS.put(Material.LIGHT_GRAY_DYE, Color.SILVER);
        DYE_COLORS.put(Material.CYAN_DYE, Color.TEAL);
        DYE_COLORS.put(Material.PURPLE_DYE, Color.PURPLE);
        DYE_COLORS.put(Material.BLUE_DYE, Color.BLUE);
        DYE_COLORS.put(Material.BROWN_DYE, Color.fromRGB((int)139, (int)69, (int)19));
        DYE_COLORS.put(Material.GREEN_DYE, Color.GREEN);
        DYE_COLORS.put(Material.RED_DYE, Color.RED);
        DYE_COLORS.put(Material.BLACK_DYE, Color.fromRGB((int)30, (int)30, (int)30));
        DYE_NAMES.put(Material.WHITE_DYE, "\u767d\u8272");
        DYE_NAMES.put(Material.ORANGE_DYE, "\u6a59\u8272");
        DYE_NAMES.put(Material.MAGENTA_DYE, "\u54c1\u7ea2\u8272");
        DYE_NAMES.put(Material.LIGHT_BLUE_DYE, "\u6de1\u84dd\u8272");
        DYE_NAMES.put(Material.YELLOW_DYE, "\u9ec4\u8272");
        DYE_NAMES.put(Material.LIME_DYE, "\u9ec4\u7eff\u8272");
        DYE_NAMES.put(Material.PINK_DYE, "\u7c89\u7ea2\u8272");
        DYE_NAMES.put(Material.GRAY_DYE, "\u7070\u8272");
        DYE_NAMES.put(Material.LIGHT_GRAY_DYE, "\u6de1\u7070\u8272");
        DYE_NAMES.put(Material.CYAN_DYE, "\u9752\u8272");
        DYE_NAMES.put(Material.PURPLE_DYE, "\u7d2b\u8272");
        DYE_NAMES.put(Material.BLUE_DYE, "\u84dd\u8272");
        DYE_NAMES.put(Material.BROWN_DYE, "\u68d5\u8272");
        DYE_NAMES.put(Material.GREEN_DYE, "\u7eff\u8272");
        DYE_NAMES.put(Material.RED_DYE, "\u7ea2\u8272");
        DYE_NAMES.put(Material.BLACK_DYE, "\u9ed1\u8272");
        playerColors = new HashMap<UUID, Color>();
    }
}

