/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.ConstructionWand;
import org.little100.constructionWand.enchant.EnchantmentManager;
import org.little100.constructionWand.enchant.WandEnchantment;
import org.little100.constructionWand.gui.SettingsGUI;
import org.little100.constructionWand.gui.WandGUI;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.preview.PreviewManager;
import org.little100.constructionWand.utils.VersionHelper;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class WandCommand
implements CommandExecutor,
TabCompleter {
    private final ConstructionWand plugin;
    private final WandItemManager wandItemManager;
    private final I18nManager i18n;

    public WandCommand(ConstructionWand plugin, WandItemManager wandItemManager, I18nManager i18n) {
        this.plugin = plugin;
        this.wandItemManager = wandItemManager;
        this.i18n = i18n;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "give": {
                return this.handleGive(sender, args);
            }
            case "reload": {
                return this.handleReload(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
            case "list": {
                return this.handleList(sender);
            }
            case "itemgui": {
                return this.handleItemGUI(sender);
            }
            case "gui": 
            case "settings": {
                return this.handleSettingsGUI(sender);
            }
            case "enchant": {
                return this.handleEnchant(sender, args);
            }
            case "nbtdebug": {
                return this.handleNbtDebug(sender);
            }
            case "preview": {
                return this.handlePreview(sender);
            }
            case "lang": 
            case "language": {
                return this.handleLang(sender, args);
            }
        }
        sender.sendMessage(this.i18n.get("message.unknown-command", subCommand));
        this.sendHelp(sender);
        return true;
    }

    private boolean handleGive(CommandSender sender, String[] args) {
        Player target;
        if (!sender.hasPermission("constructionwand.give")) {
            sender.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.i18n.get("command.usage.give"));
            sender.sendMessage(this.i18n.get("message.available-types"));
            return true;
        }
        String typeId = args[1].toLowerCase();
        WandType wandType = WandType.fromId(typeId);
        if (wandType == null) {
            sender.sendMessage(this.i18n.get("message.unknown-wand-type", typeId));
            sender.sendMessage(this.i18n.get("message.available-types"));
            return true;
        }
        if (args.length >= 3) {
            target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                sender.sendMessage(this.i18n.get("message.player-not-found", args[2]));
                return true;
            }
        } else if (sender instanceof Player) {
            target = (Player)sender;
        } else {
            sender.sendMessage(this.i18n.get("message.console-need-player"));
            return true;
        }
        ItemStack wand = this.wandItemManager.createWand(wandType);
        target.getInventory().addItem(new ItemStack[]{wand});
        String wandName = this.i18n.get("wand." + wandType.getId() + ".name");
        sender.sendMessage(this.i18n.get("message.wand-given", target.getName(), wandName));
        if (target != sender) {
            target.sendMessage(this.i18n.get("message.wand-received", wandName));
        }
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("constructionwand.reload")) {
            sender.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        this.plugin.reloadConfig();
        this.plugin.loadConfiguration();
        sender.sendMessage(this.i18n.get("message.config-reloaded"));
        return true;
    }

    private boolean handleItemGUI(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.i18n.get("message.console-need-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("constructionwand.itemgui")) {
            player.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        WandGUI gui = new WandGUI(this.wandItemManager, this.i18n);
        gui.setWandConfigManager(this.plugin.getWandConfigManager());
        Bukkit.getPluginManager().registerEvents((Listener)gui, (Plugin)this.plugin);
        gui.openInventory(player);
        return true;
    }

    private boolean handleEnchant(CommandSender sender, String[] args) {
        int level;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.i18n.get("message.console-need-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("constructionwand.enchant")) {
            player.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(this.i18n.get("command.usage.enchant"));
            player.sendMessage(this.i18n.get("message.available-enchants"));
            return true;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (!this.wandItemManager.isWand(itemInHand)) {
            player.sendMessage(this.i18n.get("message.not-holding-wand"));
            return true;
        }
        String enchantName = args[1].toLowerCase();
        WandEnchantment enchantment = WandEnchantment.fromId(enchantName);
        if (enchantment == null) {
            player.sendMessage(this.i18n.get("message.unknown-enchant", enchantName));
            player.sendMessage(this.i18n.get("message.available-enchants"));
            return true;
        }
        try {
            level = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.i18n.get("message.invalid-level", args[2]));
            return true;
        }
        if (level <= 0) {
            EnchantmentManager enchantManager = this.plugin.getEnchantmentManager();
            if (enchantManager.removeEnchantment(itemInHand, enchantment)) {
                player.sendMessage(this.i18n.get("message.enchant-removed", this.i18n.get("enchant." + enchantment.getId() + ".name")));
            } else {
                player.sendMessage(this.i18n.get("message.enchant-not-found"));
            }
            return true;
        }
        EnchantmentManager enchantManager = this.plugin.getEnchantmentManager();
        if (enchantManager.addEnchantment(itemInHand, enchantment, level)) {
            String enchantDisplayName = this.i18n.get("enchant." + enchantment.getId() + ".name");
            String levelStr = WandEnchantment.toRomanNumeral(level);
            player.sendMessage(this.i18n.get("message.enchant-added", enchantDisplayName, levelStr));
        } else {
            player.sendMessage(this.i18n.get("message.enchant-failed"));
        }
        return true;
    }

    private boolean handleNbtDebug(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.i18n.get("message.console-need-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("constructionwand.nbtdebug")) {
            player.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType().isAir()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "\u624b\u4e2d\u6ca1\u6709\u7269\u54c1\uff01");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "=== NBT Debug \u4fe1\u606f ===");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u7269\u54c1\u7c7b\u578b: " + String.valueOf(ChatColor.WHITE) + itemInHand.getType().name());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u6570\u91cf: " + String.valueOf(ChatColor.WHITE) + itemInHand.getAmount());
        ItemMeta meta = itemInHand.getItemMeta();
        if (meta != null) {
            int oldCustomModelData = VersionHelper.getCustomModelData(meta);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "CustomModelData (\u65e7\u7248\u6574\u6570): " + String.valueOf(ChatColor.WHITE) + oldCustomModelData);
            int newCustomModelData = VersionHelper.getCustomModelDataFromItem(itemInHand);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "CustomModelData (\u65b0\u7248\u7ec4\u4ef6): " + String.valueOf(ChatColor.WHITE) + newCustomModelData);
            List<String> cmdStrings = VersionHelper.getCustomModelDataStrings(itemInHand);
            if (!cmdStrings.isEmpty()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "CustomModelData Strings: " + String.valueOf(ChatColor.WHITE) + String.valueOf(cmdStrings));
            }
            if (meta.hasDisplayName()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u663e\u793a\u540d\u79f0: " + String.valueOf(ChatColor.WHITE) + meta.getDisplayName());
            }
            boolean isWand = this.wandItemManager.isWand(itemInHand);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u662f\u5efa\u7b51\u4e4b\u6756: " + String.valueOf(ChatColor.WHITE) + (isWand ? "\u662f" : "\u5426"));
            if (isWand) {
                WandType wandType = this.wandItemManager.getWandType(itemInHand);
                if (wandType != null) {
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u624b\u6756\u7c7b\u578b: " + String.valueOf(ChatColor.WHITE) + wandType.getId());
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u6700\u5927\u65b9\u5757\u6570: " + String.valueOf(ChatColor.WHITE) + wandType.getMaxBlocks());
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u671f\u671bCustomModelData: " + String.valueOf(ChatColor.WHITE) + wandType.getCustomModelData());
                }
                EnchantmentManager enchantManager = this.plugin.getEnchantmentManager();
                for (WandEnchantment enchant : WandEnchantment.values()) {
                    int level = enchantManager.getEnchantmentLevel(itemInHand, enchant);
                    if (level <= 0) continue;
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u9644\u9b54 " + enchant.getId() + ": " + String.valueOf(ChatColor.WHITE) + "\u7b49\u7ea7 " + level);
                }
            }
            if (meta.hasLore()) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Lore:");
                for (String line : meta.getLore()) {
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "  " + line);
                }
            }
        }
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "======================");
        return true;
    }

    private boolean handleSettingsGUI(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.i18n.get("message.console-need-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("constructionwand.settings")) {
            player.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        PreviewManager previewManager = this.plugin.getPreviewManager();
        SettingsGUI gui = new SettingsGUI(previewManager, this.i18n, player);
        Bukkit.getPluginManager().registerEvents((Listener)gui, (Plugin)this.plugin);
        gui.openInventory(player);
        return true;
    }

    private boolean handlePreview(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.i18n.get("message.console-need-player"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("constructionwand.preview")) {
            player.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        PreviewManager previewManager = this.plugin.getPreviewManager();
        PreviewManager.PreviewMode newMode = previewManager.togglePlayerPreviewMode(player);
        player.sendMessage(this.i18n.get("message.preview-mode-changed", switch (newMode) {
            case PreviewManager.PreviewMode.FULL -> this.i18n.get("preview.mode.full");
            case PreviewManager.PreviewMode.CORNERS -> this.i18n.get("preview.mode.corners");
            case PreviewManager.PreviewMode.OUTLINE -> this.i18n.get("preview.mode.outline");
            default -> newMode.name();
        }));
        return true;
    }

    private boolean handleLang(CommandSender sender, String[] args) {
        Player player;
        int updated;
        if (!sender.hasPermission("constructionwand.lang")) {
            sender.sendMessage(this.i18n.get("message.no-permission"));
            return true;
        }
        List<String> availableLanguages = Arrays.asList("zh_CN", "zh_TW", "en_US", "lzh");
        if (args.length < 2) {
            sender.sendMessage(this.i18n.get("message.current-language", this.i18n.getCurrentLanguage()));
            sender.sendMessage(this.i18n.get("message.available-languages", String.join((CharSequence)", ", availableLanguages)));
            return true;
        }
        String newLang = args[1];
        if (!availableLanguages.contains(newLang)) {
            sender.sendMessage(this.i18n.get("message.unknown-language", newLang));
            sender.sendMessage(this.i18n.get("message.available-languages", String.join((CharSequence)", ", availableLanguages)));
            return true;
        }
        this.i18n.loadLanguage(newLang);
        this.plugin.getConfig().set("language", (Object)newLang);
        this.plugin.saveConfig();
        sender.sendMessage(this.i18n.get("message.language-changed", newLang));
        if (sender instanceof Player && (updated = this.wandItemManager.updateAllWandsInInventory(player = (Player)sender)) > 0) {
            sender.sendMessage(this.i18n.get("message.wands-updated", updated));
        }
        return true;
    }

    private boolean handleList(CommandSender sender) {
        sender.sendMessage(this.i18n.get("command.list.title"));
        for (WandType type : WandType.values()) {
            int maxBlocks = this.wandItemManager.getConfigMaxBlocks(type);
            int durability = this.wandItemManager.getConfigDurability(type);
            boolean isUnbreakable = durability == -1;
            StringBuilder sb = new StringBuilder();
            sb.append(ChatColor.YELLOW).append(type.getId());
            sb.append(ChatColor.WHITE).append(" - ");
            sb.append(this.i18n.get("wand." + type.getId() + ".name"));
            sb.append(ChatColor.GRAY).append(" (").append(this.i18n.get("command.list.max", maxBlocks));
            if (isUnbreakable) {
                sb.append(", ").append(this.i18n.get("command.list.infinite"));
            } else {
                sb.append(", ").append(this.i18n.get("command.list.durability", durability));
            }
            sb.append(ChatColor.GRAY).append(")");
            sender.sendMessage(sb.toString());
        }
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.i18n.get("command.help.title"));
        sender.sendMessage(this.i18n.get("command.help.give"));
        sender.sendMessage(this.i18n.get("command.help.itemgui"));
        sender.sendMessage(this.i18n.get("command.help.gui"));
        sender.sendMessage(this.i18n.get("command.help.enchant"));
        sender.sendMessage(this.i18n.get("command.help.nbtdebug"));
        sender.sendMessage(this.i18n.get("command.help.preview"));
        sender.sendMessage(this.i18n.get("command.help.lang"));
        sender.sendMessage(this.i18n.get("command.help.list"));
        sender.sendMessage(this.i18n.get("command.help.reload"));
        sender.sendMessage(this.i18n.get("command.help.help"));
        sender.sendMessage("");
        sender.sendMessage(this.i18n.get("command.help.usage"));
        sender.sendMessage(this.i18n.get("command.help.usage-detail"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("give", "itemgui", "gui", "enchant", "nbtdebug", "preview", "lang", "list", "reload", "help");
            String input = args[0].toLowerCase();
            completions = subCommands.stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            String input = args[1].toLowerCase();
            completions = Arrays.stream(WandType.values()).map(WandType::getId).filter(s -> s.startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 3 && args[0].equalsIgnoreCase("give")) {
            String input = args[2].toLowerCase();
            completions = Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(s -> s.toLowerCase().startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 2 && args[0].equalsIgnoreCase("enchant")) {
            String input = args[1].toLowerCase();
            completions = Arrays.stream(WandEnchantment.values()).map(WandEnchantment::getId).filter(s -> s.startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 3 && args[0].equalsIgnoreCase("enchant")) {
            completions = Arrays.asList("1", "2", "3", "4", "5");
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("lang") || args[0].equalsIgnoreCase("language"))) {
            String input = args[1].toLowerCase();
            completions = Arrays.asList("zh_CN", "zh_TW", "en_US", "lzh").stream().filter(s -> s.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        return completions;
    }
}

