/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.util.BoundingBox;
import org.little100.constructionWand.enchant.EnchantmentManager;
import org.little100.constructionWand.hook.MagicBlockHook;
import org.little100.constructionWand.protection.ProtectionChecker;
import org.little100.constructionWand.wand.WandConfigManager;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class WandAction {
    private final WandItemManager wandItemManager;
    private final ProtectionChecker protectionChecker;
    private EnchantmentManager enchantmentManager;
    private WandConfigManager wandConfigManager;
    private boolean useMagicBlockFirst = true;
    private boolean requireMagicBlockPermission = true;

    public WandAction(WandItemManager wandItemManager, ProtectionChecker protectionChecker) {
        this.wandItemManager = wandItemManager;
        this.protectionChecker = protectionChecker;
    }

    public void setEnchantmentManager(EnchantmentManager enchantmentManager) {
        this.enchantmentManager = enchantmentManager;
    }

    public void setWandConfigManager(WandConfigManager wandConfigManager) {
        this.wandConfigManager = wandConfigManager;
    }

    public void setUseMagicBlockFirst(boolean useMagicBlockFirst) {
        this.useMagicBlockFirst = useMagicBlockFirst;
    }

    public void setRequireMagicBlockPermission(boolean requireMagicBlockPermission) {
        this.requireMagicBlockPermission = requireMagicBlockPermission;
    }

    public List<Location> calculatePlaceableLocations(Player player, Block clickedBlock, BlockFace clickedFace, ItemStack wandItem) {
        List<Location> locations = new ArrayList<Location>();
        WandType wandType = this.wandItemManager.getWandType(wandItem);
        if (wandType == null) {
            return locations;
        }
        if (this.wandConfigManager != null && !this.wandConfigManager.isEnabled(wandType)) {
            return locations;
        }
        Material targetMaterial = clickedBlock.getType();
        if (!this.isPlaceableMaterial(targetMaterial)) {
            return locations;
        }
        int availableBlocks = this.countAvailableBlocks(player, targetMaterial);
        if (availableBlocks <= 0) {
            return locations;
        }
        int baseMaxBlocks = this.getConfigMaxBlocks(wandType);
        int maxBlocks = this.enchantmentManager != null ? this.enchantmentManager.calculateBonusBlocks(wandItem, baseMaxBlocks) : baseMaxBlocks;
        maxBlocks = Math.min(maxBlocks, availableBlocks);
        Location startLocation = clickedBlock.getRelative(clickedFace).getLocation();
        if (!this.canReplace(startLocation.getBlock().getType())) {
            return locations;
        }
        locations = this.expandPlacementArea(player, clickedBlock, clickedFace, targetMaterial, maxBlocks);
        return locations;
    }

    private List<Location> expandPlacementArea(Player player, Block clickedBlock, BlockFace clickedFace, Material material, int maxBlocks) {
        ArrayList<Location> result = new ArrayList<Location>();
        HashSet<Location> visited = new HashSet<Location>();
        LinkedList<Block> queue = new LinkedList<Block>();
        BlockFace[] expandDirections = this.getExpandDirections(clickedFace);
        try {
            Block startBlock = clickedBlock.getRelative(clickedFace);
            Material startType = startBlock.getType();
            if (this.canReplace(startType)) {
                queue.add(startBlock);
                visited.add(startBlock.getLocation());
            }
        }
        catch (Exception e) {
            return result;
        }
        while (!queue.isEmpty() && result.size() < maxBlocks) {
            Block current = (Block)queue.poll();
            if (current == null) continue;
            Location currentLoc = current.getLocation();
            try {
                if (!this.canPlaceAtPrecise(player, currentLoc, material, clickedFace)) {
                }
            }
            catch (Exception e) {}
            continue;
            result.add(currentLoc);
            for (BlockFace direction : expandDirections) {
                try {
                    Block supportBlock;
                    Location neighborLoc;
                    Block neighbor = current.getRelative(direction);
                    if (neighbor == null || visited.contains(neighborLoc = neighbor.getLocation())) continue;
                    visited.add(neighborLoc);
                    Material neighborType = neighbor.getType();
                    if (!this.canReplace(neighborType) || (supportBlock = neighbor.getRelative(clickedFace.getOppositeFace())) == null || supportBlock.getType() != material) continue;
                    queue.add(neighbor);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private boolean canPlaceAtPrecise(Player player, Location location, Material material, BlockFace clickedFace) {
        try {
            Block block = location.getBlock();
            if (block == null) {
                return false;
            }
            Material blockType = block.getType();
            if (!this.canReplace(blockType)) {
                return false;
            }
            if (!this.protectionChecker.canPlace(player, location, material)) {
                return false;
            }
            if (this.hasBlockingEntity(location)) {
                return false;
            }
            Block supportBlock = block.getRelative(clickedFace.getOppositeFace());
            if (supportBlock == null) {
                return false;
            }
            return supportBlock.getType() == material;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canPlaceAt(Player player, Location location, Material material, BlockFace face) {
        Block block = location.getBlock();
        if (!this.canReplace(block.getType())) {
            return false;
        }
        if (!this.protectionChecker.canPlace(player, location, material)) {
            return false;
        }
        return this.hasAdjacentBlock(block, material, face);
    }

    private boolean hasAdjacentBlock(Block block, Material material, BlockFace placeFace) {
        BlockFace[] expandDirections;
        BlockFace supportFace = placeFace.getOppositeFace();
        if (block.getRelative(supportFace).getType() == material) {
            return true;
        }
        for (BlockFace face : expandDirections = this.getExpandDirections(placeFace)) {
            if (block.getRelative(face).getType() != material) continue;
            return true;
        }
        return false;
    }

    private BlockFace[] getExpandDirections(BlockFace clickedFace) {
        switch (clickedFace) {
            case UP: 
            case DOWN: {
                return new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
            }
            case NORTH: 
            case SOUTH: {
                return new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.EAST, BlockFace.WEST};
            }
            case EAST: 
            case WEST: {
                return new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH};
            }
        }
        return new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    }

    public int placeBlocks(Player player, List<Location> locations, Material material, ItemStack wandItem) {
        boolean broken;
        if (locations == null || locations.isEmpty()) {
            return 0;
        }
        WandType wandType = this.wandItemManager.getWandType(wandItem);
        if (wandType == null) {
            return 0;
        }
        if (this.wandConfigManager != null && !this.wandConfigManager.isEnabled(wandType)) {
            return 0;
        }
        int placed = 0;
        for (Location loc : locations) {
            if (!this.canReplace(loc.getBlock().getType())) continue;
            if (!this.hasEnoughBlocks(player, material, 1)) break;
            if (!this.protectionChecker.canPlace(player, loc, material) || this.hasBlockingEntity(loc)) continue;
            loc.getBlock().setType(material);
            this.consumeBlocks(player, material, 1);
            ++placed;
        }
        boolean isUnbreakable = this.isWandUnbreakable(wandType);
        if (placed > 0 && !isUnbreakable && (broken = this.wandItemManager.consumeDurability(wandItem, placed))) {
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            wandItem.setAmount(0);
        }
        if (placed > 0) {
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
        }
        return placed;
    }

    private boolean isPlaceableMaterial(Material material) {
        return material.isBlock() && material.isSolid() && !material.isAir();
    }

    private int getConfigMaxBlocks(WandType type) {
        if (this.wandConfigManager != null) {
            return this.wandConfigManager.getMaxBlocks(type);
        }
        return type.getMaxBlocks();
    }

    private boolean isWandUnbreakable(WandType type) {
        if (this.wandConfigManager != null) {
            return this.wandConfigManager.isUnbreakable(type);
        }
        return type.isUnbreakable();
    }

    private boolean canReplace(Material material) {
        if (material == null) {
            return false;
        }
        if (material.isAir()) {
            return true;
        }
        return this.isFluid(material);
    }

    private boolean isFluid(Material material) {
        if (material == null) {
            return false;
        }
        return material == Material.WATER || material == Material.LAVA || material.name().contains("WATER") || material.name().contains("LAVA");
    }

    private boolean hasBlockingEntity(Location location) {
        try {
            BoundingBox blockBox = BoundingBox.of((Location)location.getBlock().getLocation(), (Location)location.getBlock().getLocation().clone().add(1.0, 1.0, 1.0));
            for (Entity entity : location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0)) {
                BoundingBox entityBox;
                if (this.shouldIgnoreEntity(entity) || !blockBox.overlaps(entityBox = entity.getBoundingBox())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean shouldIgnoreEntity(Entity entity) {
        String typeName;
        if (entity == null) {
            return true;
        }
        switch (typeName = entity.getType().name()) {
            case "DROPPED_ITEM": 
            case "ITEM": 
            case "EXPERIENCE_ORB": 
            case "ARROW": 
            case "SPECTRAL_ARROW": 
            case "TRIDENT": 
            case "SNOWBALL": 
            case "EGG": 
            case "ENDER_PEARL": 
            case "FIREBALL": 
            case "SMALL_FIREBALL": 
            case "DRAGON_FIREBALL": 
            case "WITHER_SKULL": 
            case "SHULKER_BULLET": 
            case "LLAMA_SPIT": 
            case "FIREWORK_ROCKET": 
            case "FIREWORK": 
            case "FISHING_BOBBER": 
            case "FISHING_HOOK": 
            case "EYE_OF_ENDER": 
            case "ENDER_SIGNAL": 
            case "POTION": 
            case "SPLASH_POTION": 
            case "THROWN_EXP_BOTTLE": 
            case "LIGHTNING_BOLT": 
            case "LIGHTNING": 
            case "AREA_EFFECT_CLOUD": 
            case "END_CRYSTAL": 
            case "ENDER_CRYSTAL": 
            case "PAINTING": 
            case "ITEM_FRAME": 
            case "GLOW_ITEM_FRAME": 
            case "LEASH_KNOT": 
            case "LEASH_HITCH": 
            case "MARKER": 
            case "BLOCK_DISPLAY": 
            case "ITEM_DISPLAY": 
            case "TEXT_DISPLAY": 
            case "INTERACTION": {
                return true;
            }
        }
        return !(entity instanceof LivingEntity);
    }

    public int countAvailableBlocks(Player player, Material material) {
        int magicBlockUses = 0;
        int normalBlocks = 0;
        if (MagicBlockHook.isEnabled() && this.canUseMagicBlock(player) && (magicBlockUses = MagicBlockHook.countMagicBlockUsesInInventory(player, material)) == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        normalBlocks = this.countNormalMaterialInInventory(player, material);
        return magicBlockUses + normalBlocks;
    }

    private boolean canUseMagicBlock(Player player) {
        if (!MagicBlockHook.isEnabled()) {
            return false;
        }
        return !this.requireMagicBlockPermission || MagicBlockHook.hasUsePermission(player);
    }

    public int countNormalMaterialInInventory(Player player, Material material) {
        int count = 0;
        PlayerInventory inventory = player.getInventory();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() != material || MagicBlockHook.isEnabled() && MagicBlockHook.isMagicBlock(item)) continue;
            count += item.getAmount();
        }
        return count;
    }

    public int countMaterialInInventory(Player player, Material material) {
        return this.countAvailableBlocks(player, material);
    }

    private boolean hasEnoughBlocks(Player player, Material material, int amount) {
        return this.countAvailableBlocks(player, material) >= amount;
    }

    private boolean hasEnoughMaterial(Player player, Material material, int amount) {
        return this.hasEnoughBlocks(player, material, amount);
    }

    private void consumeBlocks(Player player, Material material, int amount) {
        int remaining = amount;
        if (this.useMagicBlockFirst && MagicBlockHook.isEnabled() && this.canUseMagicBlock(player)) {
            int consumed = MagicBlockHook.consumeMagicBlockUses(player, material, remaining);
            remaining -= consumed;
        }
        if (remaining > 0) {
            this.removeNormalMaterialFromInventory(player, material, remaining);
        }
    }

    private void removeNormalMaterialFromInventory(Player player, Material material, int amount) {
        PlayerInventory inventory = player.getInventory();
        int remaining = amount;
        for (int i = 0; i < inventory.getSize() && remaining > 0; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() != material || MagicBlockHook.isEnabled() && MagicBlockHook.isMagicBlock(item)) continue;
            int itemAmount = item.getAmount();
            if (itemAmount <= remaining) {
                inventory.setItem(i, null);
                remaining -= itemAmount;
                continue;
            }
            item.setAmount(itemAmount - remaining);
            remaining = 0;
        }
    }

    private void removeMaterialFromInventory(Player player, Material material, int amount) {
        this.consumeBlocks(player, material, amount);
    }
}

