/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand;

import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.little100.constructionWand.action.WandAction;
import org.little100.constructionWand.command.WandCommand;
import org.little100.constructionWand.enchant.EnchantmentManager;
import org.little100.constructionWand.hook.MagicBlockHook;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.listener.ItemProtectionListener;
import org.little100.constructionWand.listener.WandListener;
import org.little100.constructionWand.preview.PreviewManager;
import org.little100.constructionWand.protection.ProtectionChecker;
import org.little100.constructionWand.recipe.WandRecipeManager;
import org.little100.constructionWand.utils.VersionHelper;
import org.little100.constructionWand.wand.WandConfigManager;
import org.little100.constructionWand.wand.WandItemManager;

public final class ConstructionWand
extends JavaPlugin {
    private static ConstructionWand instance;
    private I18nManager i18nManager;
    private WandConfigManager wandConfigManager;
    private WandItemManager wandItemManager;
    private WandRecipeManager recipeManager;
    private ProtectionChecker protectionChecker;
    private PreviewManager previewManager;
    private WandAction wandAction;
    private EnchantmentManager enchantmentManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getLogger().info("========================================");
        this.getLogger().info("Construction Wand v" + this.getDescription().getVersion());
        this.getLogger().info(VersionHelper.getVersionInfo());
        this.getLogger().info("========================================");
        this.i18nManager = new I18nManager((Plugin)this);
        this.loadConfiguration();
        this.initManagers();
        this.recipeManager.registerAllRecipes();
        this.registerListeners();
        this.registerCommands();
        this.getLogger().info("Construction Wand \u5df2\u6210\u529f\u542f\u7528\uff01");
    }

    public void onDisable() {
        if (this.previewManager != null) {
            this.previewManager.clearAllPreviews();
        }
        if (this.recipeManager != null) {
            this.recipeManager.unregisterAllRecipes();
        }
        this.getLogger().info("Construction Wand \u5df2\u7981\u7528\uff01");
    }

    private void initManagers() {
        this.wandConfigManager = new WandConfigManager((Plugin)this);
        this.wandItemManager = new WandItemManager((Plugin)this, this.i18nManager, this.wandConfigManager);
        this.recipeManager = new WandRecipeManager((Plugin)this, this.wandItemManager);
        this.protectionChecker = new ProtectionChecker((Plugin)this);
        this.previewManager = new PreviewManager((Plugin)this);
        this.wandAction = new WandAction(this.wandItemManager, this.protectionChecker);
        this.enchantmentManager = new EnchantmentManager((Plugin)this, this.i18nManager);
        this.wandAction.setEnchantmentManager(this.enchantmentManager);
        this.wandAction.setWandConfigManager(this.wandConfigManager);
        this.enchantmentManager.setWandItemManager(this.wandItemManager);
        this.initMagicBlockHook();
    }

    private void initMagicBlockHook() {
        FileConfiguration config = this.getConfig();
        boolean enableMagicBlock = config.getBoolean("magicblock.enabled", true);
        if (!enableMagicBlock) {
            this.getLogger().info("MagicBlock \u9002\u914d\u5df2\u5728\u914d\u7f6e\u4e2d\u7981\u7528");
            return;
        }
        if (MagicBlockHook.init((Plugin)this)) {
            boolean useMagicBlockFirst = config.getBoolean("magicblock.use-first", true);
            boolean requirePermission = config.getBoolean("magicblock.require-permission", true);
            this.wandAction.setUseMagicBlockFirst(useMagicBlockFirst);
            this.wandAction.setRequireMagicBlockPermission(requirePermission);
            this.getLogger().info("MagicBlock \u9002\u914d\u5df2\u542f\u7528 - \u4f18\u5148\u4f7f\u7528: " + useMagicBlockFirst + ", \u9700\u8981\u6743\u9650: " + requirePermission);
        }
    }

    private void registerListeners() {
        WandListener wandListener = new WandListener(this.wandItemManager, this.wandAction, this.previewManager, this.i18nManager);
        wandListener.setPlugin((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)wandListener, (Plugin)this);
        ItemProtectionListener itemProtectionListener = new ItemProtectionListener(this.wandItemManager, this.i18nManager);
        itemProtectionListener.setEnchantmentManager(this.enchantmentManager);
        this.getServer().getPluginManager().registerEvents((Listener)itemProtectionListener, (Plugin)this);
    }

    private void registerCommands() {
        WandCommand wandCommand = new WandCommand(this, this.wandItemManager, this.i18nManager);
        this.getCommand("constructionwand").setExecutor((CommandExecutor)wandCommand);
        this.getCommand("constructionwand").setTabCompleter((TabCompleter)wandCommand);
    }

    public void loadConfiguration() {
        FileConfiguration config = this.getConfig();
        String language = config.getString("language", "zh_CN");
        this.i18nManager.loadLanguage(language);
        if (this.previewManager != null) {
            String colorStr = config.getString("preview.particle-color", "RED");
            Color color = this.parseColor(colorStr);
            this.previewManager.setPreviewColor(color);
            String previewMode = config.getString("preview.mode", "full");
            this.previewManager.setPreviewMode(previewMode.equalsIgnoreCase("outline") ? PreviewManager.PreviewMode.OUTLINE : PreviewManager.PreviewMode.FULL);
        }
        if (this.protectionChecker != null) {
            boolean useEventCheck = config.getBoolean("protection.use-event-check", true);
            boolean useWorldGuard = config.getBoolean("protection.use-worldguard", true);
            this.protectionChecker.setUseEventCheck(useEventCheck);
            this.protectionChecker.setUseWorldGuard(useWorldGuard);
        }
        if (this.wandConfigManager != null) {
            this.wandConfigManager.reloadConfig();
        }
        this.updateAllOnlinePlayersWands();
        this.getLogger().info("\u914d\u7f6e\u5df2\u52a0\u8f7d");
    }

    public void updateAllOnlinePlayersWands() {
        if (this.wandItemManager == null) {
            return;
        }
        int totalUpdated = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            int updated = this.wandItemManager.updateAllWandsInInventory(player);
            totalUpdated += updated;
        }
        if (totalUpdated > 0) {
            this.getLogger().info("\u5df2\u66f4\u65b0 " + totalUpdated + " \u4e2a\u624b\u6756\u7684\u663e\u793a");
        }
    }

    private Color parseColor(String colorStr) {
        switch (colorStr.toUpperCase()) {
            case "RED": {
                return Color.RED;
            }
            case "GREEN": {
                return Color.GREEN;
            }
            case "BLUE": {
                return Color.BLUE;
            }
            case "YELLOW": {
                return Color.YELLOW;
            }
            case "ORANGE": {
                return Color.ORANGE;
            }
            case "PURPLE": {
                return Color.PURPLE;
            }
            case "WHITE": {
                return Color.WHITE;
            }
            case "AQUA": {
                return Color.AQUA;
            }
            case "LIME": {
                return Color.LIME;
            }
        }
        try {
            if (colorStr.startsWith("#")) {
                colorStr = colorStr.substring(1);
            }
            int rgb = Integer.parseInt(colorStr, 16);
            return Color.fromRGB((int)rgb);
        }
        catch (NumberFormatException e) {
            return Color.RED;
        }
    }

    public static ConstructionWand getInstance() {
        return instance;
    }

    public WandItemManager getWandItemManager() {
        return this.wandItemManager;
    }

    public WandRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public ProtectionChecker getProtectionChecker() {
        return this.protectionChecker;
    }

    public PreviewManager getPreviewManager() {
        return this.previewManager;
    }

    public WandAction getWandAction() {
        return this.wandAction;
    }

    public I18nManager getI18nManager() {
        return this.i18nManager;
    }

    public EnchantmentManager getEnchantmentManager() {
        return this.enchantmentManager;
    }

    public WandConfigManager getWandConfigManager() {
        return this.wandConfigManager;
    }
}

