/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.recipe;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class WandRecipeManager {
    private final Plugin plugin;
    private final WandItemManager wandItemManager;

    public WandRecipeManager(Plugin plugin, WandItemManager wandItemManager) {
        this.plugin = plugin;
        this.wandItemManager = wandItemManager;
    }

    public void registerAllRecipes() {
        for (WandType type : WandType.values()) {
            this.registerRecipe(type);
        }
        this.plugin.getLogger().info("\u5df2\u6ce8\u518c " + WandType.values().length + " \u4e2a\u5efa\u7b51\u4e4b\u6756\u5408\u6210\u914d\u65b9");
    }

    private void registerRecipe(WandType type) {
        ItemStack wandItem = this.wandItemManager.createWand(type);
        NamespacedKey key = new NamespacedKey(this.plugin, "wand_" + type.getId());
        ShapedRecipe recipe = new ShapedRecipe(key, wandItem);
        recipe.shape(new String[]{"  M", " S ", "S  "});
        recipe.setIngredient('S', Material.STICK);
        recipe.setIngredient('M', type.getCraftMaterial());
        try {
            Bukkit.addRecipe((Recipe)recipe);
            this.plugin.getLogger().info("\u5df2\u6ce8\u518c\u5408\u6210\u914d\u65b9: " + type.getDisplayName());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("\u6ce8\u518c\u5408\u6210\u914d\u65b9\u5931\u8d25: " + type.getDisplayName() + " - " + e.getMessage());
        }
    }

    public void unregisterAllRecipes() {
        for (WandType type : WandType.values()) {
            NamespacedKey key = new NamespacedKey(this.plugin, "wand_" + type.getId());
            Bukkit.removeRecipe((NamespacedKey)key);
        }
    }

    public void reloadRecipes() {
        this.unregisterAllRecipes();
        this.registerAllRecipes();
    }
}

