/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;
import org.little100.constructionWand.action.WandAction;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.preview.PreviewManager;
import org.little100.constructionWand.utils.VersionHelper;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class WandListener
implements Listener {
    private Plugin plugin;
    private final WandItemManager wandItemManager;
    private final WandAction wandAction;
    private final PreviewManager previewManager;
    private final I18nManager i18n;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TICKS = 10L;
    private static final long COOLDOWN_MS = 500L;
    private int previewTaskId = -1;

    public WandListener(WandItemManager wandItemManager, WandAction wandAction, PreviewManager previewManager, I18nManager i18n) {
        this.wandItemManager = wandItemManager;
        this.wandAction = wandAction;
        this.previewManager = previewManager;
        this.i18n = i18n;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
        this.startPreviewUpdateTask();
    }

    private void startPreviewUpdateTask() {
        if (this.plugin == null) {
            return;
        }
        Runnable previewTask = () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (VersionHelper.isFolia()) {
                    VersionHelper.runAtEntity(this.plugin, (Entity)player, () -> {
                        try {
                            this.updatePlayerPreview(player);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                    continue;
                }
                this.updatePlayerPreview(player);
            }
        };
        if (VersionHelper.isFolia()) {
            VersionHelper.runTaskTimer(this.plugin, previewTask, 1L, 10L);
        } else {
            this.previewTaskId = Bukkit.getScheduler().runTaskTimer(this.plugin, previewTask, 1L, 10L).getTaskId();
        }
    }

    private void updatePlayerPreview(Player player) {
        try {
            List<Location> locations;
            if (player == null || !player.isOnline()) {
                return;
            }
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (!this.wandItemManager.isWand(itemInHand)) {
                if (!this.previewManager.getPreviewLocations(player).isEmpty()) {
                    this.previewManager.clearPreview(player);
                }
                return;
            }
            if (!player.hasPermission("constructionwand.use")) {
                this.previewManager.clearPreview(player);
                return;
            }
            WandType wandType = this.wandItemManager.getWandType(itemInHand);
            if (wandType == null) {
                return;
            }
            if (!player.hasPermission(wandType.getPermission())) {
                return;
            }
            RayTraceResult rayTrace = null;
            try {
                rayTrace = player.rayTraceBlocks(5.0, FluidCollisionMode.NEVER);
            }
            catch (Exception e) {
                this.previewManager.clearPreview(player);
                return;
            }
            if (rayTrace == null || rayTrace.getHitBlock() == null) {
                this.previewManager.clearPreview(player);
                return;
            }
            Block targetBlock = rayTrace.getHitBlock();
            BlockFace targetFace = rayTrace.getHitBlockFace();
            if (targetBlock == null || targetFace == null) {
                this.previewManager.clearPreview(player);
                return;
            }
            Material targetMaterial = null;
            try {
                targetMaterial = targetBlock.getType();
            }
            catch (Exception e) {
                this.previewManager.clearPreview(player);
                return;
            }
            if (targetMaterial == null || targetMaterial.isAir()) {
                this.previewManager.clearPreview(player);
                return;
            }
            try {
                locations = this.wandAction.calculatePlaceableLocations(player, targetBlock, targetFace, itemInHand);
            }
            catch (Exception e) {
                this.previewManager.clearPreview(player);
                return;
            }
            if (locations == null || locations.isEmpty()) {
                this.previewManager.clearPreview(player);
                return;
            }
            this.previewManager.updatePreview(player, locations, targetMaterial);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (!this.wandItemManager.isWand(itemInHand)) {
            return;
        }
        if (!player.hasPermission("constructionwand.use")) {
            player.sendMessage(this.i18n.get("message.no-permission"));
            return;
        }
        WandType wandType = this.wandItemManager.getWandType(itemInHand);
        if (wandType == null) {
            return;
        }
        if (!player.hasPermission(wandType.getPermission())) {
            player.sendMessage(this.i18n.get("message.no-permission-wand-type", this.i18n.get("wand." + wandType.getId() + ".name")));
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        BlockFace clickedFace = event.getBlockFace();
        if (clickedBlock == null) {
            return;
        }
        event.setCancelled(true);
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastUse = this.cooldowns.get(playerId);
        if (lastUse != null && currentTime - lastUse < 500L) {
            return;
        }
        this.handlePlacement(player, clickedBlock, clickedFace, itemInHand);
        this.cooldowns.put(playerId, currentTime);
    }

    private void handlePlacement(Player player, Block clickedBlock, BlockFace clickedFace, ItemStack wandItem) {
        Material targetMaterial = clickedBlock.getType();
        List<Location> locations = this.wandAction.calculatePlaceableLocations(player, clickedBlock, clickedFace, wandItem);
        if (locations.isEmpty()) {
            player.sendMessage(this.i18n.get("message.no-place"));
            return;
        }
        int placed = this.wandAction.placeBlocks(player, locations, targetMaterial, wandItem);
        if (placed > 0) {
            player.sendMessage(this.i18n.get("message.place-success", placed));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (this.wandItemManager.isWand(itemInHand)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        this.previewManager.clearPreview(player);
        this.cooldowns.remove(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.previewManager.clearPreview(player);
        this.cooldowns.remove(player.getUniqueId());
    }

    public void stopPreviewTask() {
        if (this.previewTaskId != -1 && !VersionHelper.isFolia()) {
            Bukkit.getScheduler().cancelTask(this.previewTaskId);
            this.previewTaskId = -1;
        }
    }
}

