/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.gui;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class WandGUI
implements InventoryHolder,
Listener {
    private final WandItemManager wandItemManager;
    private final I18nManager i18n;
    private final Inventory inventory;
    private static final String GUI_TITLE_KEY = "gui.wand.title";
    private String guiTitle;

    public WandGUI(WandItemManager wandItemManager, I18nManager i18n) {
        this.wandItemManager = wandItemManager;
        this.i18n = i18n;
        this.guiTitle = i18n.get(GUI_TITLE_KEY);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)9, (String)this.guiTitle);
        this.initializeItems();
    }

    private void initializeItems() {
        this.inventory.clear();
        int slot = 0;
        for (WandType type : WandType.values()) {
            if (slot >= 9) break;
            ItemStack wand = this.wandItemManager.createWand(type);
            this.inventory.setItem(slot, wand);
            ++slot;
        }
        ItemStack filler = this.createFillerItem();
        for (int i = slot; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
    }

    private ItemStack createFillerItem() {
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            filler.setItemMeta(meta);
        }
        return filler;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        WandType type;
        if (!(event.getInventory().getHolder() instanceof WandGUI)) {
            return;
        }
        event.setCancelled(true);
        if (event.getClickedInventory() == null || !(event.getClickedInventory().getHolder() instanceof WandGUI)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (clickedItem.getType() == Material.GRAY_STAINED_GLASS_PANE) {
            return;
        }
        if (this.wandItemManager.isWand(clickedItem) && (type = this.wandItemManager.getWandType(clickedItem)) != null) {
            if (!player.hasPermission("constructionwand.give") && !player.hasPermission(type.getPermission())) {
                player.sendMessage(this.i18n.get("message.no-permission"));
                return;
            }
            ItemStack newWand = this.wandItemManager.createWand(type);
            player.getInventory().addItem(new ItemStack[]{newWand});
            String wandName = this.i18n.get("wand." + type.getId() + ".name");
            player.sendMessage(this.i18n.get("message.wand-received", wandName));
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getHolder() instanceof WandGUI) {
            event.setCancelled(true);
        }
    }

    public String getGuiTitle() {
        return this.guiTitle;
    }
}

