/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.enchant;

public enum WandEnchantment {
    BUILDING_EXTENSION("building_extension", "\u5efa\u7b51\u6269\u5c55", "Building Extension", 3, new double[]{0.1, 0.25, 0.4});

    private final String id;
    private final String chineseName;
    private final String englishName;
    private final int maxLevel;
    private final double[] bonusPercentages;

    private WandEnchantment(String id, String chineseName, String englishName, int maxLevel, double[] bonusPercentages) {
        this.id = id;
        this.chineseName = chineseName;
        this.englishName = englishName;
        this.maxLevel = maxLevel;
        this.bonusPercentages = bonusPercentages;
    }

    public String getId() {
        return this.id;
    }

    public String getChineseName() {
        return this.chineseName;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getBonusPercentage(int level) {
        if (level <= 0) {
            return 0.0;
        }
        if (level > this.bonusPercentages.length) {
            double lastBonus = this.bonusPercentages[this.bonusPercentages.length - 1];
            double increment = this.bonusPercentages.length > 1 ? this.bonusPercentages[this.bonusPercentages.length - 1] - this.bonusPercentages[this.bonusPercentages.length - 2] : 0.15;
            return lastBonus + increment * (double)(level - this.bonusPercentages.length);
        }
        return this.bonusPercentages[level - 1];
    }

    public static String toRomanNumeral(int level) {
        if (level <= 0) {
            return "";
        }
        if (level == 1) {
            return "I";
        }
        if (level == 2) {
            return "II";
        }
        if (level == 3) {
            return "III";
        }
        if (level == 4) {
            return "IV";
        }
        if (level == 5) {
            return "V";
        }
        if (level == 6) {
            return "VI";
        }
        if (level == 7) {
            return "VII";
        }
        if (level == 8) {
            return "VIII";
        }
        if (level == 9) {
            return "IX";
        }
        if (level == 10) {
            return "X";
        }
        return String.valueOf(level);
    }

    public static WandEnchantment fromId(String id) {
        for (WandEnchantment enchant : WandEnchantment.values()) {
            if (!enchant.getId().equalsIgnoreCase(id)) continue;
            return enchant;
        }
        return null;
    }
}

