/*
 * Decompiled with CFR 0.152.
 */
package org.little100.constructionWand.enchant;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.little100.constructionWand.enchant.WandEnchantment;
import org.little100.constructionWand.i18n.I18nManager;
import org.little100.constructionWand.wand.WandItemManager;
import org.little100.constructionWand.wand.WandType;

public class EnchantmentManager {
    private final Plugin plugin;
    private final I18nManager i18n;
    private final Map<WandEnchantment, NamespacedKey> enchantKeys = new HashMap<WandEnchantment, NamespacedKey>();
    private WandItemManager wandItemManager;
    private FileConfiguration enchantConfig;
    private final Map<String, Map<Integer, Double>> enchantLevelBonuses = new HashMap<String, Map<Integer, Double>>();
    private final Map<String, Double> enchantDefaultIncrements = new HashMap<String, Double>();
    private final Map<String, Integer> enchantMaxLevels = new HashMap<String, Integer>();
    private final Map<String, Boolean> enchantEnabled = new HashMap<String, Boolean>();
    private static final String ENCHANT_PREFIX = "\u00a79";

    public EnchantmentManager(Plugin plugin, I18nManager i18n) {
        this.plugin = plugin;
        this.i18n = i18n;
        for (WandEnchantment enchant : WandEnchantment.values()) {
            this.enchantKeys.put(enchant, new NamespacedKey(plugin, "enchant_" + enchant.getId()));
        }
        this.loadEnchantmentConfig();
    }

    public void setWandItemManager(WandItemManager wandItemManager) {
        this.wandItemManager = wandItemManager;
    }

    public void loadEnchantmentConfig() {
        File enchantDir = new File(this.plugin.getDataFolder(), "enchant");
        if (!enchantDir.exists()) {
            enchantDir.mkdirs();
        }
        for (WandEnchantment enchant : WandEnchantment.values()) {
            this.loadEnchantmentSettings(enchant);
        }
        this.plugin.getLogger().info("\u9644\u9b54\u914d\u7f6e\u5df2\u52a0\u8f7d");
    }

    private void loadEnchantmentSettings(WandEnchantment enchant) {
        String id = enchant.getId();
        String configPath = "enchant/" + id + ".yml";
        File configFile = new File(this.plugin.getDataFolder(), configPath);
        if (!configFile.exists()) {
            if (this.plugin.getResource(configPath) != null) {
                this.plugin.saveResource(configPath, false);
            } else {
                this.createDefaultEnchantConfig(enchant, configFile);
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream defaultStream = this.plugin.getResource(configPath);
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
            config.setDefaults((Configuration)defaultConfig);
        }
        this.enchantEnabled.put(id, config.getBoolean("enabled", true));
        this.enchantMaxLevels.put(id, config.getInt("max-level", enchant.getMaxLevel()));
        this.enchantDefaultIncrements.put(id, config.getDouble("default-increment", 0.15));
        HashMap<Integer, Double> bonuses = new HashMap<Integer, Double>();
        ConfigurationSection levelsSection = config.getConfigurationSection("levels");
        if (levelsSection != null) {
            for (String key : levelsSection.getKeys(false)) {
                try {
                    int level = Integer.parseInt(key);
                    double bonus = levelsSection.getDouble(key);
                    bonuses.put(level, bonus);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().log(Level.WARNING, "\u65e0\u6548\u7684\u9644\u9b54\u7b49\u7ea7: " + key + " (\u9644\u9b54: " + id + ")");
                }
            }
        }
        if (bonuses.isEmpty()) {
            for (int i = 1; i <= 10; ++i) {
                bonuses.put(i, enchant.getBonusPercentage(i));
            }
        }
        this.enchantLevelBonuses.put(id, bonuses);
        this.plugin.getLogger().info("\u5df2\u52a0\u8f7d\u9644\u9b54\u914d\u7f6e: " + id);
    }

    private void createDefaultEnchantConfig(WandEnchantment enchant, File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            YamlConfiguration config = new YamlConfiguration();
            config.options().header("========================================\n" + enchant.getChineseName() + " (" + enchant.getEnglishName() + ") \u914d\u7f6e\n========================================");
            config.set("enabled", (Object)true);
            config.set("max-level", (Object)enchant.getMaxLevel());
            for (int i = 1; i <= 10; ++i) {
                config.set("levels." + i, (Object)enchant.getBonusPercentage(i));
            }
            config.set("default-increment", (Object)0.15);
            config.save(configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "\u65e0\u6cd5\u521b\u5efa\u9644\u9b54\u914d\u7f6e\u6587\u4ef6: " + configFile.getName(), e);
        }
    }

    public void reloadConfig() {
        this.enchantLevelBonuses.clear();
        this.enchantDefaultIncrements.clear();
        this.enchantMaxLevels.clear();
        this.enchantEnabled.clear();
        this.loadEnchantmentConfig();
    }

    public boolean isEnchantmentEnabled(WandEnchantment enchant) {
        return this.enchantEnabled.getOrDefault(enchant.getId(), true);
    }

    public int getMaxLevel(WandEnchantment enchant) {
        return this.enchantMaxLevels.getOrDefault(enchant.getId(), enchant.getMaxLevel());
    }

    public double getBonusPercentage(WandEnchantment enchant, int level) {
        if (level <= 0) {
            return 0.0;
        }
        String id = enchant.getId();
        Map<Integer, Double> bonuses = this.enchantLevelBonuses.get(id);
        if (bonuses != null && bonuses.containsKey(level)) {
            return bonuses.get(level);
        }
        if (bonuses != null && !bonuses.isEmpty()) {
            int maxConfiguredLevel = bonuses.keySet().stream().max(Integer::compare).orElse(1);
            double maxBonus = bonuses.getOrDefault(maxConfiguredLevel, 0.0);
            double increment = this.enchantDefaultIncrements.getOrDefault(id, 0.15);
            return maxBonus + increment * (double)(level - maxConfiguredLevel);
        }
        return enchant.getBonusPercentage(level);
    }

    public boolean addEnchantment(ItemStack item, WandEnchantment enchantment, int level) {
        if (item == null || enchantment == null || level <= 0) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        NamespacedKey key = this.enchantKeys.get((Object)enchantment);
        pdc.set(key, PersistentDataType.INTEGER, (Object)level);
        if (!meta.hasEnchants()) {
            meta.addEnchant(Enchantment.MENDING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        this.updateEnchantmentLore(meta, enchantment, level, item);
        item.setItemMeta(meta);
        return true;
    }

    public boolean removeEnchantment(ItemStack item, WandEnchantment enchantment) {
        NamespacedKey key;
        if (item == null || enchantment == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (pdc.has(key = this.enchantKeys.get((Object)enchantment), PersistentDataType.INTEGER)) {
            pdc.remove(key);
            this.removeEnchantmentFromLore(meta, enchantment);
            item.setItemMeta(meta);
            return true;
        }
        return false;
    }

    public int getEnchantmentLevel(ItemStack item, WandEnchantment enchantment) {
        NamespacedKey key;
        if (item == null || enchantment == null) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (pdc.has(key = this.enchantKeys.get((Object)enchantment), PersistentDataType.INTEGER)) {
            Integer level = (Integer)pdc.get(key, PersistentDataType.INTEGER);
            return level != null ? level : 0;
        }
        return 0;
    }

    public boolean hasEnchantment(ItemStack item, WandEnchantment enchantment) {
        return this.getEnchantmentLevel(item, enchantment) > 0;
    }

    public Map<WandEnchantment, Integer> getAllEnchantments(ItemStack item) {
        HashMap<WandEnchantment, Integer> enchantments = new HashMap<WandEnchantment, Integer>();
        if (item == null) {
            return enchantments;
        }
        for (WandEnchantment enchant : WandEnchantment.values()) {
            int level = this.getEnchantmentLevel(item, enchant);
            if (level <= 0) continue;
            enchantments.put(enchant, level);
        }
        return enchantments;
    }

    public int calculateBonusBlocks(ItemStack item, int baseBlocks) {
        int level = this.getEnchantmentLevel(item, WandEnchantment.BUILDING_EXTENSION);
        if (level <= 0) {
            return baseBlocks;
        }
        double bonus = this.getBonusPercentage(WandEnchantment.BUILDING_EXTENSION, level);
        return (int)Math.ceil((double)baseBlocks * (1.0 + bonus));
    }

    private void updateEnchantmentLore(ItemMeta meta, WandEnchantment enchantment, int level, ItemStack item) {
        WandType wandType;
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        String enchantName = this.i18n.get("enchant." + enchantment.getId() + ".name");
        String levelStr = WandEnchantment.toRomanNumeral(level);
        String enchantLine = ENCHANT_PREFIX + enchantName + " " + levelStr;
        boolean found = false;
        String searchPrefix = ENCHANT_PREFIX + enchantName;
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!line.startsWith(searchPrefix)) continue;
            lore.set(i, enchantLine);
            found = true;
            break;
        }
        if (!found) {
            int insertIndex = this.findEnchantInsertIndex(lore);
            lore.add(insertIndex, enchantLine);
        }
        if (enchantment == WandEnchantment.BUILDING_EXTENSION && this.wandItemManager != null && (wandType = this.wandItemManager.getWandType(item)) != null) {
            int baseBlocks = wandType.getMaxBlocks();
            int bonusBlocks = this.calculateBonusBlocks(item, baseBlocks);
            String maxBlocksPrefix = ChatColor.stripColor((String)this.i18n.get("wand.lore.max-blocks", 0)).split("0")[0];
            for (int i = 0; i < lore.size(); ++i) {
                String line = ChatColor.stripColor((String)((String)lore.get(i)));
                if (!line.contains(maxBlocksPrefix) && !line.contains("\u6700\u5927\u65b9\u5757") && !line.contains("Max Blocks")) continue;
                lore.set(i, this.i18n.get("wand.lore.max-blocks", bonusBlocks));
                break;
            }
        }
        meta.setLore(lore);
    }

    private void removeEnchantmentFromLore(ItemMeta meta, WandEnchantment enchantment) {
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        String enchantName = this.i18n.get("enchant." + enchantment.getId() + ".name");
        String searchPrefix = ENCHANT_PREFIX + enchantName;
        lore.removeIf(line -> line.startsWith(searchPrefix));
        meta.setLore(lore);
    }

    private int findEnchantInsertIndex(List<String> lore) {
        for (int i = 0; i < lore.size(); ++i) {
            String line = ChatColor.stripColor((String)lore.get(i));
            if (!line.contains("\u2501\u2501\u2501\u2501")) continue;
            return i + 1;
        }
        return 0;
    }

    public NamespacedKey getEnchantKey(WandEnchantment enchantment) {
        return this.enchantKeys.get((Object)enchantment);
    }
}

