/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.recipe;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.little100.avaritia_Plugin.manager.CustomCraftingManager;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class RecipeManager {
    private final JavaPlugin plugin;
    private final LanguageManager languageManager;
    private CustomCraftingManager customCraftingManager;
    private String currentRecipeKey;
    private final Map<String, ItemStack> itemCache = new HashMap<String, ItemStack>();

    public RecipeManager(JavaPlugin plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
    }

    public void setCustomCraftingManager(CustomCraftingManager manager) {
        this.customCraftingManager = manager;
    }

    public void loadRecipes() {
        YamlConfiguration recipesConfig;
        ConfigurationSection recipesSection;
        File recipesFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipesFile.exists()) {
            this.plugin.saveResource("recipe.yml", false);
        }
        if ((recipesSection = (recipesConfig = YamlConfiguration.loadConfiguration((File)recipesFile)).getConfigurationSection("recipes")) == null) {
            this.plugin.getLogger().warning(this.languageManager.getMessage("zh_cn", "recipe.not_found", new Object[0]));
            return;
        }
        int loadedCount = 0;
        for (String key : recipesSection.getKeys(false)) {
            ConfigurationSection recipeSection = recipesSection.getConfigurationSection(key);
            if (recipeSection == null) continue;
            this.currentRecipeKey = key;
            ItemStack result = this.createResultItem(recipeSection);
            if (result == null) continue;
            this.itemCache.put(key, result.clone());
            String recipeType = recipeSection.getString("type", "shaped");
            Object recipe = "shapeless".equals(recipeType) ? this.createShapelessRecipe(key, result, recipeSection) : this.createShapedRecipe(key, result, recipeSection);
            if (recipe == null) continue;
            this.registerRecipe((Recipe)recipe, key);
            if (this.customCraftingManager != null && this.customCraftingManager.needsCustomHandling(recipeSection) && this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u5408\u6210\u8868 " + key + " \u9700\u8981\u81ea\u5b9a\u4e49\u9a8c\u8bc1\uff08\u5df2\u6ce8\u518c\u5230Bukkit\u4f9b\u67e5\u770b\uff09");
            }
            ++loadedCount;
        }
        this.currentRecipeKey = null;
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info(this.languageManager.getMessage("zh_cn", "recipe.load_success", loadedCount));
        }
    }

    private ItemStack createResultItem(ConfigurationSection recipeSection) {
        String recipeKey;
        ItemMeta meta;
        ConfigurationSection resultSection = recipeSection.getConfigurationSection("result");
        if (resultSection == null) {
            return null;
        }
        Material resultMaterial = Material.getMaterial((String)resultSection.getString("material", ""));
        if (resultMaterial == null) {
            return null;
        }
        String customModelDataString = resultSection.getString("custom_model_data");
        String displayName = resultSection.getString("display_name");
        List lore = resultSection.getStringList("lore");
        int amount = resultSection.getInt("amount", 1);
        ItemStack result = new ItemStack(resultMaterial, amount);
        if (customModelDataString != null) {
            result = CustomModelDataUtil.setCustomModelData(result, customModelDataString);
        }
        if ((meta = result.getItemMeta()) != null) {
            if (displayName != null) {
                if (displayName.startsWith("items.")) {
                    meta.setDisplayName(this.languageManager.getMessage("zh_cn", displayName, new Object[0]));
                } else {
                    meta.setDisplayName(displayName);
                }
            }
            if (lore != null && !lore.isEmpty()) {
                ArrayList<String> translatedLore = new ArrayList<String>();
                for (String loreLine : lore) {
                    if (loreLine.startsWith("items.")) {
                        translatedLore.add(this.languageManager.getMessage("zh_cn", loreLine, new Object[0]));
                        continue;
                    }
                    translatedLore.add(loreLine);
                }
                meta.setLore(translatedLore);
            }
            result.setItemMeta(meta);
        }
        if ((recipeKey = this.getCurrentRecipeKey()) != null) {
            result = PDCUtil.addPluginData(result, recipeKey);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u5df2\u4e3a\u7269\u54c1\u6dfb\u52a0PDC\u6807\u8bc6: " + recipeKey);
            }
        }
        return result;
    }

    private ShapedRecipe createShapedRecipe(String key, ItemStack result, ConfigurationSection recipeSection) {
        NamespacedKey recipeKey = new NamespacedKey((Plugin)this.plugin, key);
        ShapedRecipe recipe = new ShapedRecipe(recipeKey, result);
        List shape = recipeSection.getStringList("shape");
        if (shape.isEmpty()) {
            return null;
        }
        recipe.shape(shape.toArray(new String[0]));
        ConfigurationSection ingredientsSection = recipeSection.getConfigurationSection("ingredients");
        if (ingredientsSection == null) {
            return null;
        }
        boolean needsCustomHandling = this.customCraftingManager != null && this.customCraftingManager.needsCustomHandling(recipeSection);
        for (String ingredientKey : ingredientsSection.getKeys(false)) {
            String ingredientValue = ingredientsSection.getString(ingredientKey, "");
            String resolvedItemId = this.resolveItemReference(ingredientValue);
            if (this.itemCache.containsKey(resolvedItemId)) {
                ItemStack pluginItem = this.itemCache.get(resolvedItemId);
                if (needsCustomHandling) {
                    RecipeChoice.ExactChoice choice = new RecipeChoice.ExactChoice(pluginItem);
                    recipe.setIngredient(ingredientKey.charAt(0), (RecipeChoice)choice);
                    continue;
                }
                recipe.setIngredient(ingredientKey.charAt(0), pluginItem.getType());
                continue;
            }
            Material ingredientMaterial = Material.getMaterial((String)ingredientValue);
            if (ingredientMaterial == null) continue;
            recipe.setIngredient(ingredientKey.charAt(0), ingredientMaterial);
        }
        return recipe;
    }

    private String getCurrentRecipeKey() {
        return this.currentRecipeKey;
    }

    private String resolveItemReference(String reference) {
        if (reference == null || reference.isEmpty()) {
            return reference;
        }
        if (reference.startsWith("avaritia:")) {
            String itemId = reference.substring("avaritia:".length());
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u89e3\u6790\u63d2\u4ef6\u7269\u54c1\u5f15\u7528: " + reference + " -> " + itemId);
            }
            return itemId;
        }
        if (reference.contains(":") && !reference.startsWith("avaritia:")) {
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u68c0\u6d4b\u5230\u5916\u90e8\u547d\u540d\u7a7a\u95f4\u7269\u54c1: " + reference);
            }
            return reference;
        }
        return reference;
    }

    private ShapelessRecipe createShapelessRecipe(String key, ItemStack result, ConfigurationSection recipeSection) {
        NamespacedKey recipeKey = new NamespacedKey((Plugin)this.plugin, key);
        ShapelessRecipe recipe = new ShapelessRecipe(recipeKey, result);
        ConfigurationSection ingredientsSection = recipeSection.getConfigurationSection("ingredients");
        if (ingredientsSection == null) {
            return null;
        }
        boolean needsCustomHandling = this.customCraftingManager != null && this.customCraftingManager.needsCustomHandling(recipeSection);
        for (String ingredientKey : ingredientsSection.getKeys(false)) {
            Material ingredientMaterial;
            RecipeChoice.ExactChoice choice;
            ItemStack pluginItem;
            String resolvedItemId;
            Object ingredientValue = ingredientsSection.get(ingredientKey);
            if (ingredientValue instanceof String) {
                String ingredientName = (String)ingredientValue;
                resolvedItemId = this.resolveItemReference(ingredientName);
                if (this.itemCache.containsKey(resolvedItemId)) {
                    pluginItem = this.itemCache.get(resolvedItemId);
                    if (needsCustomHandling) {
                        choice = new RecipeChoice.ExactChoice(pluginItem);
                        recipe.addIngredient((RecipeChoice)choice);
                        continue;
                    }
                    recipe.addIngredient(pluginItem.getType());
                    continue;
                }
                ingredientMaterial = Material.getMaterial((String)ingredientName);
                if (ingredientMaterial == null) continue;
                recipe.addIngredient(ingredientMaterial);
                continue;
            }
            if (!(ingredientValue instanceof Integer)) continue;
            int count = (Integer)ingredientValue;
            resolvedItemId = this.resolveItemReference(ingredientKey);
            if (this.itemCache.containsKey(resolvedItemId)) {
                pluginItem = this.itemCache.get(resolvedItemId);
                if (needsCustomHandling) {
                    choice = new RecipeChoice.ExactChoice(pluginItem);
                    for (int i = 0; i < count; ++i) {
                        recipe.addIngredient((RecipeChoice)choice);
                    }
                    continue;
                }
                for (int i = 0; i < count; ++i) {
                    recipe.addIngredient(pluginItem.getType());
                }
                continue;
            }
            ingredientMaterial = Material.getMaterial((String)ingredientKey);
            if (ingredientMaterial == null) continue;
            for (int i = 0; i < count; ++i) {
                recipe.addIngredient(ingredientMaterial);
            }
        }
        return recipe;
    }

    private void registerRecipe(Recipe recipe, String recipeName) {
        try {
            Bukkit.addRecipe((Recipe)recipe);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info(this.languageManager.getMessage("zh_cn", "recipe.loaded", recipeName));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u6ce8\u518c\u5408\u6210\u8868\u5931\u8d25 [" + recipeName + "]: " + e.getMessage());
        }
    }
}

