/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.FoliaUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class NeutroniumCompressorGUI
implements Listener {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;
    private final Map<Location, CompressorData> compressors = new ConcurrentHashMap<Location, CompressorData>();
    private final Map<UUID, Location> viewingCompressors = new ConcurrentHashMap<UUID, Location>();
    private final Map<String, SingularityRecipe> singularityRecipes = new HashMap<String, SingularityRecipe>();
    private FileConfiguration config;

    public NeutroniumCompressorGUI(Avaritia_Plugin plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        this.loadConfig();
        this.loadRecipes();
    }

    private void loadConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "neutronium_compressor.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("neutronium_compressor.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    private void loadRecipes() {
        ConfigurationSection singularitiesSection = this.config.getConfigurationSection("singularities");
        if (singularitiesSection == null) {
            this.plugin.getLogger().warning("\u538b\u7f29\u673a\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709\u627e\u5230 singularities \u914d\u7f6e\uff01");
            return;
        }
        for (String key : singularitiesSection.getKeys(false)) {
            ConfigurationSection recipeSection = singularitiesSection.getConfigurationSection(key);
            if (recipeSection == null) continue;
            ConfigurationSection materialsSection = recipeSection.getConfigurationSection("materials");
            if (materialsSection == null) {
                this.plugin.getLogger().warning("\u5947\u70b9\u914d\u65b9 " + key + " \u6ca1\u6709materials\u914d\u7f6e\uff01");
                continue;
            }
            HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
            for (String matName : materialsSection.getKeys(false)) {
                Material mat = Material.getMaterial((String)matName);
                int points = materialsSection.getInt(matName);
                if (mat == null) continue;
                materials.put(mat, points);
                this.plugin.getLogger().info("  - " + matName + " = " + points + "\u70b9");
            }
            int requiredPoints = recipeSection.getInt("required_points");
            String cmd = recipeSection.getString("output_cmd");
            if (materials.isEmpty()) continue;
            this.singularityRecipes.put(key, new SingularityRecipe(key, materials, requiredPoints, cmd));
            this.plugin.getLogger().info("\u52a0\u8f7d\u5947\u70b9\u914d\u65b9: " + key + " (\u9700\u8981" + requiredPoints + "\u70b9)");
        }
    }

    public void registerCompressor(Location location) {
        this.compressors.put(location, new CompressorData());
        this.plugin.getLogger().info("\u6ce8\u518c\u4e2d\u5b50\u6001\u7d20\u538b\u7f29\u673a: " + String.valueOf(location));
    }

    public void unregisterCompressor(Location location) {
        this.compressors.remove(location);
        this.plugin.getLogger().info("\u6ce8\u9500\u4e2d\u5b50\u6001\u7d20\u538b\u7f29\u673a: " + String.valueOf(location));
    }

    public List<ItemStack> getCompressorDrops(Location location) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        CompressorData data = this.compressors.get(location);
        if (data == null || data.singularityType == null || data.currentPoints <= 0) {
            return drops;
        }
        SingularityRecipe recipe = this.singularityRecipes.get(data.singularityType);
        if (recipe == null) {
            return drops;
        }
        Material lowestMaterial = null;
        int lowestPoints = Integer.MAX_VALUE;
        for (Map.Entry<Material, Integer> entry : recipe.materials.entrySet()) {
            if (entry.getValue() >= lowestPoints) continue;
            lowestPoints = entry.getValue();
            lowestMaterial = entry.getKey();
        }
        if (lowestMaterial == null || lowestPoints <= 0) {
            return drops;
        }
        int itemCount = data.currentPoints / lowestPoints;
        if (itemCount > 0) {
            while (itemCount > 0) {
                int stackSize = Math.min(itemCount, 64);
                ItemStack drop = new ItemStack(lowestMaterial, stackSize);
                drops.add(drop);
                itemCount -= stackSize;
            }
            this.plugin.getLogger().info("\u538b\u7f29\u673a " + String.valueOf(location) + " \u5c06\u6389\u843d " + data.currentPoints / lowestPoints + " \u4e2a " + String.valueOf(lowestMaterial) + " (\u603b\u70b9\u6570: " + data.currentPoints + ")");
        }
        return drops;
    }

    public void openCompressorGUI(Player player, Location location) {
        try {
            this.plugin.getLogger().info("\u5c1d\u8bd5\u4e3a\u73a9\u5bb6 " + player.getName() + " \u6253\u5f00\u538b\u7f29\u673aGUI\uff0c\u4f4d\u7f6e: " + String.valueOf(location));
            CompressorData data = this.compressors.get(location);
            if (data == null) {
                data = new CompressorData();
                this.compressors.put(location, data);
                this.plugin.getLogger().info("\u521b\u5efa\u65b0\u7684\u538b\u7f29\u673a\u6570\u636e");
            }
            String title = this.languageManager.getMessage(player, "neutronium_compressor_gui.title", new Object[0]);
            this.plugin.getLogger().info("GUI\u6807\u9898: " + title);
            Inventory gui = Bukkit.createInventory(null, (int)9, (String)title);
            this.plugin.getLogger().info("GUI\u521b\u5efa\u6210\u529f");
            this.updateGUI(gui, data, player);
            this.plugin.getLogger().info("GUI\u66f4\u65b0\u5b8c\u6210");
            this.viewingCompressors.put(player.getUniqueId(), location);
            player.openInventory(gui);
            this.plugin.getLogger().info("GUI\u5df2\u6253\u5f00\u7ed9\u73a9\u5bb6");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u6253\u5f00\u538b\u7f29\u673aGUI\u65f6\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
            player.sendMessage("\u00a7c\u6253\u5f00GUI\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0");
        }
    }

    private void updateGUI(Inventory gui, CompressorData data, Player player) {
        SingularityRecipe recipe;
        int percentage = 0;
        if (data.singularityType != null && (recipe = this.singularityRecipes.get(data.singularityType)) != null) {
            percentage = (int)((double)data.currentPoints * 100.0 / (double)recipe.requiredPoints);
        }
        int greenSlots = (int)Math.floor((double)percentage / 100.0 * 6.0);
        int[] progressSlots = new int[]{1, 2, 3, 5, 6, 7};
        for (int i = 0; i < progressSlots.length; ++i) {
            boolean isGreen = i < greenSlots;
            Material material = isGreen ? Material.LIME_STAINED_GLASS_PANE : Material.BLACK_STAINED_GLASS_PANE;
            ItemStack pane = new ItemStack(material);
            ItemMeta meta = pane.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(" ");
                pane.setItemMeta(meta);
            }
            gui.setItem(progressSlots[i], pane);
        }
        gui.setItem(4, this.createArrowItem(data, player));
        gui.setItem(8, this.createOutputItem(data, player));
    }

    private ItemStack createArrowItem(CompressorData data, Player player) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (data.singularityType == null) {
            meta.setDisplayName(this.languageManager.getMessage(player, "neutronium_compressor_gui.no_item", new Object[0]));
            meta.setLore(Arrays.asList(this.languageManager.getMessage(player, "neutronium_compressor_gui.put_material", new Object[0])));
        } else {
            SingularityRecipe recipe = this.singularityRecipes.get(data.singularityType);
            if (recipe != null) {
                String singularityName = this.languageManager.getMessage(player, "items." + data.singularityType + "_singularity.name", new Object[0]);
                int percentage = (int)((double)data.currentPoints * 100.0 / (double)recipe.requiredPoints);
                String currentItemMsg = MessageFormat.format(this.languageManager.getMessage(player, "neutronium_compressor_gui.current_item", new Object[0]), singularityName);
                String progressMsg = MessageFormat.format(this.languageManager.getMessage(player, "neutronium_compressor_gui.progress", new Object[0]), data.currentPoints, recipe.requiredPoints, percentage);
                meta.setDisplayName("\u00a7e\u00a7l\u8fdb\u5ea6: " + percentage + "%");
                meta.setLore(Arrays.asList("", currentItemMsg, progressMsg, "", this.languageManager.getMessage(player, "neutronium_compressor_gui.compressing", new Object[0])));
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createOutputItem(CompressorData data, Player player) {
        if (data.singularityType == null || data.currentPoints == 0) {
            return null;
        }
        SingularityRecipe recipe = this.singularityRecipes.get(data.singularityType);
        if (recipe == null) {
            return null;
        }
        if (data.currentPoints >= recipe.requiredPoints) {
            return this.createSingularity(recipe.singularityType, player);
        }
        return null;
    }

    private ItemStack createSingularity(String singularityType, Player player) {
        String itemId = singularityType + "_singularity";
        return this.createItemFromId(itemId, player);
    }

    private ItemStack createItemFromId(String itemId, Player player) {
        YamlConfiguration itemsConfig;
        ConfigurationSection itemSection;
        File itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        if (!itemsFile.exists()) {
            this.plugin.saveResource("items.yml", false);
        }
        if ((itemSection = (itemsConfig = YamlConfiguration.loadConfiguration((File)itemsFile)).getConfigurationSection("items." + itemId)) == null) {
            this.plugin.getLogger().warning("\u672a\u627e\u5230\u7269\u54c1\u5b9a\u4e49: " + itemId);
            return new ItemStack(Material.BARRIER);
        }
        return this.createItemFromSection(itemSection, player, itemId);
    }

    private ItemStack createItemFromSection(ConfigurationSection section, Player player, String itemId) {
        List loreKeys;
        String materialName = section.getString("material", "STONE");
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material);
        String cmd = section.getString("custom_model_data");
        if (cmd != null) {
            item = CustomModelDataUtil.setCustomModelData(item, cmd);
        }
        ItemMeta meta = item.getItemMeta();
        String displayNameKey = section.getString("display_name");
        if (displayNameKey != null) {
            String displayName = this.languageManager.getMessage(player, displayNameKey, new Object[0]);
            meta.setDisplayName(displayName);
        }
        if (!(loreKeys = section.getStringList("lore")).isEmpty()) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String loreKey : loreKeys) {
                lore.add(this.languageManager.getMessage(player, loreKey, new Object[0]));
            }
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        item = PDCUtil.addPluginData(item, itemId);
        return item;
    }

    private String getMaterialName(Material material, Player player) {
        String key = "materials." + material.name();
        String name = this.languageManager.getMessage(player, key, new Object[0]);
        if (!name.equals(key)) {
            return name;
        }
        return this.formatMaterialName(material.name());
    }

    private String formatMaterialName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return result.toString();
    }

    private SingularityRecipe findRecipeByMaterial(Material material) {
        for (SingularityRecipe recipe : this.singularityRecipes.values()) {
            if (!recipe.acceptsMaterial(material)) continue;
            return recipe;
        }
        return null;
    }

    private String getMaterialSingularityType(Material material) {
        SingularityRecipe recipe = this.findRecipeByMaterial(material);
        return recipe != null ? recipe.singularityType : null;
    }

    private boolean canAcceptMaterial(String singularityType, Material material) {
        SingularityRecipe recipe = this.singularityRecipes.get(singularityType);
        return recipe != null && recipe.acceptsMaterial(material);
    }

    private boolean isPluginItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return PDCUtil.isPluginItem(item);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClick(InventoryClickEvent event) {
        String expectedTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.equals(expectedTitle = this.languageManager.getMessage(player, "neutronium_compressor_gui.title", new Object[0]))) {
            return;
        }
        int slot = event.getRawSlot();
        Location loc = this.viewingCompressors.get(player.getUniqueId());
        if (loc == null) {
            return;
        }
        CompressorData data = this.compressors.get(loc);
        if (data == null) {
            return;
        }
        if (slot >= 9) {
            ItemStack clicked;
            if (event.isShiftClick() && (clicked = event.getCurrentItem()) != null && clicked.getType() != Material.AIR) {
                if (this.isPluginItem(clicked)) {
                    return;
                }
                String singularityType = this.getMaterialSingularityType(clicked.getType());
                if (singularityType != null) {
                    event.setCancelled(true);
                    if (data.singularityType == null || data.singularityType.equals(singularityType)) {
                        int amountToMove;
                        ItemStack inputSlot = event.getInventory().getItem(0);
                        int spaceLeft = 64;
                        if (inputSlot != null && inputSlot.getType() != Material.AIR) {
                            if (inputSlot.getType() == clicked.getType()) {
                                spaceLeft = 64 - inputSlot.getAmount();
                            } else {
                                return;
                            }
                        }
                        if ((amountToMove = Math.min(clicked.getAmount(), spaceLeft)) > 0) {
                            if (inputSlot == null || inputSlot.getType() == Material.AIR) {
                                inputSlot = clicked.clone();
                                inputSlot.setAmount(amountToMove);
                                event.getInventory().setItem(0, inputSlot);
                            } else {
                                inputSlot.setAmount(inputSlot.getAmount() + amountToMove);
                            }
                            if (clicked.getAmount() <= amountToMove) {
                                event.setCurrentItem(new ItemStack(Material.AIR));
                            } else {
                                clicked.setAmount(clicked.getAmount() - amountToMove);
                            }
                            this.handleInputItem(player, loc, data, event.getInventory().getItem(0), event.getInventory());
                        }
                    } else {
                        player.sendMessage("\u00a7c\u538b\u7f29\u673a\u6b63\u5728\u5904\u7406\u5176\u4ed6\u5947\u70b9\uff0c\u65e0\u6cd5\u653e\u5165\u4e0d\u540c\u7c7b\u578b\u7684\u6750\u6599\uff01");
                    }
                }
            }
            return;
        }
        if (slot == 0) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if (cursor != null && cursor.getType() != Material.AIR) {
                if (this.isPluginItem(cursor)) {
                    event.setCancelled(true);
                    player.sendMessage("\u00a7c\u63d2\u4ef6\u7269\u54c1\u4e0d\u80fd\u653e\u5165\u538b\u7f29\u673a\uff01");
                    return;
                }
                String singularityType = this.getMaterialSingularityType(cursor.getType());
                if (singularityType == null) {
                    event.setCancelled(true);
                    player.sendMessage("\u00a7c\u8fd9\u4e0d\u662f\u6709\u6548\u7684\u538b\u7f29\u6750\u6599\uff01");
                    return;
                }
                if (data.singularityType != null && !data.singularityType.equals(singularityType)) {
                    event.setCancelled(true);
                    player.sendMessage("\u00a7c\u538b\u7f29\u673a\u6b63\u5728\u5904\u7406\u5176\u4ed6\u5947\u70b9\uff0c\u65e0\u6cd5\u653e\u5165\u4e0d\u540c\u7c7b\u578b\u7684\u6750\u6599\uff01");
                    return;
                }
            }
            event.setCancelled(false);
            Inventory guiInv = event.getInventory();
            FoliaUtil.runAtLocationDelayed(this.plugin, loc, () -> {
                ItemStack inputItem = guiInv.getItem(0);
                if (inputItem != null && inputItem.getType() != Material.AIR) {
                    if (this.isPluginItem(inputItem)) {
                        guiInv.setItem(0, null);
                        player.getInventory().addItem(new ItemStack[]{inputItem});
                        player.sendMessage("\u00a7c\u63d2\u4ef6\u7269\u54c1\u4e0d\u80fd\u653e\u5165\u538b\u7f29\u673a\uff01");
                        return;
                    }
                    String type = this.getMaterialSingularityType(inputItem.getType());
                    if (type == null) {
                        guiInv.setItem(0, null);
                        player.getInventory().addItem(new ItemStack[]{inputItem});
                        player.sendMessage("\u00a7c\u8fd9\u4e0d\u662f\u6709\u6548\u7684\u538b\u7f29\u6750\u6599\uff01");
                        return;
                    }
                    if (data.singularityType != null && !data.singularityType.equals(type)) {
                        guiInv.setItem(0, null);
                        player.getInventory().addItem(new ItemStack[]{inputItem});
                        player.sendMessage("\u00a7c\u538b\u7f29\u673a\u6b63\u5728\u5904\u7406\u5176\u4ed6\u5947\u70b9\uff0c\u65e0\u6cd5\u653e\u5165\u4e0d\u540c\u7c7b\u578b\u7684\u6750\u6599\uff01\u5f53\u524d: \u00a7e" + this.languageManager.getMessage(player, "items." + data.singularityType + "_singularity.name", new Object[0]));
                        return;
                    }
                    this.handleInputItem(player, loc, data, inputItem, guiInv);
                }
            }, 1L);
        } else if (slot == 8) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if (cursor != null && cursor.getType() != Material.AIR) {
                event.setCancelled(true);
                return;
            }
            if (current != null && current.getType() != Material.AIR) {
                event.setCancelled(false);
                FoliaUtil.runAtLocationDelayed(this.plugin, loc, () -> {
                    data.singularityType = null;
                    data.currentPoints = 0;
                    if (this.viewingCompressors.containsKey(player.getUniqueId())) {
                        this.updateGUI(player.getOpenInventory().getTopInventory(), data, player);
                    }
                    player.sendMessage(this.languageManager.getMessage(player, "neutronium_compressor_gui.collected", new Object[0]));
                }, 1L);
            } else {
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(true);
        }
    }

    private void handleInputItem(Player player, Location loc, CompressorData data, ItemStack inputItem, Inventory gui) {
        if (this.isPluginItem(inputItem)) {
            player.sendMessage("\u00a7c\u63d2\u4ef6\u7269\u54c1\u4e0d\u80fd\u653e\u5165\u538b\u7f29\u673a\uff01");
            gui.setItem(0, null);
            player.getInventory().addItem(new ItemStack[]{inputItem});
            return;
        }
        Material material = inputItem.getType();
        SingularityRecipe recipe = this.findRecipeByMaterial(material);
        if (recipe == null) {
            player.sendMessage("\u00a7c\u8fd9\u4e0d\u662f\u6709\u6548\u7684\u538b\u7f29\u6750\u6599\uff01");
            gui.setItem(0, null);
            player.getInventory().addItem(new ItemStack[]{inputItem});
            return;
        }
        if (data.singularityType != null && !data.singularityType.equals(recipe.singularityType)) {
            player.sendMessage("\u00a7c\u4e0d\u80fd\u6df7\u5408\u4e0d\u540c\u7684\u5947\u70b9\u6750\u6599\uff01\u5f53\u524d\u6b63\u5728\u538b\u7f29: \u00a7e" + this.languageManager.getMessage(player, "items." + data.singularityType + "_singularity.name", new Object[0]));
            gui.setItem(0, null);
            player.getInventory().addItem(new ItemStack[]{inputItem});
            return;
        }
        int pointsPerItem = recipe.getPoints(material);
        int itemCount = inputItem.getAmount();
        int addedPoints = pointsPerItem * itemCount;
        if (data.singularityType == null) {
            data.singularityType = recipe.singularityType;
        }
        data.currentPoints += addedPoints;
        gui.setItem(0, null);
        this.updateGUI(gui, data, player);
        String materialName = this.getMaterialName(material, player);
        player.sendMessage("\u00a7a\u5df2\u6dfb\u52a0 \u00a7e" + itemCount + " \u00a7a\u4e2a \u00a7e" + materialName + " \u00a7a(+" + addedPoints + "\u70b9) \u00a7a\u5230\u538b\u7f29\u673a\uff01 (\u00a7e" + data.currentPoints + "/" + recipe.requiredPoints + "\u00a7a)");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClose(InventoryCloseEvent event) {
        String expectedTitle;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        if (title.equals(expectedTitle = this.languageManager.getMessage(player, "neutronium_compressor_gui.title", new Object[0]))) {
            this.viewingCompressors.remove(player.getUniqueId());
        }
    }

    private static class SingularityRecipe {
        String singularityType;
        Map<Material, Integer> materials;
        int requiredPoints;
        String outputCustomModelData;

        SingularityRecipe(String type, Map<Material, Integer> mats, int points, String cmd) {
            this.singularityType = type;
            this.materials = mats;
            this.requiredPoints = points;
            this.outputCustomModelData = cmd;
        }

        boolean acceptsMaterial(Material material) {
            return this.materials.containsKey(material);
        }

        int getPoints(Material material) {
            return this.materials.getOrDefault(material, 0);
        }
    }

    private static class CompressorData {
        String singularityType = null;
        int currentPoints = 0;

        private CompressorData() {
        }
    }
}

