/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.FoliaUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class NeutronCollectorGUI
implements Listener {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;
    private int ticksPerItem;
    private String outputItemId;
    private Material progressMaterial;
    private int updateInterval;
    private final Map<Location, CollectorData> collectors = new HashMap<Location, CollectorData>();
    private final Map<UUID, Location> viewingCollectors = new HashMap<UUID, Location>();

    public NeutronCollectorGUI(Avaritia_Plugin plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loadConfig();
    }

    private void loadConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "neutron_collector.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("neutron_collector.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        this.ticksPerItem = config.getInt("production.ticks_per_item", 7111);
        this.outputItemId = config.getString("production.output_item", "neutron_dust");
        String materialName = config.getString("gui.progress_item", "LIGHT_BLUE_STAINED_GLASS_PANE");
        this.progressMaterial = Material.getMaterial((String)materialName);
        if (this.progressMaterial == null) {
            this.progressMaterial = Material.LIGHT_BLUE_STAINED_GLASS_PANE;
        }
        this.updateInterval = config.getInt("gui.update_interval", 20);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u4e2d\u5b50\u6001\u7d20\u6536\u96c6\u5668\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210:");
            this.plugin.getLogger().info("  \u751f\u4ea7\u5468\u671f: " + this.ticksPerItem + " ticks");
            this.plugin.getLogger().info("  \u4ea7\u51fa\u7269\u54c1: " + this.outputItemId);
        }
    }

    public void registerCollector(Location location) {
        if (!this.collectors.containsKey(location)) {
            CollectorData data = new CollectorData();
            this.collectors.put(location, data);
            this.startProductionTask(location, data);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u6ce8\u518c\u4e2d\u5b50\u6001\u7d20\u6536\u96c6\u5668: " + this.locationToString(location));
            }
        }
    }

    public void unregisterCollector(Location location) {
        CollectorData data = this.collectors.remove(location);
        if (data != null && data.task != null) {
            data.task.cancel();
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u6ce8\u9500\u4e2d\u5b50\u6001\u7d20\u6536\u96c6\u5668: " + this.locationToString(location));
        }
    }

    public void openCollectorGUI(Player player, Location location) {
        CollectorData data = this.collectors.get(location);
        if (data == null) {
            data = new CollectorData();
            this.collectors.put(location, data);
        }
        String title = this.languageManager.getMessage(player, "neutron_collector_gui.title", new Object[0]);
        Inventory gui = Bukkit.createInventory(null, (int)9, (String)title);
        this.updateGUI(gui, data, player);
        this.viewingCollectors.put(player.getUniqueId(), location);
        player.openInventory(gui);
    }

    private void updateGUI(Inventory gui, CollectorData data, Player player) {
        ItemStack output;
        int[] slots;
        int progress = data.getProgress(this.ticksPerItem);
        int remainingSeconds = data.getRemainingSeconds(this.ticksPerItem);
        ItemStack progressItem = new ItemStack(this.progressMaterial);
        ItemMeta meta = progressItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.languageManager.getMessage(player, "neutron_collector_gui.progress", new Object[0]).replace("{0}", String.valueOf(progress)));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.languageManager.getMessage(player, "neutron_collector_gui.time_remaining", new Object[0]).replace("{0}", String.valueOf(remainingSeconds)));
            lore.add(this.languageManager.getMessage(player, "neutron_collector_gui.producing", new Object[0]));
            meta.setLore(lore);
            progressItem.setItemMeta(meta);
        }
        for (int slot : slots = new int[]{0, 1, 2, 3, 5, 6, 7, 8}) {
            gui.setItem(slot, progressItem);
        }
        if (data.currentTicks >= (long)this.ticksPerItem && (output = this.createOutputItem(player)) != null) {
            gui.setItem(4, output);
        }
    }

    private ItemStack createOutputItem(Player player) {
        ItemMeta meta;
        YamlConfiguration config;
        ConfigurationSection section;
        File itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        if (!itemsFile.exists()) {
            this.plugin.saveResource("items.yml", false);
        }
        if ((section = (config = YamlConfiguration.loadConfiguration((File)itemsFile)).getConfigurationSection("items." + this.outputItemId)) == null) {
            this.plugin.getLogger().warning("\u627e\u4e0d\u5230\u7269\u54c1\u5b9a\u4e49: " + this.outputItemId);
            return null;
        }
        String materialName = section.getString("material", "IRON_NUGGET");
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            material = Material.IRON_NUGGET;
        }
        ItemStack item = new ItemStack(material);
        String cmd = section.getString("custom_model_data");
        if (cmd != null) {
            item = CustomModelDataUtil.setCustomModelData(item, cmd);
        }
        if ((meta = item.getItemMeta()) != null) {
            String displayName = section.getString("display_name");
            if (displayName != null && displayName.startsWith("items.")) {
                displayName = this.languageManager.getMessage(player, displayName, new Object[0]);
            }
            meta.setDisplayName(displayName);
            List lore = section.getStringList("lore");
            if (!lore.isEmpty()) {
                ArrayList<String> translatedLore = new ArrayList<String>();
                for (String line : lore) {
                    if (line.startsWith("items.")) {
                        translatedLore.add(this.languageManager.getMessage(player, line, new Object[0]));
                        continue;
                    }
                    translatedLore.add(line);
                }
                meta.setLore(translatedLore);
            }
            item.setItemMeta(meta);
        }
        return PDCUtil.addPluginData(item, this.outputItemId);
    }

    private void startProductionTask(Location location, CollectorData data) {
        data.task = FoliaUtil.runAtLocation(this.plugin, location, () -> {
            if (data.currentTicks < (long)this.ticksPerItem) {
                ++data.currentTicks;
            }
            for (Map.Entry<UUID, Location> entry : new HashMap<UUID, Location>(this.viewingCollectors).entrySet()) {
                Inventory openInv;
                Player player;
                if (!entry.getValue().equals((Object)location) || (player = Bukkit.getPlayer((UUID)entry.getKey())) == null || !player.isOnline() || (openInv = player.getOpenInventory().getTopInventory()) == null || openInv.getSize() != 9) continue;
                this.updateGUI(openInv, data, player);
            }
        }, 1L, 1L);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        ItemStack output;
        CollectorData data;
        Location loc;
        String expectedTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.equals(expectedTitle = this.languageManager.getMessage(player, "neutron_collector_gui.title", new Object[0]))) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot == 4 && (loc = this.viewingCollectors.get(player.getUniqueId())) != null && (data = this.collectors.get(loc)) != null && data.currentTicks >= (long)this.ticksPerItem && (output = this.createOutputItem(player)) != null) {
            player.getInventory().addItem(new ItemStack[]{output});
            data.currentTicks = 0L;
            data.startTime = System.currentTimeMillis();
            this.updateGUI(event.getInventory(), data, player);
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.viewingCollectors.remove(event.getPlayer().getUniqueId());
        }
    }

    private String locationToString(Location loc) {
        return String.format("%s[%d,%d,%d]", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public Map<Location, CollectorData> getCollectors() {
        return this.collectors;
    }

    public static class CollectorData {
        public long currentTicks = 0L;
        public long startTime = System.currentTimeMillis();
        public ScheduledTask task = null;

        public int getProgress(int maxTicks) {
            return (int)(this.currentTicks * 100L / (long)maxTicks);
        }

        public int getRemainingSeconds(int maxTicks) {
            long remaining = (long)maxTicks - this.currentTicks;
            return (int)(remaining / 20L);
        }
    }
}

