/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private final JavaPlugin plugin;
    private final Map<String, FileConfiguration> languages = new HashMap<String, FileConfiguration>();
    private final Map<UUID, String> playerLanguages = new HashMap<UUID, String>();
    private String defaultLanguage;
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"zh_cn", "en_us", "lzh"};

    public LanguageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.defaultLanguage = plugin.getConfig().getString("default_language", "zh_cn");
        this.loadLanguages();
        this.loadPlayerLanguages();
    }

    private void loadLanguages() {
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (String lang : SUPPORTED_LANGUAGES) {
            File langFile = new File(langFolder, lang + ".yml");
            if (!langFile.exists()) {
                this.plugin.saveResource("lang/" + lang + ".yml", false);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)langFile);
            this.languages.put(lang, (FileConfiguration)config);
            this.plugin.getLogger().info("\u5df2\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6: " + lang + ".yml");
        }
    }

    private void loadPlayerLanguages() {
        File playerLangFile = new File(this.plugin.getDataFolder(), "player_languages.yml");
        if (playerLangFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerLangFile);
            for (String uuidString : config.getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    String language = config.getString(uuidString);
                    if (language == null || !this.languages.containsKey(language)) continue;
                    this.playerLanguages.put(uuid, language);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("\u65e0\u6548\u7684UUID\u5728player_languages.yml\u4e2d: " + uuidString);
                }
            }
        }
    }

    public void savePlayerLanguages() {
        File playerLangFile = new File(this.plugin.getDataFolder(), "player_languages.yml");
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<UUID, String> entry : this.playerLanguages.entrySet()) {
            config.set(entry.getKey().toString(), (Object)entry.getValue());
        }
        try {
            config.save(playerLangFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u4fdd\u5b58\u73a9\u5bb6\u8bed\u8a00\u8bbe\u7f6e\u5931\u8d25: " + e.getMessage());
        }
    }

    public String getPlayerLanguage(Player player) {
        return this.playerLanguages.getOrDefault(player.getUniqueId(), this.defaultLanguage);
    }

    public boolean setPlayerLanguage(Player player, String language) {
        if (!this.languages.containsKey(language)) {
            return false;
        }
        this.playerLanguages.put(player.getUniqueId(), language);
        this.savePlayerLanguages();
        return true;
    }

    public String getMessage(Player player, String key, Object ... args) {
        String language = this.getPlayerLanguage(player);
        return this.getMessage(language, key, args);
    }

    public String getMessage(String language, String key, Object ... args) {
        String message;
        FileConfiguration config = this.languages.get(language);
        if (config == null) {
            config = this.languages.get(this.defaultLanguage);
        }
        if ((message = config.getString(key)) == null && (config = this.languages.get(this.defaultLanguage)) != null) {
            message = config.getString(key);
        }
        if (message == null) {
            return "Missing translation: " + key;
        }
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                message = message.replace("{" + i + "}", String.valueOf(args[i]));
            }
        }
        return message.replace("&", "\u00a7");
    }

    public void sendMessage(Player player, String key, Object ... args) {
        player.sendMessage(this.getMessage(player, key, args));
    }

    public String[] getSupportedLanguages() {
        return (String[])SUPPORTED_LANGUAGES.clone();
    }

    public boolean isLanguageSupported(String language) {
        return this.languages.containsKey(language);
    }

    public String getLanguageDisplayName(String language) {
        FileConfiguration config = this.languages.get(language);
        if (config != null) {
            return config.getString("language.display_name", language);
        }
        return language;
    }

    public void reload() {
        this.languages.clear();
        this.loadLanguages();
        this.plugin.getLogger().info("\u8bed\u8a00\u6587\u4ef6\u5df2\u91cd\u65b0\u52a0\u8f7d");
    }
}

