/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class ItemManager {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;

    public ItemManager(Avaritia_Plugin plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
    }

    public void updatePlayerItems(Player player) {
        ItemStack updated;
        String language = this.languageManager.getPlayerLanguage(player);
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item == null || !PDCUtil.isPluginItem(item) || (updated = this.updateItemLanguage(item, language)) == null) continue;
            player.getInventory().setItem(i, updated);
        }
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (int i = 0; i < armor.length; ++i) {
            if (armor[i] == null || !PDCUtil.isPluginItem(armor[i]) || (updated = this.updateItemLanguage(armor[i], language)) == null) continue;
            armor[i] = updated;
        }
        player.getInventory().setArmorContents(armor);
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (offHand != null && PDCUtil.isPluginItem(offHand) && (updated = this.updateItemLanguage(offHand, language)) != null) {
            player.getInventory().setItemInOffHand(updated);
        }
        for (int i = 0; i < player.getEnderChest().getSize(); ++i) {
            ItemStack updated2;
            ItemStack item = player.getEnderChest().getItem(i);
            if (item == null || !PDCUtil.isPluginItem(item) || (updated2 = this.updateItemLanguage(item, language)) == null) continue;
            player.getEnderChest().setItem(i, updated2);
        }
        player.updateInventory();
    }

    private ItemStack updateItemLanguage(ItemStack item, String language) {
        String itemId = PDCUtil.getItemId(item);
        if (itemId == null) {
            return null;
        }
        ConfigurationSection itemSection = this.getItemSectionFromItemsYml(itemId);
        if (itemSection != null) {
            return this.updateItemFromItemsYml(item, itemId, itemSection, language);
        }
        ConfigurationSection resultSection = this.getItemSectionFromRecipeYml(itemId);
        if (resultSection != null) {
            return this.updateItemFromRecipeYml(item, itemId, resultSection, language);
        }
        return null;
    }

    private ConfigurationSection getItemSectionFromItemsYml(String itemId) {
        File itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        if (!itemsFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)itemsFile);
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection == null) {
            return null;
        }
        return itemsSection.getConfigurationSection(itemId);
    }

    private ConfigurationSection getItemSectionFromRecipeYml(String itemId) {
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipeFile);
        ConfigurationSection recipesSection = config.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return null;
        }
        ConfigurationSection recipeSection = recipesSection.getConfigurationSection(itemId);
        if (recipeSection == null) {
            return null;
        }
        return recipeSection.getConfigurationSection("result");
    }

    private ItemStack updateItemFromItemsYml(ItemStack item, String itemId, ConfigurationSection section, String language) {
        List loreKeys;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        String displayNameKey = section.getString("display_name");
        if (displayNameKey != null && displayNameKey.startsWith("items.")) {
            String translatedName = this.languageManager.getMessage(language, displayNameKey, new Object[0]);
            meta.setDisplayName(translatedName);
        }
        if (!(loreKeys = section.getStringList("lore")).isEmpty()) {
            ArrayList<String> translatedLore = new ArrayList<String>();
            for (String loreKey : loreKeys) {
                if (loreKey.startsWith("items.")) {
                    translatedLore.add(this.languageManager.getMessage(language, loreKey, new Object[0]));
                    continue;
                }
                translatedLore.add(loreKey);
            }
            meta.setLore(translatedLore);
        }
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack updateItemFromRecipeYml(ItemStack item, String itemId, ConfigurationSection resultSection, String language) {
        String loreLine;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        String langName = this.languageManager.getMessage(language, "items." + itemId + ".name", new Object[0]);
        if (!langName.startsWith("Missing translation:")) {
            meta.setDisplayName(langName);
        } else if (resultSection.getString("display_name") != null) {
            String displayName = resultSection.getString("display_name");
            if (displayName.startsWith("items.")) {
                meta.setDisplayName(this.languageManager.getMessage(language, displayName, new Object[0]));
            } else {
                meta.setDisplayName(displayName);
            }
        }
        ArrayList<String> langLore = new ArrayList<String>();
        int loreIndex = 0;
        while (!(loreLine = this.languageManager.getMessage(language, "items." + itemId + ".lore." + loreIndex, new Object[0])).startsWith("Missing translation:")) {
            langLore.add(loreLine);
            ++loreIndex;
        }
        if (!langLore.isEmpty()) {
            meta.setLore(langLore);
        } else {
            List configLore = resultSection.getStringList("lore");
            if (!configLore.isEmpty()) {
                ArrayList<String> translatedLore = new ArrayList<String>();
                for (String loreLine2 : configLore) {
                    if (loreLine2.startsWith("items.")) {
                        translatedLore.add(this.languageManager.getMessage(language, loreLine2, new Object[0]));
                        continue;
                    }
                    translatedLore.add(loreLine2);
                }
                meta.setLore(translatedLore);
            }
        }
        item.setItemMeta(meta);
        return item;
    }
}

