/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.little100.avaritia_Plugin.manager.GUIConfigManager;
import org.little100.avaritia_Plugin.manager.LanguageManager;

public class GUIManager
implements Listener {
    private final JavaPlugin plugin;
    private final LanguageManager languageManager;
    private final GUIConfigManager configManager;
    private final Map<UUID, GUISession> editingSessions = new HashMap<UUID, GUISession>();

    public GUIManager(JavaPlugin plugin, LanguageManager languageManager, GUIConfigManager configManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        this.configManager = configManager;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openEditGUI(Player player, int size) {
        String title = this.languageManager.getMessage(player, "gui.edit_title", size);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.addEditModeItems(inventory, size);
        this.editingSessions.put(player.getUniqueId(), new GUISession(size, "edit"));
        player.openInventory(inventory);
        this.languageManager.sendMessage(player, "gui.edit_opened", size);
    }

    public void openViewGUI(Player player, int size) {
        String title = this.languageManager.getMessage(player, "gui.view_title", size);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.addViewModeItems(inventory, size);
        this.editingSessions.put(player.getUniqueId(), new GUISession(size, "view"));
        player.openInventory(inventory);
        this.languageManager.sendMessage(player, "gui.view_opened", size);
    }

    public void openNewGUI(Player player, int size) {
        String title = this.languageManager.getMessage(player, "gui.new_title", size);
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.editingSessions.put(player.getUniqueId(), new GUISession(size, "new"));
        player.openInventory(inventory);
        this.languageManager.sendMessage(player, "gui.new_opened", size);
    }

    public void openCreateGUI(Player player, String fileName, int size) {
        String title = "\u00a76\u521b\u5efaGUI: \u00a7f" + fileName + " \u00a77(" + size + "\u69fd)";
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)title);
        this.editingSessions.put(player.getUniqueId(), new GUISession(size, "create", fileName));
        player.openInventory(inventory);
        player.sendMessage("\u00a7a\u5df2\u6253\u5f00\u521b\u5efa\u6a21\u5f0fGUI: \u00a7f" + fileName);
        player.sendMessage("\u00a77\u5173\u95edGUI\u540e\u5c06\u81ea\u52a8\u4fdd\u5b58\u5230\u6587\u4ef6");
    }

    private void addEditModeItems(Inventory inventory, int size) {
        ItemStack cornerItem = new ItemStack(Material.BARRIER);
        ItemMeta cornerMeta = cornerItem.getItemMeta();
        if (cornerMeta != null) {
            cornerMeta.setDisplayName("\u00a7c\u7f16\u8f91\u6a21\u5f0f\u6807\u8bb0");
            cornerMeta.setLore(Arrays.asList("\u00a77\u8fd9\u662f\u7f16\u8f91\u6a21\u5f0f\u7684GUI", "\u00a77\u5927\u5c0f: \u00a7f" + size + " \u00a77\u69fd\u4f4d", "\u00a77\u4f60\u53ef\u4ee5\u5728\u8fd9\u91cc\u653e\u7f6e\u7269\u54c1\u8fdb\u884c\u7f16\u8f91"));
            cornerItem.setItemMeta(cornerMeta);
        }
        if (size == 1) {
            inventory.setItem(0, cornerItem);
        } else if (size <= 9) {
            inventory.setItem(0, cornerItem);
            if (size > 1) {
                inventory.setItem(size - 1, cornerItem);
            }
        } else {
            inventory.setItem(0, cornerItem);
            if (size >= 9) {
                inventory.setItem(8, cornerItem);
            }
            if (size >= 45) {
                inventory.setItem(size - 9, cornerItem);
                inventory.setItem(size - 1, cornerItem);
            }
        }
        if (size >= 3) {
            this.addToolItem(inventory, Math.min(1, size - 1), Material.DIAMOND_SWORD, "\u00a7b\u793a\u4f8b\u6b66\u5668", "\u00a77\u8fd9\u662f\u4e00\u4e2a\u793a\u4f8b\u7269\u54c1");
        }
        if (size >= 5) {
            this.addToolItem(inventory, Math.min(2, size - 1), Material.EMERALD, "\u00a7a\u793a\u4f8b\u6750\u6599", "\u00a77\u8fd9\u662f\u4e00\u4e2a\u6750\u6599\u7269\u54c1");
        }
        if (size >= 18) {
            this.addToolItem(inventory, 9, Material.BOOK, "\u00a7e\u793a\u4f8b\u4e66\u7c4d", "\u00a77\u8fd9\u662f\u4e00\u4e2a\u77e5\u8bc6\u7269\u54c1");
        }
    }

    private void addViewModeItems(Inventory inventory, int size) {
        Material material = Material.GLASS_PANE;
        try {
            material = Material.valueOf((String)"LIGHT_BLUE_STAINED_GLASS_PANE");
        }
        catch (IllegalArgumentException e) {
            material = Material.GLASS_PANE;
        }
        if (size == 1) {
            ItemStack specialItem = new ItemStack(Material.COMPASS);
            ItemMeta specialMeta = specialItem.getItemMeta();
            if (specialMeta != null) {
                specialMeta.setDisplayName("\u00a7b\u5355\u683c\u67e5\u770b\u6a21\u5f0f");
                specialMeta.setLore(Arrays.asList("\u00a77\u8fd9\u662f\u4e00\u4e2a1\u69fd\u4f4d\u7684GUI", "\u00a77\u975e\u5e38\u7d27\u51d1\u7684\u754c\u9762\u8bbe\u8ba1"));
                specialItem.setItemMeta(specialMeta);
            }
            inventory.setItem(0, specialItem);
        } else if (size <= 5) {
            Material[] smallGuiMaterials = new Material[]{Material.RED_WOOL, Material.ORANGE_WOOL, Material.YELLOW_WOOL, Material.GREEN_WOOL, Material.BLUE_WOOL};
            for (int i = 0; i < size; ++i) {
                Material itemMaterial = smallGuiMaterials[i % smallGuiMaterials.length];
                try {
                    ItemStack colorItem = new ItemStack(itemMaterial);
                    ItemMeta colorMeta = colorItem.getItemMeta();
                    if (colorMeta != null) {
                        colorMeta.setDisplayName("\u00a7b\u5c0f\u578bGUI - \u4f4d\u7f6e " + (i + 1));
                        colorMeta.setLore(Arrays.asList("\u00a77GUI\u5927\u5c0f: " + size + " \u69fd\u4f4d"));
                        colorItem.setItemMeta(colorMeta);
                    }
                    inventory.setItem(i, colorItem);
                    continue;
                }
                catch (Exception e) {
                    ItemStack fallbackItem = new ItemStack(material);
                    ItemMeta fallbackMeta = fallbackItem.getItemMeta();
                    if (fallbackMeta != null) {
                        fallbackMeta.setDisplayName("\u00a7b\u67e5\u770b\u6a21\u5f0f - \u4f4d\u7f6e " + (i + 1));
                        fallbackMeta.setLore(Arrays.asList("\u00a77GUI\u5927\u5c0f: " + size + " \u69fd\u4f4d"));
                        fallbackItem.setItemMeta(fallbackMeta);
                    }
                    inventory.setItem(i, fallbackItem);
                }
            }
        } else {
            int itemsToPlace = Math.min(size, Math.max(9, size / 6));
            for (int i = 0; i < itemsToPlace && i < size; ++i) {
                ItemStack glassPane = new ItemStack(material);
                ItemMeta glassMeta = glassPane.getItemMeta();
                if (glassMeta != null) {
                    glassMeta.setDisplayName("\u00a7b\u67e5\u770b\u6a21\u5f0f");
                    glassMeta.setLore(Arrays.asList("\u00a77GUI\u5927\u5c0f: " + size + " \u69fd\u4f4d"));
                    glassPane.setItemMeta(glassMeta);
                }
                inventory.setItem(i, glassPane);
            }
        }
    }

    private void addToolItem(Inventory inventory, int slot, Material material, String name, String lore) {
        if (slot >= inventory.getSize()) {
            return;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        inventory.setItem(slot, item);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID playerId = player.getUniqueId();
        if (!this.editingSessions.containsKey(playerId)) {
            return;
        }
        GUISession session = this.editingSessions.get(playerId);
        if ("view".equals(session.mode)) {
            event.setCancelled(true);
            this.languageManager.sendMessage(player, "gui.view_mode_readonly", new Object[0]);
            return;
        }
        if ("edit".equals(session.mode) || "new".equals(session.mode)) {
            this.languageManager.sendMessage(player, "gui.item_modified", new Object[0]);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.editingSessions.containsKey(playerId)) {
            return;
        }
        GUISession session = this.editingSessions.remove(playerId);
        switch (session.mode) {
            case "edit": {
                this.languageManager.sendMessage(player, "gui.edit_closed", new Object[0]);
                break;
            }
            case "view": {
                this.languageManager.sendMessage(player, "gui.view_closed", new Object[0]);
                break;
            }
            case "new": {
                this.languageManager.sendMessage(player, "gui.new_closed", new Object[0]);
                break;
            }
            case "create": {
                if (session.fileName == null) break;
                boolean success = this.configManager.saveGui(session.fileName, event.getInventory(), player);
                if (success) {
                    player.sendMessage("\u00a7a\u5df2\u81ea\u52a8\u4fdd\u5b58GUI\u5230\u6587\u4ef6: \u00a7f" + session.fileName + ".yml");
                    player.sendMessage("\u00a77\u6587\u4ef6\u4f4d\u7f6e: \u00a7fplugins/Avaritia_Plugin/guis/" + session.fileName + ".yml");
                    break;
                }
                player.sendMessage("\u00a7c\u4fdd\u5b58GUI\u5931\u8d25\uff01\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u9519\u8bef\u4fe1\u606f\u3002");
            }
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            long duration = System.currentTimeMillis() - session.createTime;
            this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u5173\u95ed\u4e86 " + session.mode + " \u6a21\u5f0fGUI\uff0c\u6301\u7eed\u65f6\u95f4: " + duration / 1000L + "\u79d2");
        }
    }

    public int getActiveSessionsCount() {
        return this.editingSessions.size();
    }

    public void cleanupExpiredSessions() {
        long currentTime = System.currentTimeMillis();
        long expireTime = 3600000L;
        this.editingSessions.entrySet().removeIf(entry -> currentTime - ((GUISession)entry.getValue()).createTime > expireTime);
    }

    private static class GUISession {
        public final int size;
        public final String mode;
        public final String fileName;
        public final long createTime;

        public GUISession(int size, String mode) {
            this(size, mode, null);
        }

        public GUISession(int size, String mode, String fileName) {
            this.size = size;
            this.mode = mode;
            this.fileName = fileName;
            this.createTime = System.currentTimeMillis();
        }
    }
}

