/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.little100.avaritia_Plugin.Avaritia_Plugin;

public class GUIConfigManager {
    private final Avaritia_Plugin plugin;
    private final File guiFolder;
    private final Map<UUID, String> editingGuis = new HashMap<UUID, String>();

    public GUIConfigManager(Avaritia_Plugin plugin) {
        this.plugin = plugin;
        this.guiFolder = new File(plugin.getDataFolder(), "guis");
        if (!this.guiFolder.exists()) {
            this.guiFolder.mkdirs();
        }
    }

    public void setEditingGui(Player player, String fileName) {
        this.editingGuis.put(player.getUniqueId(), fileName);
    }

    public String getEditingGui(Player player) {
        return this.editingGuis.get(player.getUniqueId());
    }

    public void removeEditingGui(Player player) {
        this.editingGuis.remove(player.getUniqueId());
    }

    public boolean saveGui(String fileName, Inventory inventory, Player player) {
        try {
            File guiFile = new File(this.guiFolder, fileName + ".yml");
            YamlConfiguration config = new YamlConfiguration();
            config.set("title", (Object)inventory.getType().name());
            config.set("size", (Object)inventory.getSize());
            config.set("creator", (Object)player.getName());
            config.set("created_at", (Object)System.currentTimeMillis());
            ConfigurationSection itemsSection = config.createSection("items");
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getType().isAir()) continue;
                itemsSection.set(String.valueOf(i), (Object)item);
            }
            config.save(guiFile);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u5df2\u4fdd\u5b58GUI: " + fileName + " (\u5927\u5c0f: " + inventory.getSize() + ", \u521b\u5efa\u8005: " + player.getName() + ")");
            }
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u4fdd\u5b58GUI\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public Inventory loadGui(String fileName, Server server) {
        try {
            File guiFile = new File(this.guiFolder, fileName + ".yml");
            if (!guiFile.exists()) {
                return null;
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)guiFile);
            int size = config.getInt("size", 27);
            String title = config.getString("title", fileName);
            Inventory inventory = server.createInventory(null, size, title);
            ConfigurationSection itemsSection = config.getConfigurationSection("items");
            if (itemsSection != null) {
                for (String key : itemsSection.getKeys(false)) {
                    int slot = Integer.parseInt(key);
                    ItemStack item = itemsSection.getItemStack(key);
                    if (item == null || slot >= size) continue;
                    inventory.setItem(slot, item);
                }
            }
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u5df2\u52a0\u8f7dGUI: " + fileName + " (\u5927\u5c0f: " + size + ")");
            }
            return inventory;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u52a0\u8f7dGUI\u5931\u8d25: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean guiExists(String fileName) {
        File guiFile = new File(this.guiFolder, fileName + ".yml");
        return guiFile.exists();
    }

    public String[] getAllGuiNames() {
        File[] files = this.guiFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            return new String[0];
        }
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName().replace(".yml", "");
        }
        return names;
    }

    public boolean deleteGui(String fileName) {
        File guiFile = new File(this.guiFolder, fileName + ".yml");
        if (guiFile.exists()) {
            return guiFile.delete();
        }
        return false;
    }
}

