/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.FoliaUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class ExtremeTableGUI
implements Listener {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;
    private final Map<String, Map<String, Integer>> recipes = new HashMap<String, Map<String, Integer>>();
    private final Map<UUID, String> playerCurrentRecipe = new HashMap<UUID, String>();
    private final Map<String, Long> craftCooldown = new HashMap<String, Long>();
    private static final long CRAFT_COOLDOWN_MS = 500L;
    private static final String MAIN_GUI_TITLE = "\u00a76\u00a7l\u7ec8\u6781\u5de5\u4f5c\u53f0";
    private static final String CRAFT_GUI_PREFIX = "\u00a76\u5408\u6210: ";

    public ExtremeTableGUI(Avaritia_Plugin plugin, LanguageManager languageManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loadRecipes();
    }

    private void loadRecipes() {
        File recipeFile = new File(this.plugin.getDataFolder(), "extreme_crafting_table.yml");
        if (!recipeFile.exists()) {
            this.plugin.saveResource("extreme_crafting_table.yml", false);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u5df2\u590d\u5236 extreme_crafting_table.yml \u5230\u63d2\u4ef6\u6587\u4ef6\u5939");
            }
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipeFile);
        for (String itemId : config.getKeys(false)) {
            ConfigurationSection section = config.getConfigurationSection(itemId);
            if (section == null) continue;
            HashMap<String, Integer> ingredients = new HashMap<String, Integer>();
            for (String materialKey : section.getKeys(false)) {
                ingredients.put(materialKey, section.getInt(materialKey));
            }
            this.recipes.put(itemId, ingredients);
            if (!this.plugin.getConfig().getBoolean("debug", true)) continue;
            this.plugin.getLogger().info("\u52a0\u8f7d\u7ec8\u6781\u5de5\u4f5c\u53f0\u914d\u65b9: " + itemId + " -> " + String.valueOf(ingredients));
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u7ec8\u6781\u5de5\u4f5c\u53f0\u914d\u65b9\u52a0\u8f7d\u5b8c\u6210\uff0c\u5171 " + this.recipes.size() + " \u4e2a\u914d\u65b9");
        }
    }

    public void openMainGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)MAIN_GUI_TITLE);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u6253\u5f00\u7ec8\u6781\u5de5\u4f5c\u53f0\u4e3bGUI\uff0c\u914d\u65b9\u6570\u91cf: " + this.recipes.size());
        }
        int slot = 0;
        for (String itemId : this.recipes.keySet()) {
            ItemStack item;
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u5c1d\u8bd5\u521b\u5efa\u7269\u54c1: " + itemId);
            }
            if ((item = this.createItemFromId(itemId, player)) == null || slot >= 54) continue;
            gui.setItem(slot++, item);
            if (!this.plugin.getConfig().getBoolean("debug", true)) continue;
            this.plugin.getLogger().info("\u6210\u529f\u6dfb\u52a0\u7269\u54c1\u5230\u69fd\u4f4d " + (slot - 1) + ": " + itemId);
        }
        if (slot == 0 && this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().warning("\u4e3bGUI\u6ca1\u6709\u6dfb\u52a0\u4efb\u4f55\u7269\u54c1\uff01");
        }
        player.openInventory(gui);
    }

    private void openCraftGUI(Player player, String itemId) {
        int i;
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("=== \u6253\u5f00\u5408\u6210GUI ===");
            this.plugin.getLogger().info("\u73a9\u5bb6: " + player.getName());
            this.plugin.getLogger().info("\u7269\u54c1ID: " + itemId);
            this.plugin.getLogger().info("GUI\u6807\u9898: \u00a76\u5408\u6210: " + this.getItemName(itemId, player));
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)(CRAFT_GUI_PREFIX + this.getItemName(itemId, player)));
        gui.setItem(0, this.createInfoCompass(player, itemId));
        ItemStack glassPane = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glassPane.getItemMeta();
        if (glassMeta != null) {
            glassMeta.setDisplayName(" ");
            glassPane.setItemMeta(glassMeta);
        }
        for (i = 1; i < 9; ++i) {
            gui.setItem(i, glassPane);
        }
        for (i = 45; i < 54; ++i) {
            if (i == 49) continue;
            gui.setItem(i, glassPane);
        }
        for (i = 9; i < 45; i += 9) {
            gui.setItem(i, glassPane);
            gui.setItem(i + 8, glassPane);
        }
        gui.setItem(49, this.createBarrier(player));
        player.openInventory(gui);
    }

    private ItemStack createInfoCompass(Player player, String itemId) {
        ItemStack compass = new ItemStack(Material.COMPASS);
        ItemMeta meta = compass.getItemMeta();
        if (meta != null) {
            String itemName = this.getItemName(itemId, player);
            String displayName = this.languageManager.getMessage(player, "extreme_table_gui.current_item", new Object[0]).replace("{0}", itemName);
            meta.setDisplayName(displayName);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("");
            lore.add(this.languageManager.getMessage(player, "extreme_table_gui.required_materials", new Object[0]));
            Map<String, Integer> ingredients = this.recipes.get(itemId);
            if (ingredients != null) {
                for (Map.Entry<String, Integer> entry : ingredients.entrySet()) {
                    String materialName = this.getMaterialName(entry.getKey(), player);
                    lore.add("\u00a7f  \u2022 " + materialName + " \u00a77x" + String.valueOf(entry.getValue()));
                }
            }
            lore.add("");
            lore.add(this.languageManager.getMessage(player, "extreme_table_gui.put_materials", new Object[0]));
            lore.add(this.languageManager.getMessage(player, "extreme_table_gui.click_to_craft", new Object[0]));
            meta.setLore(lore);
            compass.setItemMeta(meta);
        }
        return compass;
    }

    private ItemStack createBarrier(Player player) {
        ItemStack barrier = new ItemStack(Material.BARRIER);
        ItemMeta meta = barrier.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.languageManager.getMessage(player, "extreme_table_gui.materials_insufficient", new Object[0]));
            meta.setLore(Arrays.asList(this.languageManager.getMessage(player, "extreme_table_gui.put_required_materials", new Object[0])));
            barrier.setItemMeta(meta);
        }
        return barrier;
    }

    private ItemStack createEmeraldBlock(Player player) {
        ItemStack emerald = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta meta = emerald.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.languageManager.getMessage(player, "extreme_table_gui.click_craft", new Object[0]));
            meta.setLore(Arrays.asList(this.languageManager.getMessage(player, "extreme_table_gui.materials_satisfied", new Object[0]), this.languageManager.getMessage(player, "extreme_table_gui.click_to_craft", new Object[0])));
            emerald.setItemMeta(meta);
        }
        return emerald;
    }

    private boolean checkMaterials(Inventory inv, String itemId) {
        if (this.plugin.getConfig().getBoolean("extreme_crafting_table.debug", false)) {
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack item;
                if (this.isDecorativeSlot(i) || (item = inv.getItem(i)) == null || item.getType() == Material.AIR) continue;
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("[\u7ec8\u6781\u5de5\u4f5c\u53f0Debug] \u68c0\u6d4b\u5230\u7269\u54c1\uff0c\u5141\u8bb8\u5408\u6210: " + itemId);
                }
                return true;
            }
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[\u7ec8\u6781\u5de5\u4f5c\u53f0Debug] \u5de5\u4f5c\u533a\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5408\u6210");
            }
            return false;
        }
        Map<String, Integer> required = this.recipes.get(itemId);
        if (required == null) {
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().warning("\u914d\u65b9\u4e0d\u5b58\u5728: " + itemId);
            }
            return false;
        }
        HashMap<String, Integer> available = new HashMap<String, Integer>();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("=== \u5f00\u59cb\u626b\u63cfGUI\u7269\u54c1 ===");
            this.plugin.getLogger().info("GUI\u5927\u5c0f: " + inv.getSize());
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item;
            if (this.isDecorativeSlot(i)) {
                if (!this.plugin.getConfig().getBoolean("debug", true) || (item = inv.getItem(i)) == null || item.getType() == Material.AIR) continue;
                this.plugin.getLogger().info("\u69fd\u4f4d " + i + ": " + String.valueOf(item.getType()) + " (\u88c5\u9970\u683c\u5b50\uff0c\u5df2\u8df3\u8fc7)");
                continue;
            }
            item = inv.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u69fd\u4f4d " + i + ": " + String.valueOf(item.getType()) + " \u00d7 " + item.getAmount());
            }
            String materialId = this.getMaterialId(item);
            available.put(materialId, available.getOrDefault(materialId, 0) + item.getAmount());
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("=== GUI\u626b\u63cf\u5b8c\u6210 ===");
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u68c0\u67e5\u6750\u6599 - \u7269\u54c1ID: " + itemId);
            this.plugin.getLogger().info("\u9700\u8981\u7684\u6750\u6599: " + String.valueOf(required));
            this.plugin.getLogger().info("\u53ef\u7528\u7684\u6750\u6599: " + String.valueOf(available));
        }
        for (Map.Entry<String, Integer> entry : required.entrySet()) {
            String requiredMaterial = this.normalizeMaterialId(entry.getKey());
            int requiredAmount = entry.getValue();
            int availableAmount = available.getOrDefault(requiredMaterial, 0);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("  \u6750\u6599: " + requiredMaterial + " - \u9700\u8981: " + requiredAmount + ", \u53ef\u7528: " + availableAmount);
            }
            if (availableAmount >= requiredAmount) continue;
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().warning("  \u6750\u6599\u4e0d\u8db3: " + requiredMaterial);
            }
            return false;
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u6750\u6599\u68c0\u67e5\u901a\u8fc7\uff01");
        }
        return true;
    }

    private boolean isDecorativeSlot(int slot) {
        if (slot >= 0 && slot < 9) {
            return true;
        }
        if (slot >= 45 && slot < 54) {
            return true;
        }
        return slot % 9 == 0 || slot % 9 == 8;
    }

    private void craft(Player player, Inventory inv, String itemId) {
        ItemStack result;
        if (!this.checkMaterials(inv, itemId)) {
            player.sendMessage("\u00a7c\u6750\u6599\u4e0d\u8db3\uff01");
            return;
        }
        boolean debugMode = this.plugin.getConfig().getBoolean("extreme_crafting_table.debug", false);
        if (!debugMode) {
            Map<String, Integer> required = this.recipes.get(itemId);
            if (required == null) {
                return;
            }
            for (Map.Entry<String, Integer> entry : required.entrySet()) {
                String requiredMaterial = this.normalizeMaterialId(entry.getKey());
                int remaining = entry.getValue();
                for (int i = 0; i < inv.getSize() && remaining > 0; ++i) {
                    String itemMaterialId;
                    ItemStack item;
                    if (this.isDecorativeSlot(i) || (item = inv.getItem(i)) == null || item.getType() == Material.AIR || !(itemMaterialId = this.getMaterialId(item)).equals(requiredMaterial)) continue;
                    int toRemove = Math.min(item.getAmount(), remaining);
                    item.setAmount(item.getAmount() - toRemove);
                    remaining -= toRemove;
                    if (item.getAmount() > 0) continue;
                    inv.setItem(i, null);
                }
            }
        } else if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("[\u7ec8\u6781\u5de5\u4f5c\u53f0Debug] Debug\u6a21\u5f0f\uff0c\u4e0d\u6d88\u8017\u6750\u6599");
        }
        if ((result = this.createItemFromId(itemId, player)) != null) {
            player.getInventory().addItem(new ItemStack[]{result});
            String successMsg = this.languageManager.getMessage(player, "extreme_table_gui.craft_success", new Object[0]).replace("{0}", this.getItemName(itemId, player));
            player.sendMessage(successMsg);
        }
    }

    private ItemStack createItemFromId(String itemId, Player player) {
        YamlConfiguration config;
        ConfigurationSection section;
        File itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        if (!itemsFile.exists()) {
            this.plugin.saveResource("items.yml", false);
        }
        if ((section = (config = YamlConfiguration.loadConfiguration((File)itemsFile)).getConfigurationSection("items." + itemId)) != null) {
            return this.createItemFromSection(section, player);
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().warning("\u627e\u4e0d\u5230\u7269\u54c1\u5b9a\u4e49: " + itemId);
        }
        return null;
    }

    private ItemStack createItemFromSection(ConfigurationSection section, Player player) {
        ItemMeta meta;
        String materialName = section.getString("material", "STONE");
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().warning("\u65e0\u6548\u7684\u6750\u8d28: " + materialName);
            }
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material);
        String cmd = section.getString("custom_model_data");
        if (cmd != null) {
            item = CustomModelDataUtil.setCustomModelData(item, cmd);
        }
        if ((meta = item.getItemMeta()) != null) {
            List lore;
            String displayName = section.getString("display_name");
            if (displayName != null) {
                if (displayName.startsWith("items.")) {
                    displayName = this.languageManager.getMessage(player, displayName, new Object[0]);
                }
                meta.setDisplayName(displayName);
            }
            if (!(lore = section.getStringList("lore")).isEmpty()) {
                ArrayList<String> translatedLore = new ArrayList<String>();
                for (String line : lore) {
                    if (line.startsWith("items.")) {
                        translatedLore.add(this.languageManager.getMessage(player, line, new Object[0]));
                        continue;
                    }
                    translatedLore.add(line);
                }
                meta.setLore(translatedLore);
            }
            item.setItemMeta(meta);
        }
        String itemId = section.getName();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u521b\u5efa\u7269\u54c1: " + itemId + ", \u6750\u8d28: " + material.name());
        }
        return PDCUtil.addPluginData(item, itemId);
    }

    private String getItemName(String itemId, Player player) {
        String key = "items." + itemId + ".name";
        String name = this.languageManager.getMessage(player, key, new Object[0]);
        return name.equals(key) ? itemId : name;
    }

    private String getMaterialName(String materialId, Player player) {
        Material mat;
        String originalId = materialId;
        if (materialId.contains(":")) {
            materialId = materialId.substring(materialId.indexOf(":") + 1);
        }
        if ((mat = Material.getMaterial((String)materialId.toUpperCase())) != null) {
            String materialKey = "materials." + materialId.toUpperCase();
            String materialName = this.languageManager.getMessage(player, materialKey, new Object[0]);
            if (!materialName.equals(materialKey)) {
                return ChatColor.translateAlternateColorCodes((char)'&', (String)materialName);
            }
            return this.formatMaterialName(mat.name());
        }
        String itemKey = "items." + materialId + ".name";
        String itemName = this.languageManager.getMessage(player, itemKey, new Object[0]);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u67e5\u627e\u6750\u6599\u7ffb\u8bd1 - materialId: " + materialId);
            this.plugin.getLogger().info("  \u7ffb\u8bd1\u952e: " + itemKey);
            this.plugin.getLogger().info("  \u7ffb\u8bd1\u7ed3\u679c: " + itemName);
            this.plugin.getLogger().info("  \u662f\u5426\u627e\u5230: " + !itemName.equals(itemKey));
        }
        if (!itemName.equals(itemKey)) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)itemName);
        }
        return this.formatMaterialName(materialId);
    }

    private String formatMaterialName(String materialName) {
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return result.toString();
    }

    private String getMaterialId(ItemStack item) {
        String itemId = PDCUtil.getItemId(item);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u83b7\u53d6\u7269\u54c1\u6750\u6599ID:");
            this.plugin.getLogger().info("  \u7269\u54c1\u7c7b\u578b: " + String.valueOf(item.getType()));
            this.plugin.getLogger().info("  \u7269\u54c1\u663e\u793a\u540d: " + (item.hasItemMeta() && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : "\u65e0"));
            this.plugin.getLogger().info("  PDC\u4e2d\u7684ItemID: " + itemId);
        }
        if (itemId != null) {
            if (itemId.contains(":")) {
                String normalized = itemId.substring(itemId.indexOf(":") + 1);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("  \u89c4\u8303\u5316\u540e: " + normalized);
                }
                return normalized;
            }
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("  \u76f4\u63a5\u8fd4\u56de: " + itemId);
            }
            return itemId;
        }
        String materialName = item.getType().name();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("  \u539f\u7248\u7269\u54c1\uff0c\u8fd4\u56de: " + materialName);
        }
        return materialName;
    }

    private String normalizeMaterialId(String materialId) {
        if (materialId == null) {
            return null;
        }
        if (materialId.contains(":")) {
            return materialId.substring(materialId.indexOf(":") + 1);
        }
        return materialId;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("=== GUI\u70b9\u51fb\u4e8b\u4ef6 ===");
            this.plugin.getLogger().info("\u6807\u9898: " + title);
            this.plugin.getLogger().info("\u69fd\u4f4d: " + event.getRawSlot());
            this.plugin.getLogger().info("\u4e3bGUI\u6807\u9898: \u00a76\u00a7l\u7ec8\u6781\u5de5\u4f5c\u53f0");
            this.plugin.getLogger().info("\u5408\u6210GUI\u524d\u7f00: \u00a76\u5408\u6210: ");
            this.plugin.getLogger().info("\u662f\u5426\u5339\u914d\u4e3bGUI: " + title.equals(MAIN_GUI_TITLE));
            this.plugin.getLogger().info("\u662f\u5426\u5339\u914d\u5408\u6210GUI: " + title.startsWith(CRAFT_GUI_PREFIX));
        }
        if (title.equals(MAIN_GUI_TITLE)) {
            String itemId;
            ItemStack clicked;
            event.setCancelled(true);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u89e6\u53d1\u4e3bGUI\u4e8b\u4ef6\u5904\u7406");
            }
            if ((clicked = event.getCurrentItem()) != null && clicked.getType() != Material.AIR && (itemId = PDCUtil.getItemId(clicked)) != null && this.recipes.containsKey(itemId)) {
                this.openCraftGUI(player, itemId);
            }
            return;
        }
        if (title.startsWith(CRAFT_GUI_PREFIX)) {
            int slot;
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u89e6\u53d1\u5408\u6210GUI\u4e8b\u4ef6\u5904\u7406");
            }
            String foundItemId = null;
            for (Map.Entry<String, Map<String, Integer>> entry : this.recipes.entrySet()) {
                String recipeItemId = entry.getKey();
                String expectedTitle = CRAFT_GUI_PREFIX + this.getItemName(recipeItemId, player);
                if (!title.equals(expectedTitle)) continue;
                foundItemId = recipeItemId;
                break;
            }
            if (foundItemId == null) {
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().warning("\u65e0\u6cd5\u4eceGUI\u6807\u9898\u89e3\u6790\u7269\u54c1ID\uff01");
                    this.plugin.getLogger().warning("GUI\u6807\u9898: " + title);
                }
                return;
            }
            Iterator<Map.Entry<String, Map<String, Integer>>> itemId = foundItemId;
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u4ece\u6807\u9898\u89e3\u6790\u5230\u7269\u54c1ID: " + itemId);
            }
            if ((slot = event.getRawSlot()) < event.getInventory().getSize() && this.isDecorativeSlot(slot)) {
                ItemStack clicked;
                event.setCancelled(true);
                if (slot == 49 && (clicked = event.getCurrentItem()) != null && clicked.getType() == Material.EMERALD_BLOCK) {
                    String cooldownKey = player.getUniqueId().toString() + ":" + itemId;
                    long now = System.currentTimeMillis();
                    Long lastCraft = this.craftCooldown.get(cooldownKey);
                    if (lastCraft != null && now - lastCraft < 500L) {
                        if (this.plugin.getConfig().getBoolean("debug", true)) {
                            this.plugin.getLogger().info("[\u7ec8\u6781\u5de5\u4f5c\u53f0] \u5408\u6210\u51b7\u5374\u4e2d\uff0c\u5ffd\u7565\u70b9\u51fb");
                        }
                        return;
                    }
                    this.craftCooldown.put(cooldownKey, now);
                    event.getInventory().setItem(49, this.createBarrier(player));
                    this.craft(player, event.getInventory(), (String)((Object)itemId));
                    FoliaUtil.runSyncLater(this.plugin, () -> {
                        if (player.getOpenInventory().getTopInventory().equals((Object)event.getInventory())) {
                            if (this.checkMaterials(event.getInventory(), (String)((Object)itemId))) {
                                event.getInventory().setItem(49, this.createEmeraldBlock(player));
                            } else {
                                event.getInventory().setItem(49, this.createBarrier(player));
                            }
                        }
                    }, 3L);
                }
                return;
            }
            if (slot >= event.getInventory().getSize()) {
                if (event.isShiftClick()) {
                    FoliaUtil.runSyncLater(this.plugin, () -> {
                        if (player.getOpenInventory().getTopInventory().equals((Object)event.getInventory())) {
                            if (this.checkMaterials(event.getInventory(), (String)((Object)itemId))) {
                                event.getInventory().setItem(49, this.createEmeraldBlock(player));
                            } else {
                                event.getInventory().setItem(49, this.createBarrier(player));
                            }
                        }
                    }, 3L);
                }
                return;
            }
            FoliaUtil.runSyncLater(this.plugin, () -> {
                if (player.getOpenInventory().getTopInventory().equals((Object)event.getInventory())) {
                    if (this.checkMaterials(event.getInventory(), (String)((Object)itemId))) {
                        event.getInventory().setItem(49, this.createEmeraldBlock(player));
                    } else {
                        event.getInventory().setItem(49, this.createBarrier(player));
                    }
                }
            }, 3L);
        }
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("=== GUI\u62d6\u62fd\u4e8b\u4ef6 ===");
            this.plugin.getLogger().info("\u6807\u9898: " + title);
            this.plugin.getLogger().info("\u62d6\u62fd\u69fd\u4f4d: " + String.valueOf(event.getRawSlots()));
        }
        if (title.equals(MAIN_GUI_TITLE)) {
            event.setCancelled(true);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u4e3bGUI - \u53d6\u6d88\u62d6\u62fd\u4e8b\u4ef6");
            }
            return;
        }
        if (title.startsWith(CRAFT_GUI_PREFIX)) {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= event.getInventory().getSize() || !this.isDecorativeSlot(slot)) continue;
                event.setCancelled(true);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u5408\u6210GUI - \u5c1d\u8bd5\u62d6\u62fd\u5230\u88c5\u9970\u683c\u5b50\uff0c\u5df2\u53d6\u6d88");
                }
                return;
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = (Player)event.getPlayer();
            String title = event.getView().getTitle();
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("=== GUI\u5173\u95ed\u4e8b\u4ef6 ===");
                this.plugin.getLogger().info("\u73a9\u5bb6: " + player.getName());
                this.plugin.getLogger().info("\u6807\u9898: " + title);
            }
            this.playerCurrentRecipe.remove(player.getUniqueId());
        }
    }
}

