/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class CustomCraftingManager {
    private final JavaPlugin plugin;
    private final Map<String, CustomRecipe> customRecipes = new HashMap<String, CustomRecipe>();
    private final Map<String, ItemStack> itemCache = new HashMap<String, ItemStack>();
    private LanguageManager languageManager;

    public CustomCraftingManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void setLanguageManager(LanguageManager languageManager) {
        this.languageManager = languageManager;
        this.loadCustomRecipes();
    }

    private void loadCustomRecipes() {
        ConfigurationSection recipeSection;
        YamlConfiguration config;
        ConfigurationSection recipesSection;
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            this.plugin.saveResource("recipe.yml", false);
        }
        if ((recipesSection = (config = YamlConfiguration.loadConfiguration((File)recipeFile)).getConfigurationSection("recipes")) == null) {
            this.plugin.getLogger().warning("recipe.yml\u4e2d\u6ca1\u6709\u627e\u5230recipes\u90e8\u5206");
            return;
        }
        for (String key : recipesSection.getKeys(false)) {
            ItemStack resultItem;
            recipeSection = recipesSection.getConfigurationSection(key);
            if (recipeSection == null || (resultItem = this.createItemFromConfig(recipeSection.getConfigurationSection("result"), key)) == null) continue;
            this.itemCache.put(key, resultItem);
        }
        for (String key : recipesSection.getKeys(false)) {
            CustomRecipe customRecipe;
            recipeSection = recipesSection.getConfigurationSection(key);
            if (recipeSection == null || !this.needsCustomHandling(recipeSection) || (customRecipe = this.createCustomRecipe(key, recipeSection)) == null) continue;
            this.customRecipes.put(key, customRecipe);
            if (!this.plugin.getConfig().getBoolean("debug", true)) continue;
            this.plugin.getLogger().info("\u52a0\u8f7d\u81ea\u5b9a\u4e49\u5408\u6210\u8868: " + key);
        }
        this.plugin.getLogger().info("\u5df2\u52a0\u8f7d " + this.customRecipes.size() + " \u4e2a\u81ea\u5b9a\u4e49\u5408\u6210\u8868");
    }

    private ItemStack createItemFromConfig(ConfigurationSection resultSection, String recipeKey) {
        return this.createItemFromConfig(resultSection, recipeKey, "zh_cn");
    }

    private ItemStack createItemFromConfig(ConfigurationSection resultSection, String recipeKey, String language) {
        String configDisplayName;
        String itemId;
        ItemMeta meta;
        if (resultSection == null) {
            return null;
        }
        Material material = Material.getMaterial((String)resultSection.getString("material", ""));
        if (material == null) {
            return null;
        }
        int amount = resultSection.getInt("amount", 1);
        ItemStack item = new ItemStack(material, amount);
        String cmd = resultSection.getString("custom_model_data");
        if (cmd != null) {
            item = CustomModelDataUtil.setCustomModelData(item, cmd);
        }
        if ((meta = item.getItemMeta()) != null) {
            ConfigurationSection enchantSection;
            itemId = recipeKey;
            configDisplayName = resultSection.getString("display_name");
            if (configDisplayName != null && configDisplayName.startsWith("items.") && configDisplayName.endsWith(".name")) {
                itemId = configDisplayName.substring(6, configDisplayName.length() - 5);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] \u4ecedisplay_name\u63d0\u53d6\u7269\u54c1ID: " + itemId + " (\u914d\u65b9ID: " + recipeKey + ")");
                }
            }
            if (this.languageManager != null) {
                String loreLine;
                String langName = this.languageManager.getMessage(language, "items." + itemId + ".name", new Object[0]);
                if (!langName.startsWith("Missing translation:")) {
                    meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)langName));
                    if (this.plugin.getConfig().getBoolean("debug", true)) {
                        this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u540d\u79f0: " + langName);
                    }
                } else if (configDisplayName != null) {
                    meta.setDisplayName(configDisplayName);
                    if (this.plugin.getConfig().getBoolean("debug", true)) {
                        this.plugin.getLogger().warning("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u4f7f\u7528\u914d\u7f6e\u540d\u79f0(\u7ffb\u8bd1\u7f3a\u5931): " + configDisplayName);
                    }
                }
                ArrayList<String> langLore = new ArrayList<String>();
                int loreIndex = 0;
                while (!(loreLine = this.languageManager.getMessage(language, "items." + itemId + ".lore." + loreIndex, new Object[0])).startsWith("Missing translation:")) {
                    langLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)loreLine));
                    ++loreIndex;
                }
                if (!langLore.isEmpty()) {
                    meta.setLore(langLore);
                    if (this.plugin.getConfig().getBoolean("debug", true)) {
                        this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u4f7f\u7528\u7ffb\u8bd1lore, \u884c\u6570: " + langLore.size());
                    }
                } else {
                    List configLore = resultSection.getStringList("lore");
                    if (!configLore.isEmpty()) {
                        meta.setLore(configLore);
                        if (this.plugin.getConfig().getBoolean("debug", true)) {
                            this.plugin.getLogger().warning("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u4f7f\u7528\u914d\u7f6elore(\u7ffb\u8bd1\u7f3a\u5931): " + String.valueOf(configLore));
                        }
                    }
                }
            } else {
                List lore;
                if (resultSection.getString("display_name") != null) {
                    meta.setDisplayName(resultSection.getString("display_name"));
                }
                if (!(lore = resultSection.getStringList("lore")).isEmpty()) {
                    meta.setLore(lore);
                }
            }
            if (resultSection.getBoolean("unbreakable", false)) {
                meta.setUnbreakable(true);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u7834\u574f");
                }
            }
            if (resultSection.contains("max_durability")) {
                int maxDurability = resultSection.getInt("max_durability");
                if (meta instanceof Damageable && this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u6700\u5927\u8010\u4e45: " + maxDurability);
                }
            }
            if (resultSection.contains("enchantments") && (enchantSection = resultSection.getConfigurationSection("enchantments")) != null) {
                for (String enchantName : enchantSection.getKeys(false)) {
                    int level = enchantSection.getInt(enchantName);
                    try {
                        Enchantment enchant = Enchantment.getByName((String)enchantName);
                        if (enchant != null) {
                            meta.addEnchant(enchant, level, true);
                            if (!this.plugin.getConfig().getBoolean("debug", true)) continue;
                            this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u6dfb\u52a0\u9644\u9b54: " + enchantName + " " + level);
                            continue;
                        }
                        this.plugin.getLogger().warning("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u672a\u77e5\u9644\u9b54: " + enchantName);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u9644\u9b54\u9519\u8bef: " + enchantName + " - " + e.getMessage());
                    }
                }
            }
            if (resultSection.contains("attack_damage")) {
                double attackDamage = resultSection.getDouble("attack_damage");
                try {
                    NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "attack_damage");
                    AttributeModifier modifier = new AttributeModifier(key, attackDamage, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.HAND);
                    Attribute attackAttribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.attack_damage"));
                    if (attackAttribute != null) {
                        meta.addAttributeModifier(attackAttribute, modifier);
                        if (this.plugin.getConfig().getBoolean("debug", true)) {
                            this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u8bbe\u7f6e\u653b\u51fb\u529b: " + attackDamage);
                        }
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " \u653b\u51fb\u529b\u8bbe\u7f6e\u9519\u8bef: " + e.getMessage());
                }
            }
            item.setItemMeta(meta);
        }
        itemId = recipeKey;
        configDisplayName = resultSection.getString("display_name");
        if (configDisplayName != null && configDisplayName.startsWith("items.") && configDisplayName.endsWith(".name")) {
            itemId = configDisplayName.substring(6, configDisplayName.length() - 5);
        }
        item = PDCUtil.addPluginData(item, itemId);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("[\u7269\u54c1\u521b\u5efa] " + recipeKey + " PDC\u6807\u8bc6: " + itemId);
        }
        return item;
    }

    public boolean needsCustomHandling(ConfigurationSection recipeSection) {
        ConfigurationSection ingredientsSection = recipeSection.getConfigurationSection("ingredients");
        if (ingredientsSection == null) {
            return false;
        }
        for (String key : ingredientsSection.getKeys(false)) {
            Object value = ingredientsSection.get(key);
            if (value instanceof String) {
                String ingredient = (String)value;
                if (!ingredient.startsWith("avaritia:") && !this.itemCache.containsKey(ingredient)) continue;
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u5408\u6210\u8868\u9700\u8981\u81ea\u5b9a\u4e49\u5904\u7406\uff0c\u56e0\u4e3a\u6750\u6599\u5305\u542b: " + ingredient);
                }
                return true;
            }
            if (!(value instanceof Integer) || !key.startsWith("avaritia:") && !this.itemCache.containsKey(key)) continue;
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u65e0\u5e8f\u5408\u6210\u8868\u9700\u8981\u81ea\u5b9a\u4e49\u5904\u7406\uff0c\u56e0\u4e3a\u6750\u6599\u5305\u542b: " + key);
            }
            return true;
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u8be5\u5408\u6210\u8868\u4f7f\u7528\u7eaf\u539f\u7248\u6750\u6599\uff0c\u7531Bukkit\u5904\u7406");
        }
        return false;
    }

    private CustomRecipe createCustomRecipe(String key, ConfigurationSection recipeSection) {
        ItemStack result = this.itemCache.get(key);
        if (result == null) {
            return null;
        }
        String type = recipeSection.getString("type", "shaped");
        boolean isShapeless = "shapeless".equals(type);
        List shape = null;
        HashMap<Character, String> ingredients = new HashMap<Character, String>();
        if (!isShapeless && (shape = recipeSection.getStringList("shape")).isEmpty()) {
            return null;
        }
        ConfigurationSection ingredientsSection = recipeSection.getConfigurationSection("ingredients");
        if (ingredientsSection != null) {
            for (String ingredientKey : ingredientsSection.getKeys(false)) {
                Object value = ingredientsSection.get(ingredientKey);
                if (value instanceof String) {
                    String ingredient = (String)value;
                    if (ingredient.startsWith("avaritia:")) {
                        ingredient = ingredient.substring("avaritia:".length());
                    }
                    ingredients.put(Character.valueOf(ingredientKey.charAt(0)), ingredient);
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                String cleanKey = ingredientKey;
                if (cleanKey.startsWith("avaritia:")) {
                    cleanKey = cleanKey.substring("avaritia:".length());
                }
                ingredients.put(Character.valueOf(ingredientKey.charAt(0)), cleanKey + ":" + String.valueOf(value));
            }
        }
        return new CustomRecipe(key, result.clone(), shape, ingredients, isShapeless);
    }

    public ItemStack findMatchingRecipe(ItemStack[] matrix) {
        return this.findMatchingRecipe(matrix, "zh_cn");
    }

    public ItemStack findMatchingRecipe(ItemStack[] matrix, String language) {
        for (Map.Entry<String, CustomRecipe> entry : this.customRecipes.entrySet()) {
            CustomRecipe recipe = entry.getValue();
            if (!(recipe.isShapeless ? this.matchesShapelessRecipe(matrix, recipe) : this.matchesShapedRecipe(matrix, recipe))) continue;
            return this.createLocalizedResult(entry.getKey(), language);
        }
        return null;
    }

    private ItemStack createLocalizedResult(String recipeKey, String language) {
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            return this.itemCache.get(recipeKey);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipeFile);
        ConfigurationSection recipesSection = config.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return this.itemCache.get(recipeKey);
        }
        ConfigurationSection recipeSection = recipesSection.getConfigurationSection(recipeKey);
        if (recipeSection == null) {
            return this.itemCache.get(recipeKey);
        }
        return this.createItemFromConfig(recipeSection.getConfigurationSection("result"), recipeKey, language);
    }

    private boolean matchesShapedRecipe(ItemStack[] matrix, CustomRecipe recipe) {
        if (recipe.shape == null) {
            return false;
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u5f00\u59cb\u9a8c\u8bc1\u6709\u5e8f\u5408\u6210: " + recipe.id);
        }
        CharSequence[] currentPattern = new String[3];
        boolean hasUnknownItem = false;
        for (int row = 0; row < 3; ++row) {
            StringBuilder sb = new StringBuilder();
            for (int col = 0; col < 3; ++col) {
                ItemStack item = matrix[row * 3 + col];
                char symbol = this.getSymbolForItem(item, recipe);
                if (symbol == '?') {
                    hasUnknownItem = true;
                    if (this.plugin.getConfig().getBoolean("debug", true)) {
                        String itemDesc = item != null ? this.getItemIdentifier(item) : "null";
                        this.plugin.getLogger().info("\u4f4d\u7f6e [" + row + "," + col + "] \u6709\u672a\u77e5\u7269\u54c1: " + itemDesc);
                    }
                }
                sb.append(symbol);
            }
            currentPattern[row] = sb.toString();
        }
        if (hasUnknownItem) {
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u5408\u6210\u5931\u8d25\uff1a\u5305\u542b\u4e0d\u5339\u914d\u7684\u6750\u6599");
            }
            return false;
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u5f53\u524d\u6a21\u5f0f: " + String.join((CharSequence)"|", currentPattern));
            this.plugin.getLogger().info("\u76ee\u6807\u6a21\u5f0f: " + String.join((CharSequence)"|", recipe.shape));
        }
        boolean matches = this.matchesPattern((String[])currentPattern, recipe.shape);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u6a21\u5f0f\u5339\u914d\u7ed3\u679c: " + matches);
        }
        return matches;
    }

    private boolean matchesShapelessRecipe(ItemStack[] matrix, CustomRecipe recipe) {
        HashMap<String, Integer> required = new HashMap<String, Integer>();
        HashMap<String, Integer> provided = new HashMap<String, Integer>();
        for (Map.Entry<Character, String> entry : recipe.ingredients.entrySet()) {
            String ingredient = entry.getValue();
            int lastColonIndex = ingredient.lastIndexOf(58);
            if (lastColonIndex > 0 && lastColonIndex < ingredient.length() - 1) {
                try {
                    String materialId = ingredient.substring(0, lastColonIndex);
                    int count = Integer.parseInt(ingredient.substring(lastColonIndex + 1));
                    required.put(materialId, required.getOrDefault(materialId, 0) + count);
                    continue;
                }
                catch (NumberFormatException materialId) {
                    // empty catch block
                }
            }
            required.put(ingredient, required.getOrDefault(ingredient, 0) + 1);
        }
        for (ItemStack item : matrix) {
            String itemId;
            if (item == null || item.getType().isAir() || (itemId = this.getItemIdentifier(item)) == null) continue;
            provided.put(itemId, provided.getOrDefault(itemId, 0) + item.getAmount());
        }
        return required.equals(provided);
    }

    private char getSymbolForItem(ItemStack item, CustomRecipe recipe) {
        if (item == null || item.getType().isAir()) {
            return ' ';
        }
        String itemId = this.getItemIdentifier(item);
        for (Map.Entry<Character, String> entry : recipe.ingredients.entrySet()) {
            String requiredId = entry.getValue();
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u9a8c\u8bc1\u7269\u54c1: " + itemId + " vs \u9700\u8981: " + requiredId);
            }
            if (!requiredId.equals(itemId)) continue;
            return entry.getKey().charValue();
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u7269\u54c1 " + itemId + " \u4e0d\u5339\u914d\u4efb\u4f55\u5408\u6210\u6750\u6599");
        }
        return '?';
    }

    private String getItemIdentifier(ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return null;
        }
        if (PDCUtil.isPluginItem(item)) {
            return PDCUtil.getItemId(item);
        }
        return item.getType().name();
    }

    private boolean matchesPattern(String[] current, List<String> target) {
        String[] trimmedTarget;
        String[] trimmedCurrent = this.trimPattern(current);
        if (trimmedCurrent.length != (trimmedTarget = this.trimPattern(target.toArray(new String[0]))).length) {
            return false;
        }
        for (int i = 0; i < trimmedCurrent.length; ++i) {
            if (trimmedCurrent[i].equals(trimmedTarget[i])) continue;
            return false;
        }
        return true;
    }

    private String[] trimPattern(String[] pattern) {
        if (pattern == null || pattern.length == 0) {
            return new String[0];
        }
        int firstRow = -1;
        int lastRow = -1;
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i].replace(" ", "").isEmpty()) continue;
            if (firstRow == -1) {
                firstRow = i;
            }
            lastRow = i;
        }
        if (firstRow == -1) {
            return new String[]{" "};
        }
        int firstCol = Integer.MAX_VALUE;
        int lastCol = -1;
        for (int row = firstRow; row <= lastRow; ++row) {
            for (int col = 0; col < pattern[row].length(); ++col) {
                if (pattern[row].charAt(col) == ' ') continue;
                firstCol = Math.min(firstCol, col);
                lastCol = Math.max(lastCol, col);
            }
        }
        if (lastCol == -1) {
            return new String[]{" "};
        }
        String[] trimmed = new String[lastRow - firstRow + 1];
        for (int i = 0; i < trimmed.length; ++i) {
            String row = pattern[firstRow + i];
            if (lastCol + 1 <= row.length()) {
                trimmed[i] = row.substring(firstCol, lastCol + 1);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int col = firstCol; col <= lastCol; ++col) {
                sb.append(col < row.length() ? row.charAt(col) : (char)' ');
            }
            trimmed[i] = sb.toString();
        }
        return trimmed;
    }

    public boolean validateRecipe(ItemStack[] matrix, ItemStack result) {
        String resultId = PDCUtil.getItemId(result);
        if (resultId == null) {
            return false;
        }
        CustomRecipe recipe = this.customRecipes.get(resultId);
        if (recipe == null) {
            return false;
        }
        return recipe.isShapeless ? this.matchesShapelessRecipe(matrix, recipe) : this.matchesShapedRecipe(matrix, recipe);
    }

    public void consumeIngredients(ItemStack[] matrix, ItemStack result) {
        String resultId = PDCUtil.getItemId(result);
        if (resultId == null) {
            return;
        }
        CustomRecipe recipe = this.customRecipes.get(resultId);
        if (recipe == null) {
            return;
        }
        for (int i = 0; i < matrix.length; ++i) {
            if (matrix[i] == null || matrix[i].getType().isAir()) continue;
            matrix[i].setAmount(matrix[i].getAmount() - 1);
            if (matrix[i].getAmount() > 0) continue;
            matrix[i] = null;
        }
    }

    public void reload() {
        this.customRecipes.clear();
        this.itemCache.clear();
        this.loadCustomRecipes();
    }

    private void reloadItems() {
        if (this.languageManager == null) {
            return;
        }
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipeFile);
        ConfigurationSection recipesSection = config.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return;
        }
        this.itemCache.clear();
        for (String key : recipesSection.getKeys(false)) {
            ItemStack resultItem;
            ConfigurationSection recipeSection = recipesSection.getConfigurationSection(key);
            if (recipeSection == null || (resultItem = this.createItemFromConfig(recipeSection.getConfigurationSection("result"), key, "zh_cn")) == null) continue;
            this.itemCache.put(key, resultItem);
        }
    }

    public ItemStack getLocalizedItem(String itemId, String language) {
        if (this.languageManager == null || itemId == null) {
            return this.itemCache.get(itemId);
        }
        File recipeFile = new File(this.plugin.getDataFolder(), "recipe.yml");
        if (!recipeFile.exists()) {
            return this.itemCache.get(itemId);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)recipeFile);
        ConfigurationSection recipesSection = config.getConfigurationSection("recipes");
        if (recipesSection == null) {
            return this.itemCache.get(itemId);
        }
        ConfigurationSection recipeSection = recipesSection.getConfigurationSection(itemId);
        if (recipeSection == null) {
            return this.itemCache.get(itemId);
        }
        return this.createItemFromConfig(recipeSection.getConfigurationSection("result"), itemId, language);
    }

    public ItemStack createLocalizedItem(ItemStack item, String language) {
        if (item == null || !PDCUtil.isPluginItem(item)) {
            return null;
        }
        String itemId = PDCUtil.getItemId(item);
        if (itemId == null) {
            return null;
        }
        if (itemId.contains(":")) {
            itemId = itemId.substring(itemId.indexOf(":") + 1);
        }
        return this.getLocalizedItem(itemId, language);
    }

    private static class CustomRecipe {
        public final String id;
        public final ItemStack result;
        public final List<String> shape;
        public final Map<Character, String> ingredients;
        public final boolean isShapeless;

        public CustomRecipe(String id, ItemStack result, List<String> shape, Map<Character, String> ingredients, boolean isShapeless) {
            this.id = id;
            this.result = result;
            this.shape = shape;
            this.ingredients = ingredients;
            this.isShapeless = isShapeless;
        }
    }
}

