/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.listener;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class FoodListener
implements Listener {
    private final Avaritia_Plugin plugin;

    public FoodListener(Avaritia_Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (!PDCUtil.isPluginItem(item)) {
            return;
        }
        String itemId = PDCUtil.getItemId(item);
        if (itemId == null) {
            return;
        }
        switch (itemId) {
            case "cosmic_meatballs": {
                this.handleCosmicMeatballs(player);
                break;
            }
            case "ultimate_stew": {
                this.handleUltimateStew(player);
                break;
            }
        }
    }

    private void handleCosmicMeatballs(Player player) {
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        PotionEffect strength = new PotionEffect(PotionEffectType.STRENGTH, 6000, 1, false, true, true);
        player.addPotionEffect(strength);
        player.sendMessage("\u00a75\u00a7l\u2726 \u00a7d\u4f60\u611f\u53d7\u5230\u4e86\u5b87\u5b99\u7684\u529b\u91cf\uff01");
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u98df\u7528\u4e86\u5bf0\u5b87\u8089\u4e38");
        }
    }

    private void handleUltimateStew(Player player) {
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        player.setExhaustion(0.0f);
        PotionEffect regeneration = new PotionEffect(PotionEffectType.REGENERATION, 6000, 1, false, true, true);
        player.addPotionEffect(regeneration);
        player.sendMessage("\u00a76\u00a7l\u2726 \u00a7e\u4f60\u611f\u53d7\u5230\u4e86\u751f\u547d\u7684\u590d\u82cf\uff01");
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u98df\u7528\u4e86\u8d85\u7ea7\u7172");
        }
    }
}

