/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.listener;

import java.util.Collection;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.util.FoliaUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class EndestPearlListener
implements Listener {
    private final Avaritia_Plugin plugin;
    private final Random random = new Random();

    public EndestPearlListener(Avaritia_Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerUseEndestPearl(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        String itemId = PDCUtil.getItemId(item);
        if (!"endest_pearl".equals(itemId)) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        Snowball pearl = (Snowball)player.launchProjectile(Snowball.class);
        pearl.setVelocity(player.getLocation().getDirection().multiply(1.5));
        ItemStack displayItem = item.clone();
        displayItem.setAmount(1);
        pearl.setItem(displayItem);
        ItemStack pearlItem = pearl.getItem();
        PDCUtil.addPluginData(pearlItem, "endest_pearl");
        pearl.setItem(pearlItem);
        if (player.getGameMode() != GameMode.CREATIVE) {
            item.setAmount(item.getAmount() - 1);
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u6295\u63b7\u4e86\u7ec8\u671b\u73cd\u73e0");
        }
    }

    @EventHandler
    public void onEndestPearlHit(ProjectileHitEvent event) {
        if (!(event.getEntity() instanceof Snowball)) {
            return;
        }
        Snowball pearl = (Snowball)event.getEntity();
        ItemStack pearlItem = pearl.getItem();
        String itemId = PDCUtil.getItemId(pearlItem);
        if (!"endest_pearl".equals(itemId)) {
            return;
        }
        Location location = pearl.getLocation();
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u7ec8\u671b\u73cd\u73e0\u5728 " + String.valueOf(location) + " \u843d\u5730\uff0c\u5f00\u59cb\u9ed1\u6d1e\u6548\u679c");
        }
        this.createBlackHole(location);
    }

    private void createBlackHole(Location center) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        int duration = 100;
        double pullRadius = 20.0;
        double damageRadius = 3.0;
        AtomicInteger tick = new AtomicInteger(0);
        FoliaUtil.runTimer(this.plugin, center, task -> {
            int currentTick = tick.getAndIncrement();
            if (currentTick >= 100) {
                world.createExplosion(center, 8.0f, false, true);
                world.spawnParticle(Particle.EXPLOSION_EMITTER, center, 1);
                world.playSound(center, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.5f);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u9ed1\u6d1e\u5728 " + String.valueOf(center) + " \u7206\u70b8");
                }
                task.cancel();
                return;
            }
            this.spawnBlackHoleParticles(center);
            if (currentTick % 20 == 0 && this.random.nextInt(3) == 0) {
                world.playSound(center, Sound.ENTITY_ENDERMAN_SCREAM, 1.5f, 0.7f);
            }
            Collection nearbyEntities = world.getNearbyEntities(center, 20.0, 20.0, 20.0);
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof LivingEntity) && !(entity instanceof Item) && !(entity instanceof Snowball)) continue;
                Location entityLoc = entity.getLocation();
                double distance = entityLoc.distance(center);
                if (distance > 0.5) {
                    Vector direction = center.toVector().subtract(entityLoc.toVector()).normalize();
                    double pullStrength = Math.min(1.0, (20.0 - distance) / 20.0) * 0.8;
                    entity.setVelocity(direction.multiply(pullStrength));
                }
                if (!(entity instanceof LivingEntity) || !(distance < 3.0)) continue;
                LivingEntity living = (LivingEntity)entity;
                living.damage(2.0);
                living.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + "\u4f60\u88ab\u9ed1\u6d1e\u541e\u566c\uff01");
                world.spawnParticle(Particle.PORTAL, entityLoc, 20, 0.5, 0.5, 0.5, 0.1);
            }
        }, 1L, 1L);
    }

    private void spawnBlackHoleParticles(Location center) {
        World world = center.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.LARGE_SMOKE, center, 10, 0.3, 0.3, 0.3, 0.02);
        world.spawnParticle(Particle.SQUID_INK, center, 5, 0.2, 0.2, 0.2, 0.01);
        for (int i = 0; i < 3; ++i) {
            double angle = ((double)System.currentTimeMillis() / 100.0 + (double)(i * 120)) % 360.0;
            double radius = 2.0 + Math.sin((double)System.currentTimeMillis() / 500.0) * 0.5;
            double x = center.getX() + radius * Math.cos(Math.toRadians(angle));
            double z = center.getZ() + radius * Math.sin(Math.toRadians(angle));
            double y = center.getY() + Math.sin(Math.toRadians(angle * 2.0)) * 0.5;
            Location particleLoc = new Location(world, x, y, z);
            world.spawnParticle(Particle.PORTAL, particleLoc, 2, 0.0, 0.0, 0.0, 0.1);
            world.spawnParticle(Particle.WITCH, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
        world.spawnParticle(Particle.DRAGON_BREATH, center, 15, 2.5, 2.5, 2.5, 0.05);
        if (this.random.nextInt(10) == 0) {
            world.playSound(center, Sound.BLOCK_PORTAL_AMBIENT, 1.0f, 0.5f);
        }
    }
}

