/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.listener;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.database.BlockDatabase;
import org.little100.avaritia_Plugin.util.PDCUtil;

public class BlockListener
implements Listener {
    private final Avaritia_Plugin plugin;
    private final BlockDatabase database;
    private static final double Y_OFFSET = -0.39;
    private final NamespacedKey BLOCK_TYPE_KEY;
    private final NamespacedKey ITEM_ID_KEY;

    public BlockListener(Avaritia_Plugin plugin, BlockDatabase database) {
        this.plugin = plugin;
        this.database = database;
        this.BLOCK_TYPE_KEY = new NamespacedKey((Plugin)plugin, "block_type");
        this.ITEM_ID_KEY = new NamespacedKey((Plugin)plugin, "item_id");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        boolean isPlaceableBlock;
        boolean isSpecialBlock;
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        if (!PDCUtil.isPluginItem(item)) {
            return;
        }
        String itemId = PDCUtil.getItemId(item);
        if (itemId == null) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("[\u65b9\u5757\u653e\u7f6e] \u68c0\u6d4b\u5230\u63d2\u4ef6\u7269\u54c1: " + itemId);
        }
        boolean allowPlaceBlock = this.plugin.getConfig().getBoolean("allow_place_block", false);
        boolean bl = isSpecialBlock = itemId.equals("compressed_crafting_table") || itemId.equals("double_compressed_crafting_table") || itemId.equals("crystal_matrix");
        if (isSpecialBlock && !allowPlaceBlock) {
            event.setCancelled(true);
            this.plugin.getLanguageManager().sendMessage(player, "block.place_disabled", new Object[0]);
            if (player.hasPermission("avaritia.admin")) {
                this.plugin.getLanguageManager().sendMessage(player, "block.place_disabled_hint", new Object[0]);
            }
            return;
        }
        boolean bl2 = isPlaceableBlock = itemId.equals("extreme_crafting_table") || itemId.equals("neutron_collector") || itemId.equals("neutronium_compressor") || isSpecialBlock && allowPlaceBlock;
        if (!isPlaceableBlock) {
            event.setCancelled(true);
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("[\u65b9\u5757\u653e\u7f6e] \u5df2\u62e6\u622a\u7269\u54c1\u653e\u7f6e: " + itemId + " (\u6b64\u7269\u54c1\u4e0d\u662f\u65b9\u5757)");
            }
            return;
        }
        if (isPlaceableBlock) {
            Block block = event.getBlockPlaced();
            Location blockLoc = block.getLocation();
            block.setType(Material.PRISMARINE_STAIRS, false);
            if (block.getBlockData() instanceof Stairs) {
                Stairs stairsData = (Stairs)block.getBlockData();
                stairsData.setHalf(Bisected.Half.TOP);
                stairsData.setFacing(player.getFacing().getOppositeFace());
                block.setBlockData((BlockData)stairsData, true);
            }
            Location armorStandLoc = blockLoc.clone().add(0.5, -0.39, 0.5);
            ArmorStand armorStand = (ArmorStand)blockLoc.getWorld().spawnEntity(armorStandLoc, EntityType.ARMOR_STAND);
            armorStand.setVisible(false);
            armorStand.setGravity(false);
            armorStand.setInvulnerable(true);
            armorStand.setBasePlate(false);
            armorStand.setArms(false);
            armorStand.setSmall(true);
            armorStand.setMarker(true);
            ItemStack displayItem = item.clone();
            displayItem.setAmount(1);
            armorStand.getEquipment().setHelmet(displayItem);
            PersistentDataContainer pdc = armorStand.getPersistentDataContainer();
            pdc.set(this.BLOCK_TYPE_KEY, PersistentDataType.STRING, (Object)itemId);
            pdc.set(this.ITEM_ID_KEY, PersistentDataType.STRING, (Object)itemId);
            this.plugin.getLogger().info("\u4fdd\u5b58\u5230\u76d4\u7532\u67b6PDC: BLOCK_TYPE_KEY='" + itemId + "', ITEM_ID_KEY='" + itemId + "'");
            this.database.saveBlock(blockLoc, itemId, armorStand.getUniqueId(), itemId);
            if (itemId.equals("neutron_collector")) {
                this.plugin.getNeutronCollectorGUI().registerCollector(blockLoc);
            }
            if (itemId.equals("neutronium_compressor")) {
                this.plugin.getNeutroniumCompressorGUI().registerCompressor(blockLoc);
            }
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u653e\u7f6e\u4e86 " + itemId + " \u5728 " + String.valueOf(blockLoc));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location blockLoc = block.getLocation();
        if (!this.database.hasBlock(blockLoc)) {
            return;
        }
        UUID armorStandUUID = this.database.getArmorStandUUID(blockLoc);
        if (armorStandUUID == null) {
            return;
        }
        event.setCancelled(true);
        Entity armorStandEntity = Bukkit.getEntity((UUID)armorStandUUID);
        String itemId = null;
        if (armorStandEntity instanceof ArmorStand) {
            ItemStack helmet;
            ArmorStand stand = (ArmorStand)armorStandEntity;
            PersistentDataContainer pdc = stand.getPersistentDataContainer();
            if (pdc.has(this.ITEM_ID_KEY, PersistentDataType.STRING)) {
                itemId = (String)pdc.get(this.ITEM_ID_KEY, PersistentDataType.STRING);
            }
            if ((helmet = stand.getEquipment().getHelmet()) != null && helmet.getType() != Material.AIR) {
                ItemStack dropItem = helmet.clone();
                dropItem.setAmount(1);
                block.getWorld().dropItemNaturally(blockLoc, dropItem);
            }
            stand.remove();
        }
        block.setType(Material.AIR);
        if (itemId != null && itemId.equals("neutron_collector")) {
            this.plugin.getNeutronCollectorGUI().unregisterCollector(blockLoc);
        }
        if (itemId != null && itemId.equals("neutronium_compressor")) {
            if (this.plugin.getConfig().getBoolean("compressor_protect", false)) {
                List<ItemStack> drops = this.plugin.getNeutroniumCompressorGUI().getCompressorDrops(blockLoc);
                for (ItemStack drop : drops) {
                    block.getWorld().dropItemNaturally(blockLoc, drop);
                }
            }
            this.plugin.getNeutroniumCompressorGUI().unregisterCompressor(blockLoc);
        }
        this.database.removeBlock(blockLoc);
        if (this.plugin.getConfig().getBoolean("debug", true)) {
            this.plugin.getLogger().info("\u73a9\u5bb6 " + event.getPlayer().getName() + " \u7834\u574f\u4e86 " + (itemId != null ? itemId : "\u7279\u6b8a\u65b9\u5757"));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onArmorStandInteract(PlayerInteractAtEntityEvent event) {
        ArmorStand stand;
        PersistentDataContainer pdc;
        if (event.getRightClicked() instanceof ArmorStand && (pdc = (stand = (ArmorStand)event.getRightClicked()).getPersistentDataContainer()).has(this.BLOCK_TYPE_KEY, PersistentDataType.STRING)) {
            event.setCancelled(true);
            String blockType = (String)pdc.get(this.BLOCK_TYPE_KEY, PersistentDataType.STRING);
            Player player = event.getPlayer();
            this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u53f3\u952e\u76d4\u7532\u67b6\uff0cblockType: '" + blockType + "'");
            if ("extreme_crafting_table".equals(blockType)) {
                this.plugin.getExtremeTableGUI().openMainGUI(player);
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u6253\u5f00\u4e86\u7ec8\u6781\u5de5\u4f5c\u53f0GUI");
                }
            } else if ("neutron_collector".equals(blockType)) {
                this.plugin.getNeutronCollectorGUI().openCollectorGUI(player, stand.getLocation().getBlock().getLocation());
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u6253\u5f00\u4e86\u4e2d\u5b50\u6001\u7d20\u6536\u96c6\u5668GUI");
                }
            } else if ("neutronium_compressor".equals(blockType)) {
                this.plugin.getNeutroniumCompressorGUI().openCompressorGUI(player, stand.getLocation().getBlock().getLocation());
                if (this.plugin.getConfig().getBoolean("debug", true)) {
                    this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u6253\u5f00\u4e86\u4e2d\u5b50\u6001\u7d20\u538b\u7f29\u673aGUI");
                }
            } else {
                player.sendMessage("\u00a7c\u6b64\u65b9\u5757\u6682\u65e0\u529f\u80fd");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onArmorStandDamage(EntityDamageEvent event) {
        ArmorStand stand;
        PersistentDataContainer pdc;
        if (event.getEntity() instanceof ArmorStand && (pdc = (stand = (ArmorStand)event.getEntity()).getPersistentDataContainer()).has(this.BLOCK_TYPE_KEY, PersistentDataType.STRING)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getBlockData() instanceof Stairs)) {
            return;
        }
        Location blockLoc = block.getLocation();
        Collection nearbyEntities = block.getWorld().getNearbyEntities(blockLoc.clone().add(0.5, 0.0, 0.5), 0.5, 0.5, 0.5, entity -> entity.getType() == EntityType.ARMOR_STAND);
        for (Entity entity2 : nearbyEntities) {
            ArmorStand stand;
            PersistentDataContainer pdc;
            if (!(entity2 instanceof ArmorStand) || !(pdc = (stand = (ArmorStand)entity2).getPersistentDataContainer()).has(this.BLOCK_TYPE_KEY, PersistentDataType.STRING)) continue;
            String blockType = (String)pdc.get(this.BLOCK_TYPE_KEY, PersistentDataType.STRING);
            if ("extreme_crafting_table".equals(blockType)) {
                event.setCancelled(true);
                Player player = event.getPlayer();
                this.plugin.getExtremeTableGUI().openMainGUI(player);
                if (!this.plugin.getConfig().getBoolean("debug", true)) break;
                this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u6253\u5f00\u4e86\u7ec8\u6781\u5de5\u4f5c\u53f0GUI");
                break;
            }
            if ("neutron_collector".equals(blockType)) {
                event.setCancelled(true);
                Player player = event.getPlayer();
                this.plugin.getNeutronCollectorGUI().openCollectorGUI(player, blockLoc);
                if (!this.plugin.getConfig().getBoolean("debug", true)) break;
                this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u6253\u5f00\u4e86\u4e2d\u5b50\u6001\u7d20\u6536\u96c6\u5668GUI");
                break;
            }
            if ("neutronium_compressor".equals(blockType)) {
                event.setCancelled(true);
                Player player = event.getPlayer();
                this.plugin.getNeutroniumCompressorGUI().openCompressorGUI(player, blockLoc);
                if (!this.plugin.getConfig().getBoolean("debug", true)) break;
                this.plugin.getLogger().info("\u73a9\u5bb6 " + player.getName() + " \u6253\u5f00\u4e86\u4e2d\u5b50\u6001\u7d20\u538b\u7f29\u673aGUI");
                break;
            }
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7c\u6b64\u65b9\u5757\u6682\u65e0\u529f\u80fd");
            break;
        }
    }
}

