/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.command;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.manager.ItemManager;
import org.little100.avaritia_Plugin.manager.LanguageManager;

public class LanguageCommand
implements CommandExecutor,
TabCompleter {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;
    private final ItemManager itemManager;

    public LanguageCommand(Avaritia_Plugin plugin, LanguageManager languageManager, ItemManager itemManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        this.itemManager = itemManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7c\u6b64\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u6267\u884c\uff01");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            String currentLang = this.languageManager.getPlayerLanguage(player);
            String currentDisplay = this.languageManager.getLanguageDisplayName(currentLang);
            this.languageManager.sendMessage(player, "language.current", currentDisplay);
            this.languageManager.sendMessage(player, "language.supported_languages", new Object[0]);
            for (String lang : this.languageManager.getSupportedLanguages()) {
                String displayName = this.languageManager.getLanguageDisplayName(lang);
                String current = lang.equals(currentLang) ? " \u00a7a(\u5f53\u524d)" : "";
                player.sendMessage("  \u00a77- \u00a7e" + lang + " \u00a78(" + displayName + ")" + current);
            }
            this.languageManager.sendMessage(player, "language.usage", new Object[0]);
            return true;
        }
        if (args.length == 1) {
            String targetLanguage = args[0].toLowerCase();
            if (this.languageManager.isLanguageSupported(targetLanguage)) {
                if (this.languageManager.setPlayerLanguage(player, targetLanguage)) {
                    this.itemManager.updatePlayerItems(player);
                    String displayName = this.languageManager.getLanguageDisplayName(targetLanguage);
                    this.languageManager.sendMessage(player, "language.changed", displayName);
                } else {
                    this.languageManager.sendMessage(player, "language.change_failed", new Object[0]);
                }
            } else {
                this.languageManager.sendMessage(player, "language.unsupported", targetLanguage);
                this.languageManager.sendMessage(player, "language.usage", new Object[0]);
            }
            return true;
        }
        this.languageManager.sendMessage(player, "language.usage", new Object[0]);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            for (String lang : this.languageManager.getSupportedLanguages()) {
                if (!lang.toLowerCase().startsWith(input)) continue;
                completions.add(lang);
            }
        }
        return completions;
    }
}

