/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.little100.avaritia_Plugin.Avaritia_Plugin;
import org.little100.avaritia_Plugin.NBTDebugCommand;
import org.little100.avaritia_Plugin.command.GUICommand;
import org.little100.avaritia_Plugin.command.GiveCommand;
import org.little100.avaritia_Plugin.command.LanguageCommand;
import org.little100.avaritia_Plugin.manager.GUIManager;
import org.little100.avaritia_Plugin.manager.ItemManager;
import org.little100.avaritia_Plugin.manager.LanguageManager;

public class AvaritiaCommand
implements CommandExecutor,
TabCompleter {
    private final Avaritia_Plugin plugin;
    private final LanguageManager languageManager;
    private final GUIManager guiManager;
    private final NBTDebugCommand nbtDebugCommand;
    private final LanguageCommand languageCommand;
    private final GUICommand guiCommand;
    private final GiveCommand giveCommand;

    public AvaritiaCommand(Avaritia_Plugin plugin, LanguageManager languageManager, GUIManager guiManager, ItemManager itemManager) {
        this.plugin = plugin;
        this.languageManager = languageManager;
        this.guiManager = guiManager;
        this.nbtDebugCommand = new NBTDebugCommand(plugin, languageManager);
        this.languageCommand = new LanguageCommand(plugin, languageManager, itemManager);
        this.guiCommand = new GUICommand(plugin, languageManager, guiManager);
        this.giveCommand = new GiveCommand(plugin, languageManager);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "nbtdebug": 
            case "nbt": 
            case "debug": {
                return this.nbtDebugCommand.onCommand(sender, command, "nbtdebug", subArgs);
            }
            case "language": 
            case "lang": 
            case "lng": {
                return this.languageCommand.onCommand(sender, command, "language", subArgs);
            }
            case "gui": 
            case "menu": 
            case "inv": {
                return this.guiCommand.onCommand(sender, command, "gui", subArgs);
            }
            case "give": 
            case "item": {
                return this.giveCommand.execute(sender, subArgs);
            }
            case "help": 
            case "?": {
                this.sendHelp(sender);
                return true;
            }
            case "version": 
            case "ver": {
                this.sendVersion(sender);
                return true;
            }
            case "reload": {
                return this.handleReload(sender);
            }
        }
        sender.sendMessage("\u00a7c\u672a\u77e5\u7684\u5b50\u547d\u4ee4: " + subCommand);
        sender.sendMessage("\u00a77\u4f7f\u7528 \u00a7e/avaritia help \u00a77\u67e5\u770b\u53ef\u7528\u547d\u4ee4");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            List<String> subCommands = Arrays.asList("nbtdebug", "language", "gui", "give", "help", "version", "reload");
            for (String subCmd : subCommands) {
                if (!subCmd.startsWith(input)) continue;
                completions.add(subCmd);
            }
            if ("nbt".startsWith(input)) {
                completions.add("nbt");
            }
            if ("debug".startsWith(input)) {
                completions.add("debug");
            }
            if ("lang".startsWith(input)) {
                completions.add("lang");
            }
            if ("lng".startsWith(input)) {
                completions.add("lng");
            }
            if ("menu".startsWith(input)) {
                completions.add("menu");
            }
            if ("inv".startsWith(input)) {
                completions.add("inv");
            }
            if ("item".startsWith(input)) {
                completions.add("item");
            }
            if ("ver".startsWith(input)) {
                completions.add("ver");
            }
        } else if (args.length >= 2) {
            String subCommand = args[0].toLowerCase();
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            switch (subCommand) {
                case "nbtdebug": 
                case "nbt": 
                case "debug": {
                    return new ArrayList<String>();
                }
                case "language": 
                case "lang": 
                case "lng": {
                    return this.languageCommand.onTabComplete(sender, command, "language", subArgs);
                }
                case "gui": 
                case "menu": 
                case "inv": {
                    return this.guiCommand.onTabComplete(sender, command, "gui", subArgs);
                }
                case "give": 
                case "item": {
                    return this.giveCommand.onTabComplete(sender, subArgs);
                }
            }
        }
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.languageManager.sendMessage(player, "command.help.header", new Object[0]);
            this.languageManager.sendMessage(player, "command.help.nbtdebug", new Object[0]);
            this.languageManager.sendMessage(player, "command.help.language", new Object[0]);
            this.languageManager.sendMessage(player, "command.help.gui", new Object[0]);
            this.languageManager.sendMessage(player, "command.help.version", new Object[0]);
            this.languageManager.sendMessage(player, "command.help.reload", new Object[0]);
            this.languageManager.sendMessage(player, "command.help.footer", new Object[0]);
        } else {
            sender.sendMessage("\u00a76=== Avaritia Plugin Commands ===");
            sender.sendMessage("\u00a7e/avaritia nbtdebug \u00a77- Show item NBT debug info");
            sender.sendMessage("\u00a7e/avaritia language <lang> \u00a77- Switch display language");
            sender.sendMessage("\u00a7e/avaritia gui <edit|look|new> <size> \u00a77- Open GUI editor");
            sender.sendMessage("\u00a7e/avaritia give <player> <item> [amount] \u00a77- Give plugin items");
            sender.sendMessage("\u00a7e/avaritia version \u00a77- Show plugin version");
            sender.sendMessage("\u00a7e/avaritia reload \u00a77- Reload plugin config");
            sender.sendMessage("\u00a77Use aliases: \u00a7enbt, lang, menu, item");
        }
    }

    private void sendVersion(CommandSender sender) {
        sender.sendMessage("\u00a76\u65e0\u5c3d\u8d2a\u5a6a\u63d2\u4ef6 \u00a77v" + this.plugin.getDescription().getVersion());
        sender.sendMessage("\u00a77\u4f5c\u8005: \u00a7f" + String.join((CharSequence)", ", this.plugin.getDescription().getAuthors()));
        sender.sendMessage("\u00a77\u670d\u52a1\u5668\u7c7b\u578b: \u00a7f" + (this.plugin.isFolia() ? "Folia" : "Paper/Spigot"));
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("avaritia.admin.reload")) {
            if (sender instanceof Player) {
                this.languageManager.sendMessage((Player)sender, "general.no_permission", new Object[0]);
            } else {
                sender.sendMessage("\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u547d\u4ee4!");
            }
            return true;
        }
        try {
            this.plugin.reloadConfig();
            this.languageManager.reload();
            if (sender instanceof Player) {
                this.languageManager.sendMessage((Player)sender, "command.reload.success", new Object[0]);
            } else {
                sender.sendMessage("\u00a7a\u63d2\u4ef6\u914d\u7f6e\u91cd\u8f7d\u6210\u529f!");
            }
            if (this.plugin.getConfig().getBoolean("debug", true)) {
                this.plugin.getLogger().info("\u914d\u7f6e\u6587\u4ef6\u5df2\u88ab " + sender.getName() + " \u91cd\u8f7d");
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7c\u91cd\u8f7d\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage());
            this.plugin.getLogger().warning("\u914d\u7f6e\u91cd\u8f7d\u5931\u8d25: " + e.getMessage());
        }
        return true;
    }
}

