/*
 * Decompiled with CFR 0.152.
 */
package org.little100.avaritia_Plugin;

import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.little100.avaritia_Plugin.command.AvaritiaCommand;
import org.little100.avaritia_Plugin.database.BlockDatabase;
import org.little100.avaritia_Plugin.listener.BlockListener;
import org.little100.avaritia_Plugin.listener.CraftingListener;
import org.little100.avaritia_Plugin.listener.EndestPearlListener;
import org.little100.avaritia_Plugin.listener.FoodListener;
import org.little100.avaritia_Plugin.listener.InfinityArmorListener;
import org.little100.avaritia_Plugin.listener.InfinityToolsListener;
import org.little100.avaritia_Plugin.manager.CustomCraftingManager;
import org.little100.avaritia_Plugin.manager.ExtremeTableGUI;
import org.little100.avaritia_Plugin.manager.GUIConfigManager;
import org.little100.avaritia_Plugin.manager.GUIManager;
import org.little100.avaritia_Plugin.manager.ItemManager;
import org.little100.avaritia_Plugin.manager.LanguageManager;
import org.little100.avaritia_Plugin.manager.NeutronCollectorGUI;
import org.little100.avaritia_Plugin.manager.NeutroniumCompressorGUI;
import org.little100.avaritia_Plugin.recipe.RecipeManager;
import org.little100.avaritia_Plugin.util.CustomModelDataUtil;
import org.little100.avaritia_Plugin.util.FoliaUtil;
import org.little100.avaritia_Plugin.util.PDCUtil;

public final class Avaritia_Plugin
extends JavaPlugin {
    private boolean isPaper;
    private boolean isFolia;
    private LanguageManager languageManager;
    private RecipeManager recipeManager;
    private GUIManager guiManager;
    private CustomCraftingManager customCraftingManager;
    private ItemManager itemManager;
    private BlockDatabase blockDatabase;
    private ExtremeTableGUI extremeTableGUI;
    private NeutronCollectorGUI neutronCollectorGUI;
    private NeutroniumCompressorGUI neutroniumCompressorGUI;

    public void onEnable() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            this.isFolia = true;
            this.isPaper = true;
        }
        catch (ClassNotFoundException e) {
            this.isFolia = false;
            try {
                Class.forName("io.papermc.paper.configuration.Configuration");
                this.isPaper = true;
            }
            catch (ClassNotFoundException ex) {
                this.isPaper = false;
            }
        }
        this.saveDefaultConfig();
        this.saveResourceIfNotExists("items.yml");
        this.saveResourceIfNotExists("recipe.yml");
        this.saveResourceIfNotExists("extreme_crafting_table.yml");
        this.saveResourceIfNotExists("neutron_collector.yml");
        this.saveResourceIfNotExists("neutronium_compressor.yml");
        this.saveResourceIfNotExists("lang/zh_cn.yml");
        this.saveResourceIfNotExists("lang/en_us.yml");
        this.saveResourceIfNotExists("lang/lzh.yml");
        this.saveResourceIfNotExists("pack/Avaritia Resourcepack.zip");
        boolean debugMode = this.getConfig().getBoolean("debug", true);
        if (debugMode) {
            this.getLogger().info("\u68c0\u6d4b\u5230\u670d\u52a1\u5668\u7c7b\u578b: " + FoliaUtil.getServerType());
        }
        CustomModelDataUtil.initialize(this.getLogger(), this.getConfig());
        PDCUtil.initialize(this);
        this.blockDatabase = new BlockDatabase(this);
        this.blockDatabase.initialize();
        this.languageManager = new LanguageManager(this);
        this.itemManager = new ItemManager(this, this.languageManager);
        GUIConfigManager guiConfigManager = new GUIConfigManager(this);
        this.guiManager = new GUIManager(this, this.languageManager, guiConfigManager);
        this.extremeTableGUI = new ExtremeTableGUI(this, this.languageManager);
        this.neutronCollectorGUI = new NeutronCollectorGUI(this, this.languageManager);
        this.neutroniumCompressorGUI = new NeutroniumCompressorGUI(this, this.languageManager);
        this.customCraftingManager = new CustomCraftingManager(this);
        this.customCraftingManager.setLanguageManager(this.languageManager);
        this.recipeManager = new RecipeManager(this, this.languageManager);
        this.recipeManager.setCustomCraftingManager(this.customCraftingManager);
        this.recipeManager.loadRecipes();
        AvaritiaCommand mainCommand = new AvaritiaCommand(this, this.languageManager, this.guiManager, this.itemManager);
        this.getCommand("avaritia").setExecutor((CommandExecutor)mainCommand);
        this.getCommand("avaritia").setTabCompleter((TabCompleter)mainCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftingListener(this, this.customCraftingManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this, this.blockDatabase), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FoodListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EndestPearlListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InfinityToolsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InfinityArmorListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.extremeTableGUI, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.neutronCollectorGUI, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.neutroniumCompressorGUI, (Plugin)this);
        this.getLogger().info("\u65e0\u5c3d\u8d2a\u5a6a\u63d2\u4ef6\u5df2\u542f\u7528\uff01");
    }

    public void onDisable() {
        if (this.languageManager != null) {
            this.languageManager.savePlayerLanguages();
        }
        if (this.blockDatabase != null) {
            this.blockDatabase.close();
        }
        this.getLogger().info("\u65e0\u5c3d\u8d2a\u5a6a\u63d2\u4ef6\u5df2\u7981\u7528\uff01");
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    public boolean isFolia() {
        return this.isFolia;
    }

    public GUIManager getGUIManager() {
        return this.guiManager;
    }

    public CustomCraftingManager getCustomCraftingManager() {
        return this.customCraftingManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public ExtremeTableGUI getExtremeTableGUI() {
        return this.extremeTableGUI;
    }

    public NeutronCollectorGUI getNeutronCollectorGUI() {
        return this.neutronCollectorGUI;
    }

    public NeutroniumCompressorGUI getNeutroniumCompressorGUI() {
        return this.neutroniumCompressorGUI;
    }

    private void saveResourceIfNotExists(String resourcePath) {
        File file = new File(this.getDataFolder(), resourcePath);
        if (!file.exists()) {
            this.saveResource(resourcePath, false);
            this.getLogger().info("\u5df2\u4fdd\u5b58\u8d44\u6e90\u6587\u4ef6: " + resourcePath);
        }
    }
}

