/*
 * Decompiled with CFR 0.152.
 */
package org.little100.antiSeedMine.listener;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.little100.antiSeedMine.AntiSeedMine;
import org.little100.antiSeedMine.config.BlockManager;
import org.little100.antiSeedMine.config.ConfigManager;

public class OreOffsetListener
implements Listener {
    private final AntiSeedMine plugin;
    private final ConfigManager configManager;
    private final BlockManager blockManager;
    private final Map<String, Long> worldCreationTimeCache = new HashMap<String, Long>();
    private static final int[][] DIRECTIONS = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}};

    public OreOffsetListener(AntiSeedMine plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.blockManager = plugin.getBlockManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChunkPopulate(ChunkPopulateEvent event) {
        Chunk chunk = event.getChunk();
        World world = chunk.getWorld();
        if (!this.configManager.isWorldEnabled(world.getName())) {
            return;
        }
        long timestamp = this.getTimestamp(world);
        this.processChunk(chunk, timestamp);
    }

    private long getTimestamp(World world) {
        switch (this.configManager.getTimestampSource()) {
            case WORLD_CREATION: {
                return this.getWorldCreationTime(world);
            }
            case SERVER_START: {
                return this.plugin.getServerStartTime();
            }
            case CUSTOM: {
                long custom = this.configManager.getCustomTimestamp();
                return custom == 0L ? System.currentTimeMillis() : custom;
            }
        }
        return this.getWorldCreationTime(world);
    }

    private long getWorldCreationTime(World world) {
        File levelDat;
        String worldName = world.getName();
        if (this.worldCreationTimeCache.containsKey(worldName)) {
            return this.worldCreationTimeCache.get(worldName);
        }
        File worldFolder = world.getWorldFolder();
        long creationTime = worldFolder != null && worldFolder.exists() ? ((levelDat = new File(worldFolder, "level.dat")).exists() ? levelDat.lastModified() : worldFolder.lastModified()) : world.getSeed() ^ (long)worldName.hashCode() * 31L;
        this.worldCreationTimeCache.put(worldName, creationTime);
        if (this.configManager.isDebug()) {
            this.plugin.getLogger().info("\u4e16\u754c " + worldName + " \u7684\u65f6\u95f4\u6233: " + creationTime);
        }
        return creationTime;
    }

    private void processChunk(Chunk chunk, long timestamp) {
        World world = chunk.getWorld();
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        int minY = this.getWorldMinHeight(world);
        int maxY = world.getMaxHeight();
        HashMap<WorldPos, Material> oreMap = new HashMap<WorldPos, Material>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    Block block = chunk.getBlock(x, y, z);
                    Material material = block.getType();
                    if (!this.blockManager.isOre(material)) continue;
                    int worldX = chunkX * 16 + x;
                    int worldZ = chunkZ * 16 + z;
                    oreMap.put(new WorldPos(worldX, y, worldZ), material);
                }
            }
        }
        if (oreMap.isEmpty()) {
            return;
        }
        List<OreCluster> clusters = this.detectOreClusters(oreMap);
        long seed = timestamp;
        seed = seed * 31L + (long)chunkX;
        seed = seed * 31L + (long)chunkZ;
        Random random = new Random(seed);
        int offsetXMin = this.configManager.getOffsetXMin();
        int offsetXMax = this.configManager.getOffsetXMax();
        int offsetZMin = this.configManager.getOffsetZMin();
        int offsetZMax = this.configManager.getOffsetZMax();
        int offsetYMin = this.configManager.getOffsetYMin();
        int offsetYMax = this.configManager.getOffsetYMax();
        for (OreCluster cluster : clusters) {
            int offsetX = this.calculateOffset(random, offsetXMin, offsetXMax);
            int offsetZ = this.calculateOffset(random, offsetZMin, offsetZMax);
            int offsetY = this.calculateOffset(random, offsetYMin, offsetYMax);
            ArrayList<MoveOperation> operations = new ArrayList<MoveOperation>();
            boolean canMove = true;
            for (WorldPos pos : cluster.blocks) {
                int newX = pos.x + offsetX;
                int newY = pos.y + offsetY;
                int newZ = pos.z + offsetZ;
                WorldPos newPos = new WorldPos(newX, newY = Math.max(minY, Math.min(maxY - 1, newY)), newZ);
                if (cluster.blocks.contains(newPos)) {
                    operations.add(new MoveOperation(pos, newPos, (Material)oreMap.get(pos)));
                    continue;
                }
                int targetChunkX = newX >> 4;
                int targetChunkZ = newZ >> 4;
                if (!world.isChunkLoaded(targetChunkX, targetChunkZ) && !world.loadChunk(targetChunkX, targetChunkZ, false)) {
                    canMove = false;
                    break;
                }
                Block newBlock = world.getBlockAt(newX, newY, newZ);
                if (!this.isReplaceableBlock(newBlock.getType())) {
                    canMove = false;
                    break;
                }
                operations.add(new MoveOperation(pos, newPos, (Material)oreMap.get(pos)));
            }
            if (!canMove || operations.isEmpty()) continue;
            for (MoveOperation op : operations) {
                Block originalBlock = world.getBlockAt(op.from.x, op.from.y, op.from.z);
                Material replacement = this.getReplacementMaterial(op.material, op.from.y, minY);
                originalBlock.setType(replacement, false);
            }
            for (MoveOperation op : operations) {
                Block newBlock = world.getBlockAt(op.to.x, op.to.y, op.to.z);
                newBlock.setType(op.material, false);
            }
        }
    }

    private List<OreCluster> detectOreClusters(Map<WorldPos, Material> oreMap) {
        ArrayList<OreCluster> clusters = new ArrayList<OreCluster>();
        HashSet<WorldPos> visited = new HashSet<WorldPos>();
        for (Map.Entry<WorldPos, Material> entry : oreMap.entrySet()) {
            WorldPos startPos = entry.getKey();
            if (visited.contains(startPos)) continue;
            Material material = entry.getValue();
            OreCluster cluster = new OreCluster(material);
            LinkedList<WorldPos> queue = new LinkedList<WorldPos>();
            queue.add(startPos);
            visited.add(startPos);
            while (!queue.isEmpty()) {
                WorldPos current = (WorldPos)queue.poll();
                cluster.blocks.add(current);
                for (int[] dir : DIRECTIONS) {
                    Material neighborMaterial;
                    int nx = current.x + dir[0];
                    int ny = current.y + dir[1];
                    int nz = current.z + dir[2];
                    WorldPos neighbor = new WorldPos(nx, ny, nz);
                    if (visited.contains(neighbor) || !oreMap.containsKey(neighbor) || !this.isSameOreType(material, neighborMaterial = oreMap.get(neighbor))) continue;
                    visited.add(neighbor);
                    queue.add(neighbor);
                }
            }
            clusters.add(cluster);
        }
        return clusters;
    }

    private boolean isSameOreType(Material mat1, Material mat2) {
        if (mat1 == mat2) {
            return true;
        }
        String name1 = mat1.name();
        String name2 = mat2.name();
        String base1 = name1.replace("DEEPSLATE_", "");
        String base2 = name2.replace("DEEPSLATE_", "");
        return base1.equals(base2);
    }

    private int getWorldMinHeight(World world) {
        try {
            return world.getMinHeight();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private int calculateOffset(Random random, int min, int max) {
        int offset = min + random.nextInt(max - min + 1);
        if (random.nextBoolean()) {
            offset = -offset;
        }
        return offset;
    }

    private Material getReplacementMaterial(Material oreMaterial, int y, int minY) {
        String materialName = oreMaterial.name();
        if (materialName.startsWith("DEEPSLATE_")) {
            try {
                return Material.valueOf((String)"DEEPSLATE");
            }
            catch (IllegalArgumentException e) {
                return Material.STONE;
            }
        }
        if (materialName.startsWith("NETHER_") || materialName.equals("ANCIENT_DEBRIS")) {
            return Material.NETHERRACK;
        }
        if (minY < 0 && y < 0) {
            try {
                return Material.valueOf((String)"DEEPSLATE");
            }
            catch (IllegalArgumentException e) {
                return Material.STONE;
            }
        }
        return Material.STONE;
    }

    private boolean isReplaceableBlock(Material material) {
        switch (material) {
            case STONE: 
            case GRANITE: 
            case DIORITE: 
            case ANDESITE: 
            case NETHERRACK: {
                return true;
            }
        }
        String name = material.name();
        return name.equals("DEEPSLATE") || name.equals("TUFF") || name.equals("CALCITE");
    }

    private static class WorldPos {
        final int x;
        final int y;
        final int z;

        WorldPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorldPos pos = (WorldPos)o;
            return this.x == pos.x && this.y == pos.y && this.z == pos.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }

    private static class OreCluster {
        final Material material;
        final Set<WorldPos> blocks = new HashSet<WorldPos>();

        OreCluster(Material material) {
            this.material = material;
        }
    }

    private static class MoveOperation {
        final WorldPos from;
        final WorldPos to;
        final Material material;

        MoveOperation(WorldPos from, WorldPos to, Material material) {
            this.from = from;
            this.to = to;
            this.material = material;
        }
    }
}

