/*
 * Decompiled with CFR 0.152.
 */
package org.little100.antiSeedMine.config;

import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private TimestampSource timestampSource;
    private long customTimestamp;
    private int offsetXMin;
    private int offsetXMax;
    private int offsetZMin;
    private int offsetZMax;
    private int offsetYMin;
    private int offsetYMax;
    private boolean enableAllWorlds;
    private List<String> enabledWorlds;
    private boolean debug;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        String sourceStr = config.getString("timestamp.source", "WORLD_CREATION");
        try {
            this.timestampSource = TimestampSource.valueOf(sourceStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("\u65e0\u6548\u7684\u65f6\u95f4\u6233\u6765\u6e90: " + sourceStr + ", \u4f7f\u7528\u9ed8\u8ba4\u503c WORLD_CREATION");
            this.timestampSource = TimestampSource.WORLD_CREATION;
        }
        this.customTimestamp = config.getLong("timestamp.custom-value", 0L);
        this.offsetXMin = config.getInt("offset.x.min", 5);
        this.offsetXMax = config.getInt("offset.x.max", 10);
        this.offsetZMin = config.getInt("offset.z.min", 5);
        this.offsetZMax = config.getInt("offset.z.max", 10);
        this.offsetYMin = config.getInt("offset.y.min", 1);
        this.offsetYMax = config.getInt("offset.y.max", 2);
        this.enableAllWorlds = config.getBoolean("worlds.enable-all", true);
        this.enabledWorlds = config.getStringList("worlds.enabled-worlds");
        this.debug = config.getBoolean("debug", false);
        if (this.debug) {
            this.plugin.getLogger().info("\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210:");
            this.plugin.getLogger().info("  \u65f6\u95f4\u6233\u6765\u6e90: " + String.valueOf((Object)this.timestampSource));
            this.plugin.getLogger().info("  X\u504f\u79fb\u8303\u56f4: " + this.offsetXMin + " ~ " + this.offsetXMax);
            this.plugin.getLogger().info("  Z\u504f\u79fb\u8303\u56f4: " + this.offsetZMin + " ~ " + this.offsetZMax);
            this.plugin.getLogger().info("  Y\u504f\u79fb\u8303\u56f4: " + this.offsetYMin + " ~ " + this.offsetYMax);
        }
    }

    public void reloadConfig() {
        this.loadConfig();
    }

    public TimestampSource getTimestampSource() {
        return this.timestampSource;
    }

    public long getCustomTimestamp() {
        return this.customTimestamp;
    }

    public int getOffsetXMin() {
        return this.offsetXMin;
    }

    public int getOffsetXMax() {
        return this.offsetXMax;
    }

    public int getOffsetZMin() {
        return this.offsetZMin;
    }

    public int getOffsetZMax() {
        return this.offsetZMax;
    }

    public int getOffsetYMin() {
        return this.offsetYMin;
    }

    public int getOffsetYMax() {
        return this.offsetYMax;
    }

    public boolean isEnableAllWorlds() {
        return this.enableAllWorlds;
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isWorldEnabled(String worldName) {
        if (this.enableAllWorlds) {
            return true;
        }
        return this.enabledWorlds.contains(worldName);
    }

    public static enum TimestampSource {
        WORLD_CREATION,
        SERVER_START,
        CUSTOM;

    }
}

