/*
 * Decompiled with CFR 0.152.
 */
package org.little100.antiSeedMine.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class BlockManager {
    private final JavaPlugin plugin;
    private final Set<Material> oreBlocks;
    private File blockFile;
    private FileConfiguration blockConfig;

    public BlockManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.oreBlocks = new HashSet<Material>();
    }

    public void loadBlocks() {
        this.saveDefaultBlockConfig();
        this.reloadBlockConfig();
        List oreList = this.blockConfig.getStringList("ores");
        this.oreBlocks.clear();
        int loaded = 0;
        int skipped = 0;
        for (String oreName : oreList) {
            try {
                Material material = Material.valueOf((String)oreName.toUpperCase());
                this.oreBlocks.add(material);
                ++loaded;
            }
            catch (IllegalArgumentException e) {
                ++skipped;
                if (!this.plugin.getConfig().getBoolean("debug", false)) continue;
                this.plugin.getLogger().info("\u8df3\u8fc7\u4e0d\u652f\u6301\u7684\u77ff\u7269: " + oreName + " (\u5f53\u524d\u7248\u672c\u53ef\u80fd\u4e0d\u5b58\u5728)");
            }
        }
        this.plugin.getLogger().info("\u5df2\u52a0\u8f7d " + loaded + " \u79cd\u77ff\u7269, \u8df3\u8fc7 " + skipped + " \u79cd\u4e0d\u652f\u6301\u7684\u77ff\u7269");
    }

    private void saveDefaultBlockConfig() {
        this.blockFile = new File(this.plugin.getDataFolder(), "block.yml");
        if (!this.blockFile.exists()) {
            this.plugin.saveResource("block.yml", false);
        }
    }

    public void reloadBlockConfig() {
        if (this.blockFile == null) {
            this.blockFile = new File(this.plugin.getDataFolder(), "block.yml");
        }
        this.blockConfig = YamlConfiguration.loadConfiguration((File)this.blockFile);
        InputStream defaultStream = this.plugin.getResource("block.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
            this.blockConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getBlockConfig() {
        if (this.blockConfig == null) {
            this.reloadBlockConfig();
        }
        return this.blockConfig;
    }

    public void saveBlockConfig() {
        if (this.blockConfig == null || this.blockFile == null) {
            return;
        }
        try {
            this.getBlockConfig().save(this.blockFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u65e0\u6cd5\u4fdd\u5b58\u77ff\u7269\u914d\u7f6e\u6587\u4ef6: " + e.getMessage());
        }
    }

    public boolean isOre(Material material) {
        return this.oreBlocks.contains(material);
    }

    public Set<Material> getOreBlocks() {
        return new HashSet<Material>(this.oreBlocks);
    }

    public int getOreCount() {
        return this.oreBlocks.size();
    }
}

