/*
 * Decompiled with CFR 0.152.
 */
package org.little100.antiSeedMine.command;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.little100.antiSeedMine.AntiSeedMine;

public class AntiSeedMineCommand
implements CommandExecutor,
TabCompleter {
    private final AntiSeedMine plugin;

    public AntiSeedMineCommand(AntiSeedMine plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "info": {
                return this.handleInfo(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("antiseedmine.reload")) {
            sender.sendMessage("\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u547d\u4ee4!");
            return true;
        }
        this.plugin.reload();
        sender.sendMessage("\u00a7a[AntiSeedMine] \u914d\u7f6e\u5df2\u91cd\u65b0\u52a0\u8f7d!");
        return true;
    }

    private boolean handleInfo(CommandSender sender) {
        if (!sender.hasPermission("antiseedmine.info")) {
            sender.sendMessage("\u00a7c\u4f60\u6ca1\u6709\u6743\u9650\u6267\u884c\u6b64\u547d\u4ee4!");
            return true;
        }
        sender.sendMessage("\u00a76========== AntiSeedMine \u4fe1\u606f ==========");
        sender.sendMessage("\u00a7e\u7248\u672c: \u00a7f" + this.plugin.getDescription().getVersion());
        sender.sendMessage("\u00a7e\u5df2\u52a0\u8f7d\u77ff\u7269\u6570\u91cf: \u00a7f" + this.plugin.getBlockManager().getOreCount());
        sender.sendMessage("\u00a7e\u65f6\u95f4\u6233\u6765\u6e90: \u00a7f" + String.valueOf((Object)this.plugin.getConfigManager().getTimestampSource()));
        sender.sendMessage("\u00a7eX\u504f\u79fb\u8303\u56f4: \u00a7f" + this.plugin.getConfigManager().getOffsetXMin() + " ~ " + this.plugin.getConfigManager().getOffsetXMax());
        sender.sendMessage("\u00a7eZ\u504f\u79fb\u8303\u56f4: \u00a7f" + this.plugin.getConfigManager().getOffsetZMin() + " ~ " + this.plugin.getConfigManager().getOffsetZMax());
        sender.sendMessage("\u00a7eY\u504f\u79fb\u8303\u56f4: \u00a7f" + this.plugin.getConfigManager().getOffsetYMin() + " ~ " + this.plugin.getConfigManager().getOffsetYMax());
        sender.sendMessage("\u00a7e\u8c03\u8bd5\u6a21\u5f0f: \u00a7f" + (this.plugin.getConfigManager().isDebug() ? "\u5f00\u542f" : "\u5173\u95ed"));
        sender.sendMessage("\u00a76=========================================");
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76========== AntiSeedMine \u5e2e\u52a9 ==========");
        sender.sendMessage("\u00a7e/asm reload \u00a77- \u91cd\u65b0\u52a0\u8f7d\u914d\u7f6e");
        sender.sendMessage("\u00a7e/asm info \u00a77- \u67e5\u770b\u63d2\u4ef6\u4fe1\u606f");
        sender.sendMessage("\u00a7e/asm help \u00a77- \u663e\u793a\u6b64\u5e2e\u52a9");
        sender.sendMessage("\u00a76=========================================");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("antiseedmine.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("antiseedmine.info")) {
                completions.add("info");
            }
            completions.add("help");
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

