/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.world;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Parser;
import net.lewmc.essence.external.command.FoundryCommand;
import net.lewmc.essence.teleportation.spawn.CommandSpawn;
import net.lewmc.essence.world.UtilWorld;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandWorld
extends FoundryCommand {
    private final Essence plugin;
    private UtilPermission perms;
    private UtilMessage msg;

    public CommandWorld(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.world";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        this.msg = new UtilMessage(this.plugin, cs);
        this.perms = new UtilPermission(this.plugin, cs);
        if (args.length == 0) {
            this.msg.send("world", "usage");
            this.msg.send("world", "usageactions");
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("list")) {
                return this.listCommand();
            }
            this.msg.send("world", "usage");
            this.msg.send("world", "usageactions");
        } else {
            String name = args[1];
            if (name == null || name.isEmpty()) {
                this.msg.send("generic", "customerror", new String[]{"World names cannot be empty."});
            } else {
                if (args[0].equalsIgnoreCase("create")) {
                    return this.createCommand(args, name);
                }
                if (args[0].equalsIgnoreCase("delete")) {
                    return this.deleteCommand(name);
                }
                if (args[0].equalsIgnoreCase("load")) {
                    return this.loadCommand(name);
                }
                if (args[0].equalsIgnoreCase("unload")) {
                    return this.unloadCommand(name);
                }
                if (args[0].equalsIgnoreCase("tp")) {
                    return new CommandSpawn(this.plugin).onCommand(cs, command, s, args);
                }
                this.msg.send("world", "usage");
                this.msg.send("world", "usageactions");
            }
        }
        return true;
    }

    private boolean createCommand(String[] args, String name) {
        if (!this.perms.has("essence.world.create")) {
            return this.perms.not();
        }
        Map<String, String> flags = new Parser().flags(args);
        UtilWorld.WORLD_STATUS ws = new UtilWorld(this.plugin).create(name, flags);
        if (ws == UtilWorld.WORLD_STATUS.LOADED) {
            this.msg.send("world", "created", new String[]{name});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_S) {
            this.msg.send("world", "notcreated", new String[]{name, "Seed '" + flags.get("-s") + "' is invalid."});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_E) {
            this.msg.send("world", "notcreated", new String[]{name, "Environment '" + flags.get("-e") + "' is invalid."});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_H) {
            this.msg.send("world", "notcreated", new String[]{name, "Hardcore mode '" + flags.get("-h") + "' is invalid."});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_L) {
            this.msg.send("world", "notcreated", new String[]{name, "Load Spawn mode '" + flags.get("-l") + "' is invalid."});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_T) {
            this.msg.send("world", "notcreated", new String[]{name, "World Type '" + flags.get("-t") + "' is invalid."});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_N) {
            this.msg.send("world", "notcreated", new String[]{name, "Generate Structures '" + flags.get("-n") + "' is invalid."});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_A) {
            this.msg.send("world", "notcreated", new String[]{name, "Autoload '" + flags.get("-n") + "' is invalid."});
        } else if (ws == UtilWorld.WORLD_STATUS.OTHER_ERROR) {
            this.msg.send("world", "notcreated", new String[]{name, "An unknown error occurred."});
        } else if (ws == UtilWorld.WORLD_STATUS.EXISTS) {
            this.msg.send("world", "notcreated", new String[]{name, "A world called '" + name + "' already exists."});
        } else if (ws == UtilWorld.WORLD_STATUS.INVALID_CHARS) {
            this.msg.send("world", "notcreated", new String[]{name, "World names cannot contain special characters."});
        } else {
            this.msg.send("world", "notcreated", new String[]{name, "World creation resulted in an unhandled outcome."});
        }
        return true;
    }

    private boolean unloadCommand(String name) {
        if (!this.perms.has("essence.world.unload")) {
            return this.perms.not();
        }
        UtilWorld.WORLD_STATUS ws = new UtilWorld(this.plugin).unload(name);
        if (ws == UtilWorld.WORLD_STATUS.UNLOADED) {
            this.msg.send("world", "unloaded", new String[]{name});
        } else if (ws == UtilWorld.WORLD_STATUS.NOT_FOUND) {
            this.msg.send("world", "notfound", new String[]{name});
        } else if (ws == UtilWorld.WORLD_STATUS.OTHER_ERROR) {
            this.msg.send("generic", "customerror", new String[]{"Unable to unload world '" + name + "'."});
        } else {
            this.msg.send("generic", "customerror", new String[]{"World unloading resulted in an unhandled outcome."});
        }
        return true;
    }

    private boolean deleteCommand(String name) {
        if (!this.perms.has("essence.world.delete")) {
            return this.perms.not();
        }
        UtilWorld.WORLD_STATUS ws = new UtilWorld(this.plugin).delete(name);
        if (ws == UtilWorld.WORLD_STATUS.LOADED) {
            this.msg.send("world", "deleteunloaded", new String[]{name});
        } else if (ws == UtilWorld.WORLD_STATUS.NOT_FOUND) {
            this.msg.send("world", "notfound", new String[]{name});
        } else if (ws == UtilWorld.WORLD_STATUS.OTHER_ERROR) {
            this.msg.send("generic", "customerror", new String[]{"Unable to delete world '" + name + "'."});
        } else if (ws == UtilWorld.WORLD_STATUS.DELETED) {
            this.msg.send("world", "deleted", new String[]{name});
        } else {
            this.msg.send("generic", "customerror", new String[]{"World deletion resulted in an unhandled outcome."});
        }
        return true;
    }

    private boolean loadCommand(String name) {
        if (!this.perms.has("essence.world.load")) {
            return this.perms.not();
        }
        UtilWorld.WORLD_STATUS ws = new UtilWorld(this.plugin).load(name);
        if (ws == UtilWorld.WORLD_STATUS.LOADED) {
            this.msg.send("world", "loaded", new String[]{name});
        } else if (ws == UtilWorld.WORLD_STATUS.NOT_FOUND) {
            this.msg.send("world", "notfound", new String[]{name});
        } else if (ws == UtilWorld.WORLD_STATUS.OTHER_ERROR) {
            this.msg.send("world", "notloaded", new String[]{name, "unable to load due to unknown error"});
        } else {
            this.msg.send("world", "notloaded", new String[]{name, "world loading resulted in an unhandled outcome."});
        }
        return true;
    }

    private boolean listCommand() {
        if (!this.perms.has("essence.world.list")) {
            return this.perms.not();
        }
        List<UtilWorld.ESSENCE_WORLD> worlds = new UtilWorld(this.plugin).list();
        String ll = worlds.stream().filter(world -> world.status == UtilWorld.WORLD_STATUS.LOADED).map(world -> world.name).collect(Collectors.joining(","));
        String lu = worlds.stream().filter(world -> world.status == UtilWorld.WORLD_STATUS.UNLOADED).map(world -> world.name).collect(Collectors.joining(","));
        this.msg.send("world", "listloaded", new String[]{ll});
        this.msg.send("world", "listunloaded", new String[]{lu});
        return true;
    }
}

