/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.spawn;

import java.util.Objects;
import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSpawn
extends FoundryPlayerCommand {
    private final Essence plugin;
    private final Logger log;

    public CommandSpawn(Essence plugin) {
        this.plugin = plugin;
        this.log = new Logger(plugin.foundryConfig);
    }

    @Override
    protected String requiredPermission() {
        return "essence.spawn";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Location teleportLocation;
        String spawnName;
        int waitTime = (Integer)this.plugin.config.get("teleportation.spawn.wait");
        UtilTeleport teleUtil = new UtilTeleport(this.plugin);
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        Player p = (Player)cs;
        if (!teleUtil.cooldownSurpassed(p, "spawn")) {
            msg.send("teleport", "tryagain", new String[]{String.valueOf(teleUtil.cooldownRemaining(p, "spawn"))});
            return true;
        }
        if (args.length == 0 && ((Boolean)this.plugin.config.get("teleportation.spawn.global-spawn.enabled")).booleanValue()) {
            new UtilTeleport(this.plugin).sendToSpawn(p, this.plugin.config.get("teleportation.spawn.global-spawn.world").toString());
            return true;
        }
        Location loc = p.getLocation();
        if (args.length != 0) {
            if (!new UtilPermission(this.plugin, cs).has("essence.world.teleport")) {
                msg.send("spawn", "worldnoperms");
                return true;
            }
            spawnName = Objects.equals(args[0], "tp") ? (args.length >= 2 ? args[1] : loc.getWorld().getName()) : args[0];
        } else {
            spawnName = loc.getWorld().getName();
        }
        Files spawnData = new Files(this.plugin.foundryConfig, this.plugin);
        spawnData.load("data/worlds.yml");
        UUID uid = Objects.requireNonNull(Bukkit.getServer().getWorld(spawnName)).getUID();
        if (Bukkit.getServer().getWorld(spawnName) == null) {
            this.log.severe("Unable to locate world in universe.");
            this.log.severe("Details: {\"error\": \"WORLD_IS_NULL\", \"caught\": \"SpawnCommand.java\", \"submitted\": \"" + spawnName + "\", \"found\": \"null\"}.");
        }
        if (spawnData.get("world." + String.valueOf(uid) + ".spawn") == null) {
            if (this.plugin.verbose) {
                this.log.warn("Spawn not implicitly set for world '" + spawnName + "', grabbing vanilla spawnpoint.");
            }
            if (Bukkit.getServer().getWorld(spawnName) == null) {
                msg.send("spawn", "notexist");
                return true;
            }
            teleportLocation = new Location(Bukkit.getServer().getWorld(spawnName), Objects.requireNonNull(Bukkit.getServer().getWorld(spawnName)).getSpawnLocation().getX(), Objects.requireNonNull(Bukkit.getServer().getWorld(spawnName)).getSpawnLocation().getY(), Objects.requireNonNull(Bukkit.getServer().getWorld(spawnName)).getSpawnLocation().getZ(), Objects.requireNonNull(Bukkit.getServer().getWorld(spawnName)).getSpawnLocation().getYaw(), Objects.requireNonNull(Bukkit.getServer().getWorld(spawnName)).getSpawnLocation().getPitch());
        } else {
            if (this.plugin.verbose) {
                this.log.info("Spawn implicitly set for world '" + spawnName + "'.");
            }
            if (Bukkit.getServer().getWorld(spawnName) == null) {
                msg.send("generic", "exception");
                this.log.warn("Player " + String.valueOf(p) + " attempted to teleport to spawn " + spawnName + " but couldn't due to an error.");
                this.log.warn("Error: world is null, please check configuration file.");
            }
            teleportLocation = new Location(Bukkit.getServer().getWorld(spawnName), spawnData.getDouble("world." + String.valueOf(uid) + ".spawn.x"), spawnData.getDouble("world." + String.valueOf(uid) + ".spawn.y"), spawnData.getDouble("world." + String.valueOf(uid) + ".spawn.z"), (float)spawnData.getDouble("world." + String.valueOf(uid) + ".spawn.yaw"), (float)spawnData.getDouble("world." + String.valueOf(uid) + ".spawn.pitch"));
        }
        teleUtil.setCooldown(p, "spawn");
        if (waitTime > 0) {
            msg.send("spawn", "teleportingin", new String[]{String.valueOf(waitTime)});
        } else {
            msg.send("spawn", "teleportingnow");
        }
        teleUtil.doTeleport(p, teleportLocation, waitTime, true);
        spawnData.close();
        return true;
    }
}

