/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation;

import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class UtilLocation {
    private final Essence plugin;

    public UtilLocation(Essence plugin) {
        this.plugin = plugin;
    }

    public void UpdateLastLocation(Player p) {
        UtilPlayer up = new UtilPlayer(this.plugin);
        UUID pid = p.getUniqueId();
        if (up.setPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_WORLD, p.getLocation().getWorld().getName()) && up.setPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_X, p.getLocation().getX()) && up.setPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_Y, p.getLocation().getY()) && up.setPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_Z, p.getLocation().getZ()) && up.setPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_YAW, Float.valueOf(p.getLocation().getYaw())) && up.setPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_PITCH, Float.valueOf(p.getLocation().getPitch()))) {
            return;
        }
        this.plugin.log.warn("Unable to update last location: player " + p.getName() + " may be null.");
    }

    public int GetGroundY(World world, int x, int z) {
        int y = 319;
        Material block = world.getBlockAt(x, y, z).getType();
        while (block == Material.AIR) {
            block = world.getBlockAt(x, --y, z).getType();
            if (y != -64) continue;
        }
        if (!this.LocationIsSafe(block) || y == -64) {
            return -64;
        }
        return y + 1;
    }

    private boolean LocationIsSafe(Material block) {
        return block != Material.LAVA && block != Material.WATER && block != Material.MAGMA_BLOCK && block != Material.POWDER_SNOW && block != Material.CACTUS && block != Material.VOID_AIR;
    }

    public void sendBack(Player player, int waitTime) {
        Float yaw;
        Double z;
        Double y;
        Double x;
        String worldName;
        Object pitchObj;
        block5: {
            block4: {
                UtilPlayer up = new UtilPlayer(this.plugin);
                UUID pid = player.getUniqueId();
                Object worldNameObj = up.getPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_WORLD);
                Object xObj = up.getPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_X);
                Object yObj = up.getPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_Y);
                Object zObj = up.getPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_Z);
                Object yawObj = up.getPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_YAW);
                pitchObj = up.getPlayer(pid, UtilPlayer.KEYS.LAST_LOCATION_PITCH);
                if (!(worldNameObj instanceof String)) break block4;
                worldName = (String)worldNameObj;
                if (!(xObj instanceof Double)) break block4;
                x = (Double)xObj;
                if (!(yObj instanceof Double)) break block4;
                y = (Double)yObj;
                if (!(zObj instanceof Double)) break block4;
                z = (Double)zObj;
                if (!(yawObj instanceof Float)) break block4;
                yaw = (Float)yawObj;
                if (pitchObj instanceof Float) break block5;
            }
            this.plugin.log.warn("Unable to send back " + player.getName() + " \u2013 cached last location is incomplete.");
            return;
        }
        Float pitch = (Float)pitchObj;
        World world = Bukkit.getServer().getWorld(worldName);
        if (world == null) {
            this.plugin.log.warn("Unable to send back " + player.getName() + " \u2013 world '" + worldName + "' not found.");
            return;
        }
        new UtilTeleport(this.plugin).doTeleport(player, world, x, y, z, yaw.floatValue(), pitch.floatValue(), waitTime, true);
    }
}

