/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandDescend
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandDescend(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.teleport.descend";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        int levels = 1;
        if (args.length > 0) {
            try {
                levels = Integer.parseInt(args[0]);
                if (levels <= 0) {
                    msg.send("descend", "invalidnumber", new String[]{args[0]});
                    return true;
                }
                return this.descend((Player)cs, levels, msg);
            }
            catch (NumberFormatException e) {
                msg.send("descend", "invalidnumber", new String[]{args[0]});
                return true;
            }
        }
        return this.descend((Player)cs, levels, msg);
    }

    private boolean descend(Player cs, Integer levels, UtilMessage msg) {
        int waitTime;
        UtilTeleport.LevelLocation result = UtilTeleport.findLevelLocation(cs.getLocation(), UtilTeleport.Direction.DOWN, levels, cs);
        if (result == null) {
            msg.send("descend", "nosafelocation");
            return true;
        }
        Location descendLocation = result.location();
        int finalLevels = result.finalLevels();
        int n = waitTime = this.plugin.config.get("teleportation.descend.wait") != null ? (Integer)this.plugin.config.get("teleportation.descend.wait") : 0;
        if (descendLocation == null) {
            msg.send("descend", "nosafelocation");
            return true;
        }
        new UtilTeleport(this.plugin).doTeleport(cs, descendLocation, waitTime, true);
        if (waitTime == 0) {
            msg.send("descend", "going", new String[]{String.valueOf(finalLevels)});
            return true;
        }
        return true;
    }
}

