/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.inventory;

import java.util.List;
import java.util.Map;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.inventory.TypeReadOnlyInventory;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.StonecuttingRecipe;

public class CommandRecipe
extends FoundryPlayerCommand {
    private final Essence plugin;
    private UtilMessage msg;

    public CommandRecipe(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.inventory.recipe";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Player p = (Player)cs;
        this.msg = new UtilMessage(this.plugin, cs);
        if (args.length > 1) {
            this.msg.send("recipe", "usage");
            return true;
        }
        Material material = null;
        if (args.length > 0) {
            material = Material.matchMaterial((String)args[0]);
        } else if (p.getInventory().getItemInMainHand() != null) {
            material = p.getInventory().getItemInMainHand().getType();
        }
        if (material == null) {
            this.msg.send("generic", "itemnotfound", new String[]{args.length > 0 ? args[0] : "UNKNOWN"});
        } else if (material == Material.AIR) {
            this.msg.send("recipe", "norecipe", new String[]{"AIR"});
        } else {
            this.showRecipe(p, material);
        }
        return true;
    }

    private void showRecipe(Player player, Material material) {
        Inventory inv;
        List recipes = Bukkit.getServer().getRecipesFor(new ItemStack(material));
        if (recipes.isEmpty()) {
            this.msg.send("recipe", "norecipe", new String[]{material.name()});
            return;
        }
        Recipe recipe = (Recipe)recipes.getFirst();
        TypeReadOnlyInventory holder = new TypeReadOnlyInventory();
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            inv = Bukkit.createInventory((InventoryHolder)holder, (InventoryType)InventoryType.WORKBENCH, (String)("Recipe: " + material.name()));
            int slot = 1;
            for (ItemStack i : shapeless.getIngredientList()) {
                inv.setItem(slot++, i);
            }
            inv.setItem(0, new ItemStack(material));
        } else if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            inv = Bukkit.createInventory((InventoryHolder)holder, (InventoryType)InventoryType.WORKBENCH, (String)("Recipe: " + material.name()));
            String[] shape = shaped.getShape();
            Map choiceMap = shaped.getChoiceMap();
            int r = 1;
            for (String s : shape) {
                char[] charArray = s.toCharArray();
                int i = 1;
                for (char c : charArray) {
                    RecipeChoice choice = (RecipeChoice)choiceMap.get(Character.valueOf(c));
                    if (choice != null) {
                        inv.setItem((r - 1) * 3 + i, choice.getItemStack());
                    } else {
                        inv.setItem((r - 1) * 3 + i, null);
                    }
                    ++i;
                }
                ++r;
            }
            inv.setItem(0, new ItemStack(material));
        } else if (recipe instanceof FurnaceRecipe) {
            FurnaceRecipe furnace = (FurnaceRecipe)recipe;
            inv = Bukkit.createInventory((InventoryHolder)holder, (InventoryType)InventoryType.FURNACE, (String)("Recipe: " + material.name()));
            inv.setItem(0, furnace.getInput());
            inv.setItem(2, furnace.getResult());
        } else if (recipe instanceof StonecuttingRecipe) {
            StonecuttingRecipe stonecut = (StonecuttingRecipe)recipe;
            inv = Bukkit.createInventory((InventoryHolder)holder, (InventoryType)InventoryType.STONECUTTER, (String)("Recipe: " + material.name()));
            inv.setItem(0, stonecut.getInput());
            inv.setItem(2, stonecut.getResult());
        } else {
            this.msg.send("recipe", "notsupported", new String[]{material.name()});
            return;
        }
        player.openInventory(inv);
    }
}

