/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.inventory;

import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.TypePendingRequests;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class CommandClear
extends FoundryCommand {
    private final Essence plugin;

    public CommandClear(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.inventory.clear";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Player target;
        Player p;
        Player executor;
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        UtilPermission perm = new UtilPermission(this.plugin, cs);
        Player player = executor = cs instanceof Player ? (p = (Player)cs) : null;
        Player player2 = args.length == 1 ? Bukkit.getPlayer((String)args[0]) : (target = executor != null && args.length == 0 ? executor : null);
        if (this.confirmRequired(executor, target, msg)) {
            return true;
        }
        if (args.length == 1) {
            if (target == null) {
                msg.send("generic", "playernotfound");
                return true;
            }
            if (!perm.has("essence.inventory.clear.other")) return perm.not();
            target.getInventory().clear();
            if (executor == null) return true;
            this.plugin.pendingClears.remove(executor.getUniqueId());
            msg.send("clear", "clearedother", new String[]{target.getName()});
            msg.sendTo((CommandSender)target, "clear", "clearedby", new String[]{cs.getName()});
            return true;
        } else if (args.length == 0) {
            if (cs instanceof ConsoleCommandSender) {
                msg.send("clear", "usage");
                return true;
            } else {
                if (executor == null) return true;
                executor.getInventory().clear();
                msg.send("clear", "cleared");
            }
            return true;
        } else {
            msg.send("clear", "usage");
        }
        return true;
    }

    private boolean confirmRequired(Player executor, Player target, UtilMessage msg) {
        boolean sameTarget;
        Boolean b;
        boolean requireConfirm;
        if (executor == null) {
            return false;
        }
        UtilPlayer up = new UtilPlayer(this.plugin);
        Object object = up.getPlayer(executor.getUniqueId(), UtilPlayer.KEYS.USER_CONFIRM_CLEAR);
        boolean bl = requireConfirm = object instanceof Boolean && (b = (Boolean)object) != false;
        if (!requireConfirm) {
            return false;
        }
        UUID executorId = executor.getUniqueId();
        UUID targetId = target != null ? target.getUniqueId() : executorId;
        TypePendingRequests.TypePendingClears pending = (TypePendingRequests.TypePendingClears)this.plugin.pendingClears.get(executorId);
        boolean bl2 = sameTarget = pending != null && pending.target.equals(targetId);
        if (pending == null || System.currentTimeMillis() - pending.time > 30000L || !sameTarget) {
            TypePendingRequests.TypePendingClears newPending = new TypePendingRequests.TypePendingClears();
            newPending.time = System.currentTimeMillis();
            newPending.target = targetId;
            this.plugin.pendingClears.put(executorId, newPending);
            msg.send("clear", "confirm");
            return true;
        }
        this.plugin.pendingClears.remove(executorId);
        return false;
    }
}

