/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.external;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.lewmc.essence.external.FoundryConfig;
import net.lewmc.essence.external.IBukkit;
import net.lewmc.essence.external.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Registry {
    private final JavaPlugin plugin;
    private final FoundryConfig config;
    private final IBukkit ib;
    private final Map<String, Command> runtimeCommands = new HashMap<String, Command>();
    private final Map<String, TabCompleter> runtimeCompleters = new HashMap<String, TabCompleter>();

    public Registry(FoundryConfig config, JavaPlugin plugin) {
        this.config = config;
        this.plugin = plugin;
        this.ib = new IBukkit(config, plugin);
    }

    public boolean command(String command, CommandExecutor executor) {
        return this.ymlCommand(command, executor);
    }

    public boolean[] command(String[] commands, CommandExecutor executor) {
        return this.ymlCommand(commands, executor);
    }

    public boolean ymlCommand(String label, CommandExecutor executor) {
        if (this.plugin.getCommand(label) != null) {
            Objects.requireNonNull(this.plugin.getCommand(label)).setExecutor(executor);
            this.verboseAlert("ymlCommand", label);
            return true;
        }
        new Logger(this.config).severe("Failed to register ymlCommand " + label + " because it is null.");
        return false;
    }

    public boolean[] ymlCommand(String[] labels, CommandExecutor executor) {
        boolean[] success = new boolean[labels.length];
        int i = 0;
        for (String command : labels) {
            success[i] = this.ymlCommand(command, executor);
            ++i;
        }
        return success;
    }

    public boolean runtimeCommand(String label, final CommandExecutor executor, String ... aliases) {
        if (label != null && executor != null) {
            Command dynamicCommand = new Command(label){

                public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
                    return executor.onCommand(sender, (Command)this, commandLabel, args);
                }

                @NotNull
                public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
                    TabCompleter completer = Registry.this.runtimeCompleters.get(this.getName().toLowerCase());
                    if (completer != null) {
                        return Objects.requireNonNull(completer.onTabComplete(sender, (Command)this, alias, args));
                    }
                    return super.tabComplete(sender, alias, args);
                }
            };
            dynamicCommand.setAliases(Arrays.asList(aliases));
            CommandMap map = this.ib.getCommandMap();
            if (map != null) {
                map.register(this.plugin.getDescription().getName(), dynamicCommand);
                this.runtimeCommands.put(label.toLowerCase(), dynamicCommand);
                return true;
            }
            return false;
        }
        new Logger(this.config).severe("Failed to register runtimeCommand " + label + " because it is null.");
        return false;
    }

    public boolean[] runtimeCommand(String[] labels, CommandExecutor executor, String ... aliases) {
        boolean[] success = new boolean[labels.length];
        int i = 0;
        for (String command : labels) {
            success[i] = this.runtimeCommand(command, executor, aliases);
            ++i;
        }
        return success;
    }

    public boolean tabCompleter(String command, TabCompleter completer) {
        PluginCommand cmd = this.plugin.getCommand(command);
        if (cmd != null && cmd instanceof PluginCommand) {
            cmd.setTabCompleter(completer);
            this.verboseAlert("Tab completer", completer.toString());
            return true;
        }
        Command runtimeCmd = this.runtimeCommands.get(command.toLowerCase());
        if (runtimeCmd != null) {
            this.runtimeCompleters.put(command.toLowerCase(), completer);
            this.verboseAlert("Runtime tab completer", completer.toString());
            return true;
        }
        new Logger(this.config).severe("Failed to register tab completer " + completer.toString() + " because it is null.");
        return false;
    }

    public boolean[] tabCompleter(String[] commands, TabCompleter completer) {
        boolean[] success = new boolean[commands.length];
        int i = 0;
        for (String command : commands) {
            success[i] = this.tabCompleter(command, completer);
            ++i;
        }
        return success;
    }

    public boolean event(Listener event) {
        Bukkit.getServer().getPluginManager().registerEvents(event, (Plugin)this.plugin);
        this.verboseAlert("Event", event.toString());
        return true;
    }

    public void verboseAlert(String type, String asset) {
        if (this.config.verbose) {
            new Logger(this.config).info("FoundryRegistry > " + type + " " + asset + " registered.");
        }
    }
}

