/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.external;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.lewmc.essence.external.FoundryConfig;
import net.lewmc.essence.external.Logger;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Files {
    private final JavaPlugin plugin;
    private final Logger log;
    private final FoundryConfig foundryConfig;
    private YamlConfiguration config;
    private File file;

    public Files(FoundryConfig config, JavaPlugin plugin) {
        this.plugin = plugin;
        this.foundryConfig = config;
        this.log = new Logger(config);
        this.config = new YamlConfiguration();
    }

    public boolean create(String path) {
        File createFile = new File(this.plugin.getDataFolder(), this.parseFileName(path));
        try {
            if (createFile.getParentFile().mkdirs() || createFile.getParentFile().exists()) {
                if (this.foundryConfig.verbose) {
                    this.log.info("Created file at " + String.valueOf(new File(this.plugin.getDataFolder(), this.parseFileName(path))));
                }
                return createFile.createNewFile();
            }
            this.log.severe("Failed to create file " + path);
            this.log.severe("Unable to create parent directory.");
            return false;
        }
        catch (IOException e) {
            this.log.severe("Failed to create file " + path);
            this.log.severe(e.getMessage());
            return false;
        }
    }

    public boolean exists(String path) {
        File file = new File(this.plugin.getDataFolder(), this.parseFileName(path));
        return file.exists();
    }

    public boolean load(String path) {
        if (!this.isOpen()) {
            this.config = new YamlConfiguration();
            File file = new File(this.plugin.getDataFolder(), this.parseFileName(path));
            try {
                if (file.exists()) {
                    this.config.load(file);
                    this.file = file;
                    if (this.foundryConfig.verbose) {
                        this.log.info("Opened file at " + String.valueOf(file));
                    }
                    return true;
                }
                this.log.warn("Unable to open file at '" + file.getAbsolutePath() + "'.");
                return false;
            }
            catch (IOException | InvalidConfigurationException e) {
                this.log.severe("Failed to read file " + file.getAbsolutePath());
                this.log.severe(e.getMessage());
                return false;
            }
        }
        this.log.warn("Tried to open a file when another file was already open.");
        return false;
    }

    public boolean loadNoReformat(String path) {
        if (!this.isOpen()) {
            this.config = new YamlConfiguration();
            File file = new File(path);
            try {
                if (file.exists()) {
                    this.config.load(file);
                    this.file = file;
                    if (this.foundryConfig.verbose) {
                        this.log.info("Opened file at " + String.valueOf(file));
                    }
                    return true;
                }
                this.log.warn("Unable to open file at '" + file.getAbsolutePath() + "'.");
                return false;
            }
            catch (IOException | InvalidConfigurationException e) {
                this.log.severe("Failed to read file " + file.getAbsolutePath());
                this.log.severe(e.getMessage());
                return false;
            }
        }
        this.log.warn("Tried to open a file when another file was already open.");
        return false;
    }

    public boolean loadNoReformat(File file) {
        if (!this.isOpen()) {
            this.config = new YamlConfiguration();
            try {
                if (file.exists()) {
                    this.config.load(file);
                    this.file = file;
                    if (this.foundryConfig.verbose) {
                        this.log.info("Opened file at " + String.valueOf(file));
                    }
                    return true;
                }
                this.log.warn("Unable to open file at '" + file.getAbsolutePath() + "'.");
                return false;
            }
            catch (IOException | InvalidConfigurationException e) {
                this.log.severe("Failed to read file " + file.getAbsolutePath());
                this.log.severe(e.getMessage());
                return false;
            }
        }
        this.log.warn("Tried to open a file when another file was already open.");
        return false;
    }

    public boolean delete(String path) {
        try {
            File file = new File(this.plugin.getDataFolder(), this.parseFileName(path));
            return file.delete();
        }
        catch (SecurityException e) {
            this.log.severe("Failed to delete file " + path);
            this.log.severe(e.getMessage());
            return false;
        }
    }

    public boolean deleteDirectory(Path path) throws IOException {
        if (!java.nio.file.Files.exists(path, new LinkOption[0])) {
            return false;
        }
        java.nio.file.Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(p -> {
            try {
                java.nio.file.Files.delete(p);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return true;
    }

    public boolean save(File file) {
        if (this.isOpen()) {
            try {
                this.config.save(file);
                this.close();
                return true;
            }
            catch (IOException e) {
                this.log.severe("Failed to save file " + String.valueOf(file));
                this.log.severe(e.getMessage());
                return false;
            }
        }
        this.log.warn("Tried to save file '" + file.getName() + "' without opening it first.");
        return false;
    }

    public boolean save() {
        if (this.isOpen()) {
            try {
                this.config.save(this.file);
                if (this.foundryConfig.verbose) {
                    this.log.info("Saved file to " + String.valueOf(this.file));
                }
                this.close();
                return true;
            }
            catch (IOException e) {
                this.log.severe("Failed to save file " + String.valueOf(this.file));
                this.log.severe(e.getMessage());
                this.close();
                return false;
            }
        }
        this.log.warn("Tried to save a file without opening a file first.");
        return false;
    }

    public boolean set(String key, Object value) {
        if (this.isOpen()) {
            this.config.set(key, value);
            if (this.foundryConfig.verbose) {
                this.log.info("Set " + key + " to " + String.valueOf(value) + " in file " + String.valueOf(this.file));
            }
            return true;
        }
        this.log.warn("Tried to set '" + key + "' in a file without opening a file first.");
        return false;
    }

    public Object get(String key) {
        if (this.isOpen()) {
            return this.config.get(key);
        }
        this.log.warn("Tried to get object '" + key + "' from a file without opening a file first.");
        return null;
    }

    public boolean getBoolean(String key) {
        if (this.isOpen()) {
            return this.config.getBoolean(key);
        }
        this.log.warn("Tried to get boolean '" + key + "' from a file without opening a file first.");
        return false;
    }

    public String getString(String key) {
        if (this.isOpen()) {
            return this.config.getString(key);
        }
        this.log.warn("Tried to get string '" + key + "' from a file without opening a file first.");
        return null;
    }

    public int getInt(String key) {
        if (this.isOpen()) {
            return this.config.getInt(key);
        }
        this.log.warn("Tried to get integer '" + key + "' from a file without opening a file first.");
        return 0;
    }

    public double getDouble(String key) {
        if (this.isOpen()) {
            return this.config.getDouble(key);
        }
        this.log.warn("Tried to get double '" + key + "' from a file without opening a file first.");
        return 0.0;
    }

    public List<String> getStringList(String key) {
        if (this.isOpen()) {
            return this.config.getStringList(key);
        }
        this.log.warn("Tried to get list '" + key + "' from a file without opening a file first.");
        return null;
    }

    public Set<String> getKeys(boolean deep) {
        if (this.isOpen()) {
            return this.config.getKeys(deep);
        }
        this.log.warn("Tried to get keys from a file without opening a file first.");
        return null;
    }

    public Set<String> getKeys(String section, boolean deep) {
        if (this.isOpen()) {
            ConfigurationSection cs = this.config.getConfigurationSection(section);
            if (cs != null) {
                return cs.getKeys(deep);
            }
            return null;
        }
        this.log.warn("Tried to get keys from section '" + section + "' in a file without opening a file first.");
        return null;
    }

    public boolean close() {
        if (this.isOpen()) {
            this.config = null;
            this.file = null;
            return true;
        }
        this.log.warn("Tried to close a file before one had been opened.");
        return false;
    }

    public boolean isOpen() {
        return this.config != null && this.file != null;
    }

    public String playerDataFile(Player player) {
        return "data/players/" + String.valueOf(player.getUniqueId()) + ".yml";
    }

    public String playerDataFile(OfflinePlayer offlinePlayer) {
        return "data/players/" + String.valueOf(offlinePlayer.getUniqueId()) + ".yml";
    }

    public String playerDataFile(UUID uuid) {
        return "data/players/" + String.valueOf(uuid) + ".yml";
    }

    private String parseFileName(String fileName) {
        if (fileName != null && !((String)(fileName = ((String)fileName).replace("\\", "/"))).startsWith("/")) {
            fileName = "/" + (String)fileName;
        }
        return fileName;
    }

    public boolean remove(String key) {
        if (this.isOpen()) {
            this.set(key, null);
            if (this.foundryConfig.verbose) {
                this.log.info("Removed " + key + " from file " + String.valueOf(this.file));
            }
            return true;
        }
        this.log.warn("Tried to remove '" + key + "' from a file without opening a file first.");
        return false;
    }
}

