/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.core;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilPlaceholder;
import net.lewmc.essence.external.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UtilMessage {
    private final CommandSender cs;
    private final Essence plugin;

    public UtilMessage(Essence plugin, CommandSender cs) {
        this.plugin = plugin;
        this.cs = cs;
    }

    public void send(String group, String msg, String[] replace) {
        String message = this.getMessage(msg, group);
        if (message != null) {
            int i = 1;
            for (String item : replace) {
                message = message.replace("{{" + i + "}}", item);
                ++i;
            }
            this.cs.sendMessage(new UtilPlaceholder(this.plugin, this.cs).replaceAll(message));
        } else {
            this.cs.sendMessage(String.valueOf(ChatColor.DARK_RED) + "[Essence] " + String.valueOf(ChatColor.RED) + "Unable to send message to player, see console for more information.");
            new Logger(this.plugin.foundryConfig).warn("Unable to send message '" + group + "." + msg + "' to player, could not find key in en-GB.yml");
        }
    }

    public void send(String group, String msg) {
        String message = this.getMessage(msg, group);
        if (message != null) {
            this.cs.sendMessage(message);
        } else {
            this.cs.sendMessage(String.valueOf(ChatColor.DARK_RED) + "[Essence] " + String.valueOf(ChatColor.RED) + "Unable to send message to player, see console for more information.");
            new Logger(this.plugin.foundryConfig).warn("Unable to send message '" + group + "." + msg + "' to player, could not find key in en-GB.yml");
        }
    }

    public void sendTo(CommandSender cs, String group, String msg) {
        String message = this.getMessage(msg, group);
        if (message != null) {
            cs.sendMessage(message);
        } else {
            cs.sendMessage(String.valueOf(ChatColor.DARK_RED) + "[Essence] " + String.valueOf(ChatColor.RED) + "Unable to send message to player, see console for more information.");
            this.cs.sendMessage(String.valueOf(ChatColor.DARK_RED) + "[Essence] " + String.valueOf(ChatColor.RED) + "Unable to send message to player, see console for more information.");
            new Logger(this.plugin.foundryConfig).warn("Unable to send message '" + group + "." + msg + "' to player, could not find key in en-GB.yml");
        }
    }

    public void sendTo(CommandSender cs, String group, String msg, String[] replace) {
        String message = this.getMessage(msg, group);
        if (message != null) {
            int i = 1;
            for (String item : replace) {
                message = message.replace("{{" + i + "}}", item);
                ++i;
            }
            cs.sendMessage(message);
        } else {
            cs.sendMessage(String.valueOf(ChatColor.DARK_RED) + "[Essence] " + String.valueOf(ChatColor.RED) + "Unable to send message to player, see console for more information.");
            this.cs.sendMessage(String.valueOf(ChatColor.DARK_RED) + "[Essence] " + String.valueOf(ChatColor.RED) + "Unable to send message to player, see console for more information.");
            new Logger(this.plugin.foundryConfig).warn("Unable to send message '" + group + "." + msg + "' to player, could not find key in en-GB.yml");
        }
    }

    public void broadcast(String message) {
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GOLD) + "Broadcast > " + String.valueOf(ChatColor.YELLOW) + message));
    }

    public void sendToWithButtons(CommandSender cs, String group, String msg, String[] replace, String acceptCommand, String denyCommand) {
        if (!(cs instanceof Player)) {
            this.sendTo(cs, group, msg, replace);
            return;
        }
        Player player = (Player)cs;
        String message = this.getMessage(msg, group);
        if (message != null) {
            int i = 1;
            for (String item : replace) {
                message = message.replace("{{" + i + "}}", item);
                ++i;
            }
            TextComponent mainMessage = new TextComponent(new UtilPlaceholder(this.plugin, cs).replaceAll(message));
            TextComponent acceptButton = new TextComponent(" [" + this.getMessage("acceptbutton", group) + "]");
            acceptButton.setColor(net.md_5.bungee.api.ChatColor.GREEN);
            acceptButton.setBold(Boolean.valueOf(true));
            acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, acceptCommand));
            acceptButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.getMessage("accepthover", group)).create()));
            TextComponent denyButton = new TextComponent(" [" + this.getMessage("denybutton", group) + "]");
            denyButton.setColor(net.md_5.bungee.api.ChatColor.RED);
            denyButton.setBold(Boolean.valueOf(true));
            denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, denyCommand));
            denyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.getMessage("denyhover", group)).create()));
            player.spigot().sendMessage(new BaseComponent[]{mainMessage, acceptButton, denyButton});
        } else {
            cs.sendMessage(String.valueOf(ChatColor.DARK_RED) + "[Essence] " + String.valueOf(ChatColor.RED) + "Unable to send message to player, see console for more information.");
            new Logger(this.plugin.foundryConfig).warn("Unable to send message '" + group + "." + msg + "' to player, could not find key in en-GB.yml");
        }
    }

    private String getMessage(String code, String group) {
        if (this.plugin.messageStore.get(group) != null) {
            return this.plugin.messageStore.getString(group + "." + code);
        }
        return null;
    }
}

