/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.core;

import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.EssenceConfiguration;
import net.lewmc.essence.core.CommandExtHelp;
import net.lewmc.essence.core.UtilImport;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandEssence
extends FoundryCommand {
    private final Essence plugin;

    public CommandEssence(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return null;
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (args.length > 0) {
            if ("help".equals(args[0])) {
                CommandExtHelp helpCommand = new CommandExtHelp(this.plugin, msg, args);
                return helpCommand.runHelpCommand();
            }
            if ("reload".equals(args[0])) {
                return this.reloadCommand(cs, msg);
            }
            if ("import".equals(args[0])) {
                return this.importCommand(args, msg, cs);
            }
            if ("restore".equals(args[0])) {
                return this.restoreCommand(msg, cs);
            }
        } else {
            msg.send("about", "version", new String[]{this.plugin.getDescription().getVersion()});
            msg.send("about", "description");
            msg.send("about", "author");
            if (!Objects.equals(this.plugin.config.get("language"), "en-GB")) {
                Files lang = new Files(this.plugin.foundryConfig, this.plugin);
                lang.load("language/" + String.valueOf(this.plugin.config.get("language")) + ".yml");
                msg.send("about", "authorLang", new String[]{lang.getString("meta.language"), lang.getString("meta.author")});
                lang.close();
            }
            msg.send("about", "issues");
            msg.send("about", "more");
            return true;
        }
        return true;
    }

    private boolean restoreCommand(UtilMessage message, CommandSender cs) {
        UtilPermission perms = new UtilPermission(this.plugin, cs);
        if (perms.has("essence.admin.restore")) {
            this.plugin.saveResource("language/en-GB.yml", true);
            this.plugin.saveResource("language/zh-CN.yml", true);
            this.plugin.saveResource("language/fr-FR.yml", true);
            this.plugin.saveResource("language/es-ES.yml", true);
            this.plugin.saveResource("language/ko-KR.yml", true);
            message.send("generic", "done");
            return true;
        }
        return perms.not();
    }

    private boolean reloadCommand(CommandSender cs, UtilMessage message) {
        UtilPermission perms = new UtilPermission(this.plugin, cs);
        if (perms.has("essence.admin.reload")) {
            this.plugin.config = new EssenceConfiguration(this.plugin).reload();
            this.plugin.verbose = (Boolean)this.plugin.config.get("advanced.verbose");
            this.plugin.messageStore.close();
            this.plugin.messageStore = new Files(this.plugin.foundryConfig, this.plugin);
            this.plugin.messageStore.load("language/" + String.valueOf(this.plugin.config.get("language")) + ".yml");
            message.send("generic", "reload");
            return true;
        }
        return perms.not();
    }

    private boolean importCommand(String[] args, UtilMessage message, CommandSender cs) {
        UtilPermission perms = new UtilPermission(this.plugin, cs);
        if (perms.has("essence.admin.import")) {
            if (args.length > 1) {
                if (args[1].equalsIgnoreCase("essentials")) {
                    UtilImport imp = new UtilImport(this.plugin);
                    if (imp.essentialsWarps()) {
                        message.send("import", "importedwarps", new String[]{"Essentials"});
                    } else {
                        message.send("import", "unabletoimport", new String[]{"warps", "Essentials"});
                    }
                    if (imp.essentialsHomes()) {
                        message.send("import", "importedhomes", new String[]{"Essentials"});
                    } else {
                        message.send("import", "unabletoimport", new String[]{"homes", "Essentials"});
                    }
                    if (imp.essentialsSpawns()) {
                        message.send("import", "importedspawns", new String[]{"Essentials"});
                    } else {
                        message.send("import", "unabletoimport", new String[]{"spawns", "Essentials"});
                    }
                    message.send("generic", "done");
                    return true;
                }
                message.send("import", "unsupported", new String[]{args[1]});
                message.send("import", "list");
                return true;
            }
            message.send("import", "list");
            return true;
        }
        return perms.not();
    }
}

