/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.lewmc.essence.Essence;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.configupdater.ConfigUpdater;
import org.bukkit.plugin.Plugin;

public class EssenceConfiguration {
    public Essence plugin;
    public ConcurrentMap<String, Object> config = new ConcurrentHashMap<String, Object>();
    private final Files configFile;
    private final Logger log;
    private boolean changesMade = false;

    public EssenceConfiguration(Essence plugin) {
        this.plugin = plugin;
        this.configFile = new Files(plugin.foundryConfig, plugin);
        this.log = new Logger(plugin.foundryConfig);
    }

    public ConcurrentMap<String, Object> startup() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        try {
            ConfigUpdater.update((Plugin)this.plugin, "config.yml", configFile, new String[0]);
        }
        catch (IOException e) {
            this.log.warn("Unable to update configuration: " + String.valueOf(e));
        }
        return this.reload();
    }

    public ConcurrentMap<String, Object> reload() {
        if (!this.configFile.exists("config.yml")) {
            this.plugin.saveDefaultConfig();
            if (!this.configFile.exists("config.yml")) {
                Logger log = new Logger(this.plugin.foundryConfig);
                log.severe("The server was unable to create Essence's configuration file!");
                log.severe("You can download a blank config file from the link below.");
                log.severe("https://github.com/LewMC/Essence/blob/main/src/main/resources/config.yml");
                log.severe("Please contact lewmc.net/help for help and to report the issue.");
            }
        }
        this.configFile.load("config.yml");
        this.putBoolean("advanced.verbose", (boolean)((Boolean)this.getValue("advanced.verbose", false, Boolean.class)));
        this.putBoolean("advanced.playerdata.store-ip-address", (boolean)((Boolean)this.getValue("advanced.playerdata.store-ip-address", true, Boolean.class)));
        this.putBoolean("advanced.update-check", (boolean)((Boolean)this.getValue("advanced.update-check", true, Boolean.class)));
        this.putBoolean("admin.enabled", (boolean)((Boolean)this.getValue("admin.enabled", true, Boolean.class)));
        this.putBoolean("chat.enabled", (boolean)((Boolean)this.getValue("chat.enabled", true, Boolean.class)));
        this.putString("chat.name-format", (String)this.getValue("chat.name-format", "%essence_combined_prefix% %essence_player%%essence_player_suffix%:", String.class));
        this.putBoolean("chat.allow-message-formatting", (boolean)((Boolean)this.getValue("chat.allow-message-formatting", true, Boolean.class)));
        this.putObject("chat.broadcasts.first-join", this.getValue("chat.broadcasts.first-join", "\u00a7a%essence_player% joined the server for the first time!", String.class, Boolean.class));
        this.putObject("chat.broadcasts.join", this.getValue("chat.broadcasts.join", "\u00a7e%essence_player% joined the server!", String.class, Boolean.class));
        this.putObject("chat.broadcasts.leave", this.getValue("chat.broadcasts.leave", "\u00a7c%essence_player% left the server!", String.class, Boolean.class));
        this.putObject("chat.motd", this.getValue("chat.motd", "\u00a72\u00a7lWelcome to the server!", String.class, Boolean.class));
        this.putBoolean("chat.manage-chat", (boolean)((Boolean)this.getValue("chat.manage-chat", true, Boolean.class)));
        this.putBoolean("economy.enabled", (boolean)((Boolean)this.getValue("economy.enabled", true, Boolean.class)));
        this.putString("economy.mode", (String)this.getValue("economy.mode", "VAULT", String.class));
        this.putDouble("economy.start-money", (Double)this.getValue("economy.start-money", 100.0, Double.class));
        this.putString("economy.symbol", (String)this.getValue("economy.symbol", "$", String.class));
        this.putBoolean("environment.enabled", (boolean)((Boolean)this.getValue("environment.enabled", true, Boolean.class)));
        this.putBoolean("gamemode.enabled", (boolean)((Boolean)this.getValue("gamemode.enabled", true, Boolean.class)));
        this.putBoolean("inventory.enabled", (boolean)((Boolean)this.getValue("inventory.enabled", true, Boolean.class)));
        this.putBoolean("kit.enabled", (boolean)((Boolean)this.getValue("kit.enabled", true, Boolean.class)));
        this.putStringList("kit.spawn-kits", (List)this.getValue("kit.spawn-kits", List.of("wooden-tools"), List.class));
        this.putBoolean("stats.enabled", (boolean)((Boolean)this.getValue("stats.enabled", true, Boolean.class)));
        this.putBoolean("team.enabled", (boolean)((Boolean)this.getValue("team.enabled", true, Boolean.class)));
        this.putBoolean("teleportation.enabled", (boolean)((Boolean)this.getValue("teleportation.enabled", true, Boolean.class)));
        this.putInt("teleportation.back.wait", (Integer)this.getValue("teleportation.back.wait", 3, Integer.class));
        this.putInt("teleportation.top.wait", (Integer)this.getValue("teleportation.top.wait", 3, Integer.class));
        this.putInt("teleportation.bottom.wait", (Integer)this.getValue("teleportation.bottom.wait", 3, Integer.class));
        this.putInt("teleportation.ascend.wait", (Integer)this.getValue("teleportation.ascend.wait", 3, Integer.class));
        this.putInt("teleportation.descend.wait", (Integer)this.getValue("teleportation.descend.wait", 3, Integer.class));
        this.putInt("teleportation.home.wait", (Integer)this.getValue("teleportation.home.wait", 3, Integer.class));
        this.putInt("teleportation.home.cooldown", (Integer)this.getValue("teleportation.home.cooldown", 10, Integer.class));
        this.putInt("teleportation.warp.wait", (Integer)this.getValue("teleportation.warp.wait", 3, Integer.class));
        this.putInt("teleportation.warp.cooldown", (Integer)this.getValue("teleportation.warp.cooldown", 10, Integer.class));
        this.putInt("teleportation.randomtp.cooldown", (Integer)this.getValue("teleportation.randomtp.cooldown", 60, Integer.class));
        this.putInt("teleportation.spawn.wait", (Integer)this.getValue("teleportation.spawn.wait", 3, Integer.class));
        this.putInt("teleportation.spawn.cooldown", (Integer)this.getValue("teleportation.spawn.cooldown", 10, Integer.class));
        this.putString("teleportation.spawn.global-spawn.world", (String)this.getValue("teleportation.spawn.global-spawn.world", "world", String.class));
        this.putBoolean("teleportation.spawn.global-spawn.enabled", (boolean)((Boolean)this.getValue("teleportation.spawn.global-spawn.enabled", false, Boolean.class)));
        this.putBoolean("teleportation.spawn.force-spawn.on-death", (boolean)((Boolean)this.getValue("teleportation.spawn.force-spawn.on-death", false, Boolean.class)));
        this.putBoolean("teleportation.spawn.force-spawn.on-join", (boolean)((Boolean)this.getValue("teleportation.spawn.force-spawn.on-join", false, Boolean.class)));
        this.putInt("teleportation.near.default-radius", (Integer)this.getValue("teleportation.near.default-radius", 200, Integer.class));
        this.putInt("teleportation.near.max-radius", (Integer)this.getValue("teleportation.near.max-radius", 50000, Integer.class));
        this.putInt("teleportation.requests.cooldown", (Integer)this.getValue("teleportation.requests.cooldown", 10, Integer.class));
        this.putBoolean("teleportation.requests.default-enabled", (boolean)((Boolean)this.getValue("teleportation.requests.default-enabled", true, Boolean.class)));
        this.putBoolean("teleportation.extended-toggle", (boolean)((Boolean)this.getValue("teleportation.extended-toggle", false, Boolean.class)));
        this.putBoolean("teleportation.move-to-cancel", (boolean)((Boolean)this.getValue("teleportation.move-to-cancel", true, Boolean.class)));
        this.putBoolean("world.enabled", (boolean)((Boolean)this.getValue("world.enabled", true, Boolean.class)));
        this.putString("language", (String)this.getValue("language", "en-GB", String.class));
        this.putStringList("disabled-commands", (List)this.getValue("disabled-commands", List.of("example"), List.class));
        this.putStringList("item-blacklist", (List)this.getValue("item-blacklist", List.of("example"), List.class));
        this.putInt("config-version", (Integer)this.getValue("config-version", 3, Integer.class));
        if (this.changesMade) {
            this.configFile.save();
        } else {
            this.configFile.close();
        }
        return this.config;
    }

    private void putObject(String key, Object value) {
        this.config.put(key, value);
        this.verboseLog(key);
    }

    private void putString(String key, String value) {
        this.config.put(key, value);
        this.verboseLog(key);
    }

    private void putStringList(String key, List<String> value) {
        this.config.put(key, value);
        this.verboseLog(key);
    }

    private void putInt(String key, Integer value) {
        this.config.put(key, value);
        this.verboseLog(key);
    }

    private void putDouble(String key, Double value) {
        this.config.put(key, value);
        this.verboseLog(key);
    }

    private void putBoolean(String key, Boolean value) {
        this.config.put(key, value);
        this.verboseLog(key);
    }

    private Object getValue(String key, Object defaultValue, Class<?> ... classes) {
        if (this.configFile.get(key) != null) {
            Object value = this.configFile.get(key);
            for (Class<?> clazz : classes) {
                if (!clazz.isInstance(value)) continue;
                return value;
            }
            this.changesMade = true;
            this.configFile.set(key, defaultValue);
            this.log.warn("Config > Value '" + key + "' had invalid type.");
            this.log.warn("Config > Value '" + key + "' was reset to '" + String.valueOf(defaultValue) + "'.");
            this.log.warn("Config > Please double-check your configuration is correct.");
            return defaultValue;
        }
        this.changesMade = true;
        this.configFile.set(key, defaultValue);
        this.log.warn("Config > Value '" + key + "' did not exist in the config file.");
        this.log.warn("Config > Value '" + key + "' was reset to '" + String.valueOf(defaultValue) + "'.");
        return defaultValue;
    }

    private void verboseLog(String key) {
        if (((Boolean)this.config.get("advanced.verbose")).booleanValue()) {
            this.log.info("Config > " + key + " = " + String.valueOf(this.config.get(key)));
        }
    }
}

