/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.home;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.home.UtilHome;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHome
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandHome(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.home.use";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        String chatHomeName;
        Object homeName;
        UtilTeleport teleUtil = new UtilTeleport(this.plugin);
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        int waitTime = (Integer)this.plugin.config.get("teleportation.home.wait");
        if (!teleUtil.cooldownSurpassed((Player)cs, "home")) {
            msg.send("teleport", "tryagain", new String[]{String.valueOf(teleUtil.cooldownRemaining((Player)cs, "home"))});
            return true;
        }
        Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
        playerData.load(playerData.playerDataFile((Player)cs));
        if (args.length == 1) {
            homeName = "homes." + args[0].toLowerCase();
            chatHomeName = args[0].toLowerCase();
            if (playerData.get((String)homeName) == null) {
                playerData.close();
                msg.send("home", "notfound", new String[]{args[0].toLowerCase()});
                return true;
            }
        } else {
            homeName = "homes.home";
            chatHomeName = "home";
            if (playerData.get((String)homeName) == null) {
                if (new UtilPermission(this.plugin, cs).has("essence.home.list")) {
                    playerData.close();
                    UtilHome hu = new UtilHome(this.plugin);
                    StringBuilder setHomes = hu.getHomesList((Player)cs);
                    if (setHomes == null) {
                        msg.send("home", "noneset");
                        return true;
                    }
                    msg.send("home", "list", new String[]{setHomes.toString()});
                    return true;
                }
                msg.send("home", "notfound", new String[]{"home"});
            }
        }
        if (playerData.get((String)homeName) == null) {
            playerData.close();
            msg.send("generic", "exception");
            Logger log = new Logger(this.plugin.foundryConfig);
            log.warn("Player " + String.valueOf(cs) + " attempted to teleport home to " + chatHomeName + " but couldn't due to an error.");
            log.warn("Error: Unable to load from configuration file, please check configuration file.");
            return true;
        }
        if (playerData.getString((String)homeName + ".world") == null) {
            playerData.close();
            msg.send("generic", "exception");
            Logger log = new Logger(this.plugin.foundryConfig);
            log.warn("Player " + String.valueOf(cs) + " attempted to teleport home to " + chatHomeName + " but couldn't due to an error.");
            log.warn("Error: world is null, please check configuration file.");
            return true;
        }
        teleUtil.setCooldown((Player)cs, "home");
        World world = Bukkit.getServer().getWorld(playerData.getString((String)homeName + ".world"));
        if (world == null) {
            playerData.close();
            msg.send("generic", "exception");
            Logger log = new Logger(this.plugin.foundryConfig);
            log.warn("Player " + String.valueOf(cs) + " attempted to teleport home to " + chatHomeName + " but couldn't due to an error.");
            log.warn("Error: world '" + playerData.getString((String)homeName + ".world") + "' does not exist.");
            return true;
        }
        if (waitTime > 0) {
            msg.send("warp", "teleportingin", new String[]{chatHomeName, "" + waitTime});
        } else {
            msg.send("warp", "teleportingnow", new String[]{chatHomeName});
        }
        teleUtil.doTeleport((Player)cs, world, playerData.getDouble((String)homeName + ".X"), playerData.getDouble((String)homeName + ".Y"), playerData.getDouble((String)homeName + ".Z"), (float)playerData.getDouble((String)homeName + ".yaw"), (float)playerData.getDouble((String)homeName + ".pitch"), waitTime, true);
        playerData.close();
        return true;
    }
}

