/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.team;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.team.UtilTeam;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandTeam
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandTeam(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Player p = (Player)cs;
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        UtilPermission perms = new UtilPermission(this.plugin, cs);
        if (args.length <= 0) {
            msg.send("team", "malformed");
            return true;
        }
        UtilTeam team = new UtilTeam(this.plugin, msg);
        if (args[0].equalsIgnoreCase("create")) {
            if (!perms.has("essence.team.create")) return perms.not();
            if (args.length == 2) {
                team.create(args[1], p.getUniqueId());
                return true;
            }
            msg.send("team", "namerequired");
            return true;
        }
        if (args[0].equalsIgnoreCase("join")) {
            if (!perms.has("essence.team.join")) return perms.not();
            if (args.length != 2) {
                msg.send("team", "namerequired");
                return true;
            }
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (playerTeam == null) {
                team.requestJoin(args[1], p.getUniqueId());
                return true;
            }
            msg.send("team", "alreadyinteam", new String[]{playerTeam});
            return true;
        }
        if (args[0].equalsIgnoreCase("requests")) {
            if (!perms.has("essence.team.manage")) return perms.not();
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (playerTeam == null) {
                msg.send("team", "noteam");
                return true;
            }
            if (team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "teamrequests", new String[]{playerTeam, team.requestsToJoin(playerTeam)});
                msg.send("team", "howtoaccept");
                msg.send("team", "howtodecline");
                return true;
            }
            msg.send("team", "leaderrequired");
            return true;
        }
        if (args[0].equalsIgnoreCase("accept")) {
            if (!perms.has("essence.team.manage")) return perms.not();
            if (args.length <= 1) {
                msg.send("team", "usernamerequired");
                return true;
            }
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (!team.hasRequested(playerTeam, args[1])) {
                msg.send("team", "usernotrequested", new String[]{args[1], playerTeam});
                return true;
            }
            if (!team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "leaderrequired");
                return true;
            }
            if (team.acceptRequest(playerTeam, args[1])) {
                msg.send("team", "accepted", new String[]{args[1]});
                return true;
            }
            msg.send("generic", "exception");
            return true;
        }
        if (args[0].equalsIgnoreCase("decline")) {
            if (!perms.has("essence.team.manage")) return perms.not();
            if (args.length <= 1) {
                msg.send("team", "usernamerequired");
                return true;
            }
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (!team.hasRequested(playerTeam, args[1])) {
                msg.send("team", "usernotrequested", new String[]{args[1], playerTeam});
                return true;
            }
            if (!team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "leaderrequired");
                return true;
            }
            if (team.declineRequest(playerTeam, args[1])) {
                msg.send("team", "declined", new String[]{args[1]});
                return true;
            }
            msg.send("generic", "exception");
            return true;
        }
        if (args[0].equalsIgnoreCase("leave")) {
            if (!perms.has("essence.team.join")) return perms.not();
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (playerTeam == null) {
                msg.send("team", "noteam");
                return true;
            }
            if (team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "requiresdisband", new String[]{playerTeam});
                return true;
            }
            if (team.leave(playerTeam, p.getUniqueId())) {
                msg.send("team", "left", new String[]{playerTeam});
                return true;
            }
            msg.send("generic", "exception");
            return true;
        }
        if (args[0].equalsIgnoreCase("changeleader")) {
            if (!perms.has("essence.team.manage")) return perms.not();
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (args.length <= 1) {
                msg.send("team", "leadernamerequired");
                return true;
            }
            if (playerTeam == null) {
                msg.send("team", "noteam");
                return true;
            }
            if (!team.isMember(playerTeam, args[1])) {
                msg.send("team", "usernotmember", new String[]{args[1], playerTeam});
                return true;
            }
            if (!team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "leaderrequired");
                return true;
            }
            if (team.changeLeader(playerTeam, args[1], String.valueOf(p.getUniqueId()))) {
                msg.send("team", "leadertransfer", new String[]{args[1], playerTeam});
                return true;
            }
            msg.send("general", "exception");
            return true;
        }
        if (args[0].equalsIgnoreCase("kick")) {
            if (!perms.has("essence.team.manage")) return perms.not();
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (args.length <= 1) {
                msg.send("team", "usernamerequired");
                return true;
            }
            if (playerTeam == null) {
                msg.send("team", "noteam");
                return true;
            }
            if (!team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "leaderrequired");
                return true;
            }
            if (!team.isMember(playerTeam, args[1])) {
                msg.send("team", "usernotmember", new String[]{args[1], playerTeam});
                return true;
            }
            if (team.kick(playerTeam, args[1])) {
                msg.send("team", "kicked", new String[]{args[1], playerTeam});
                return true;
            }
            msg.send("generic", "exception");
            return true;
        }
        if (args[0].equalsIgnoreCase("disband")) {
            if (!perms.has("essence.team.manage")) return perms.not();
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (playerTeam == null) {
                msg.send("team", "noteam");
                return true;
            }
            if (!team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "leaderrequired");
                return true;
            }
            if (team.disband(playerTeam, p.getUniqueId().toString())) {
                msg.send("team", "disbanded", new String[]{playerTeam});
                return true;
            }
            msg.send("generic", "exception");
            return true;
        }
        if (args[0].equalsIgnoreCase("rule")) {
            if (!perms.has("essence.team.manage")) return perms.not();
            String playerTeam = team.getPlayerTeam(p.getUniqueId());
            if (playerTeam == null) {
                msg.send("team", "noteam");
                return true;
            }
            if (!team.isLeader(playerTeam, p.getUniqueId())) {
                msg.send("team", "leaderrequired");
                return true;
            }
            if (args.length > 1 && args[1].equalsIgnoreCase("allow-friendly-fire")) {
                boolean value;
                if (args.length <= 2) {
                    msg.send("team", "rulevalue", new String[]{args[1], String.valueOf(team.getRule(playerTeam, args[1]))});
                    return true;
                }
                if (args[2].equalsIgnoreCase("false")) {
                    value = false;
                } else {
                    if (!args[2].equalsIgnoreCase("true")) {
                        msg.send("team", "malformed");
                        return true;
                    }
                    value = true;
                }
                if (team.setRule(playerTeam, args[1], value)) {
                    msg.send("team", "rulechanged", new String[]{args[1], args[2]});
                    return true;
                }
                msg.send("team", "cantchangerule", new String[]{args[1], args[2]});
                return true;
            }
            if (args.length > 1) {
                msg.send("team", "rulenotfound", new String[]{args[1]});
                return true;
            }
            msg.send("team", "rulemissing");
            return true;
        }
        if (!perms.has("essence.team.list")) {
            msg.send("team", "malformed");
            return true;
        }
        if (team.exists(args[0])) {
            msg.send("team", "name", new String[]{args[0]});
            msg.send("team", "leader", new String[]{team.getTeamLeader(args[0])});
            msg.send("team", "members", new String[]{team.getTeamMembers(args[0])});
            return true;
        }
        msg.send("team", "malformed");
        return true;
    }
}

