/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.stats;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandGod
extends FoundryCommand {
    private final Essence plugin;

    public CommandGod(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.stats.god";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length > 0) {
            return this.godOther(new UtilPermission(this.plugin, cs), cs, message, args);
        }
        if (!(cs instanceof Player)) {
            message.send("god", "usage");
            return true;
        }
        return this.godSelf(cs, message);
    }

    private boolean godPlayer(Player player) {
        boolean newState = !player.isInvulnerable();
        player.setInvulnerable(newState);
        return newState;
    }

    private boolean godSelf(CommandSender sender, UtilMessage message) {
        Player player = (Player)sender;
        boolean isNowGod = this.godPlayer(player);
        message.send("god", isNowGod ? "beenenabled" : "beendisabled");
        return true;
    }

    private boolean godOther(UtilPermission permission, CommandSender sender, UtilMessage message, String[] args) {
        if (permission.has("essence.stats.god.other")) {
            String pName = args[0];
            Player p = Bukkit.getPlayer((String)pName);
            if (p != null) {
                boolean isNowGod = !p.isInvulnerable();
                message.send("god", isNowGod ? "enabled" : "disabled", new String[]{p.getName()});
                if (!(sender instanceof Player)) {
                    message.sendTo((CommandSender)p, "god", isNowGod ? "serverenabled" : "serverdisabled");
                } else {
                    message.sendTo((CommandSender)p, "god", isNowGod ? "enabledby" : "disabledby", new String[]{sender.getName()});
                }
                this.godPlayer(p);
            } else {
                message.send("generic", "playernotfound");
            }
            return true;
        }
        return permission.not();
    }
}

