/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.stats;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandFly
extends FoundryCommand {
    private final Essence plugin;

    public CommandFly(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.stats.fly";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length > 0) {
            return this.flyOther(new UtilPermission(this.plugin, cs), cs, message, args);
        }
        if (!(cs instanceof Player)) {
            message.send("fly", "usage");
            return true;
        }
        return this.flySelf((Player)cs, message);
    }

    private boolean flySelf(Player p, UtilMessage msg) {
        if (this.plugin.flyingPlayers != null && this.plugin.flyingPlayers.contains(p.getUniqueId())) {
            p.setFlying(false);
            p.setAllowFlight(false);
            this.plugin.flyingPlayers.remove(p.getUniqueId());
            msg.send("fly", "stopped");
        } else {
            p.setAllowFlight(true);
            p.setFlying(true);
            this.plugin.flyingPlayers.add(p.getUniqueId());
            msg.send("fly", "flying");
        }
        return true;
    }

    private boolean flyOther(UtilPermission perms, CommandSender cs, UtilMessage msg, String[] args) {
        if (perms.has("essence.stats.fly.other")) {
            Player p = Bukkit.getPlayer((String)args[0]);
            if (p != null) {
                if (this.plugin.flyingPlayers != null && this.plugin.flyingPlayers.contains(p.getUniqueId())) {
                    p.setFlying(false);
                    p.setAllowFlight(false);
                    msg.send("fly", "stopother", new String[]{p.getName()});
                    msg.sendTo((CommandSender)p, "fly", "stopbyother", new String[]{cs.getName()});
                    this.plugin.flyingPlayers.remove(p.getUniqueId());
                } else {
                    p.setAllowFlight(true);
                    p.setFlying(true);
                    msg.send("fly", "flyother", new String[]{p.getName()});
                    msg.sendTo((CommandSender)p, "fly", "flybyother", new String[]{cs.getName()});
                    this.plugin.flyingPlayers.add(p.getUniqueId());
                }
            } else {
                msg.send("generic", "playernotfound");
            }
            return true;
        }
        return perms.not();
    }
}

